/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai.core;

import cn.hutool.ai.AIException;
import cn.hutool.ai.core.AIConfig;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import java.util.Map;

public class BaseAIService {
    protected final AIConfig config;

    public BaseAIService(AIConfig config) {
        this.config = config;
    }

    protected HttpResponse sendGet(String endpoint) {
        try {
            return ((HttpRequest)((HttpRequest)HttpRequest.get(this.config.getApiUrl() + endpoint).header(Header.ACCEPT, "application/json")).header(Header.AUTHORIZATION, "Bearer " + this.config.getApiKey())).timeout(180000).execute();
        }
        catch (AIException e) {
            throw new AIException("Failed to send GET request: " + e.getMessage(), e);
        }
    }

    protected HttpResponse sendPost(String endpoint, String paramJson) {
        try {
            return ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post(this.config.getApiUrl() + endpoint).header(Header.CONTENT_TYPE, "application/json")).header(Header.ACCEPT, "application/json")).header(Header.AUTHORIZATION, "Bearer " + this.config.getApiKey())).body(paramJson).timeout(180000).execute();
        }
        catch (AIException e) {
            throw new AIException("Failed to send POST request\uff1a" + e.getMessage(), e);
        }
    }

    protected HttpResponse sendFormData(String endpoint, Map<String, Object> paramMap) {
        try {
            return ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post(this.config.getApiUrl() + endpoint).header(Header.CONTENT_TYPE, "multipart/form-data")).header(Header.ACCEPT, "application/json")).header(Header.AUTHORIZATION, "Bearer " + this.config.getApiKey())).form(paramMap).timeout(180000).execute();
        }
        catch (AIException e) {
            throw new AIException("Failed to send POST request\uff1a" + e.getMessage(), e);
        }
    }
}

