/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class DateIndexNameProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final List<String> dateFormats;
    private final String dateRounding;
    private final String field;
    private final String indexNameFormat;
    private final String indexNamePrefix;
    private final String locale;
    private final String timezone;
    public static final JsonpDeserializer<DateIndexNameProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateIndexNameProcessor::setupDateIndexNameProcessorDeserializer);

    private DateIndexNameProcessor(Builder builder) {
        super(builder);
        this.dateFormats = ApiTypeHelper.unmodifiableRequired(builder.dateFormats, (Object)this, "dateFormats");
        this.dateRounding = ApiTypeHelper.requireNonNull(builder.dateRounding, this, "dateRounding");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.indexNameFormat = ApiTypeHelper.requireNonNull(builder.indexNameFormat, this, "indexNameFormat");
        this.indexNamePrefix = ApiTypeHelper.requireNonNull(builder.indexNamePrefix, this, "indexNamePrefix");
        this.locale = ApiTypeHelper.requireNonNull(builder.locale, this, "locale");
        this.timezone = ApiTypeHelper.requireNonNull(builder.timezone, this, "timezone");
    }

    public static DateIndexNameProcessor of(Function<Builder, ObjectBuilder<DateIndexNameProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.DateIndexName;
    }

    public final List<String> dateFormats() {
        return this.dateFormats;
    }

    public final String dateRounding() {
        return this.dateRounding;
    }

    public final String field() {
        return this.field;
    }

    public final String indexNameFormat() {
        return this.indexNameFormat;
    }

    public final String indexNamePrefix() {
        return this.indexNamePrefix;
    }

    public final String locale() {
        return this.locale;
    }

    public final String timezone() {
        return this.timezone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.dateFormats)) {
            generator.writeKey("date_formats");
            generator.writeStartArray();
            for (String item0 : this.dateFormats) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("date_rounding");
        generator.write(this.dateRounding);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("index_name_format");
        generator.write(this.indexNameFormat);
        generator.writeKey("index_name_prefix");
        generator.write(this.indexNamePrefix);
        generator.writeKey("locale");
        generator.write(this.locale);
        generator.writeKey("timezone");
        generator.write(this.timezone);
    }

    protected static void setupDateIndexNameProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::dateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "date_formats");
        op.add(Builder::dateRounding, JsonpDeserializer.stringDeserializer(), "date_rounding");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::indexNameFormat, JsonpDeserializer.stringDeserializer(), "index_name_format");
        op.add(Builder::indexNamePrefix, JsonpDeserializer.stringDeserializer(), "index_name_prefix");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.add(Builder::timezone, JsonpDeserializer.stringDeserializer(), "timezone");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateIndexNameProcessor> {
        private List<String> dateFormats;
        private String dateRounding;
        private String field;
        private String indexNameFormat;
        private String indexNamePrefix;
        private String locale;
        private String timezone;

        public final Builder dateFormats(List<String> list) {
            this.dateFormats = Builder._listAddAll(this.dateFormats, list);
            return this;
        }

        public final Builder dateFormats(String value, String ... values) {
            this.dateFormats = Builder._listAdd(this.dateFormats, value, values);
            return this;
        }

        public final Builder dateRounding(String value) {
            this.dateRounding = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder indexNameFormat(String value) {
            this.indexNameFormat = value;
            return this;
        }

        public final Builder indexNamePrefix(String value) {
            this.indexNamePrefix = value;
            return this;
        }

        public final Builder locale(String value) {
            this.locale = value;
            return this;
        }

        public final Builder timezone(String value) {
            this.timezone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateIndexNameProcessor build() {
            this._checkSingleUse();
            return new DateIndexNameProcessor(this);
        }
    }
}

