/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.IcuCollationAlternate;
import co.elastic.clients.elasticsearch._types.analysis.IcuCollationCaseFirst;
import co.elastic.clients.elasticsearch._types.analysis.IcuCollationDecomposition;
import co.elastic.clients.elasticsearch._types.analysis.IcuCollationStrength;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IcuCollationTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final IcuCollationAlternate alternate;
    @Nullable
    private final IcuCollationCaseFirst caseFirst;
    @Nullable
    private final Boolean caseLevel;
    @Nullable
    private final String country;
    @Nullable
    private final IcuCollationDecomposition decomposition;
    @Nullable
    private final Boolean hiraganaQuaternaryMode;
    @Nullable
    private final String language;
    @Nullable
    private final Boolean numeric;
    @Nullable
    private final String rules;
    @Nullable
    private final IcuCollationStrength strength;
    @Nullable
    private final String variableTop;
    @Nullable
    private final String variant;
    public static final JsonpDeserializer<IcuCollationTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuCollationTokenFilter::setupIcuCollationTokenFilterDeserializer);

    private IcuCollationTokenFilter(Builder builder) {
        super(builder);
        this.alternate = builder.alternate;
        this.caseFirst = builder.caseFirst;
        this.caseLevel = builder.caseLevel;
        this.country = builder.country;
        this.decomposition = builder.decomposition;
        this.hiraganaQuaternaryMode = builder.hiraganaQuaternaryMode;
        this.language = builder.language;
        this.numeric = builder.numeric;
        this.rules = builder.rules;
        this.strength = builder.strength;
        this.variableTop = builder.variableTop;
        this.variant = builder.variant;
    }

    public static IcuCollationTokenFilter of(Function<Builder, ObjectBuilder<IcuCollationTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuCollation;
    }

    @Nullable
    public final IcuCollationAlternate alternate() {
        return this.alternate;
    }

    @Nullable
    public final IcuCollationCaseFirst caseFirst() {
        return this.caseFirst;
    }

    @Nullable
    public final Boolean caseLevel() {
        return this.caseLevel;
    }

    @Nullable
    public final String country() {
        return this.country;
    }

    @Nullable
    public final IcuCollationDecomposition decomposition() {
        return this.decomposition;
    }

    @Nullable
    public final Boolean hiraganaQuaternaryMode() {
        return this.hiraganaQuaternaryMode;
    }

    @Nullable
    public final String language() {
        return this.language;
    }

    @Nullable
    public final Boolean numeric() {
        return this.numeric;
    }

    @Nullable
    public final String rules() {
        return this.rules;
    }

    @Nullable
    public final IcuCollationStrength strength() {
        return this.strength;
    }

    @Nullable
    public final String variableTop() {
        return this.variableTop;
    }

    @Nullable
    public final String variant() {
        return this.variant;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_collation");
        super.serializeInternal(generator, mapper);
        if (this.alternate != null) {
            generator.writeKey("alternate");
            this.alternate.serialize(generator, mapper);
        }
        if (this.caseFirst != null) {
            generator.writeKey("case_first");
            this.caseFirst.serialize(generator, mapper);
        }
        if (this.caseLevel != null) {
            generator.writeKey("case_level");
            generator.write(this.caseLevel.booleanValue());
        }
        if (this.country != null) {
            generator.writeKey("country");
            generator.write(this.country);
        }
        if (this.decomposition != null) {
            generator.writeKey("decomposition");
            this.decomposition.serialize(generator, mapper);
        }
        if (this.hiraganaQuaternaryMode != null) {
            generator.writeKey("hiragana_quaternary_mode");
            generator.write(this.hiraganaQuaternaryMode.booleanValue());
        }
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
        if (this.numeric != null) {
            generator.writeKey("numeric");
            generator.write(this.numeric.booleanValue());
        }
        if (this.rules != null) {
            generator.writeKey("rules");
            generator.write(this.rules);
        }
        if (this.strength != null) {
            generator.writeKey("strength");
            this.strength.serialize(generator, mapper);
        }
        if (this.variableTop != null) {
            generator.writeKey("variable_top");
            generator.write(this.variableTop);
        }
        if (this.variant != null) {
            generator.writeKey("variant");
            generator.write(this.variant);
        }
    }

    protected static void setupIcuCollationTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::alternate, IcuCollationAlternate._DESERIALIZER, "alternate");
        op.add(Builder::caseFirst, IcuCollationCaseFirst._DESERIALIZER, "case_first");
        op.add(Builder::caseLevel, JsonpDeserializer.booleanDeserializer(), "case_level");
        op.add(Builder::country, JsonpDeserializer.stringDeserializer(), "country");
        op.add(Builder::decomposition, IcuCollationDecomposition._DESERIALIZER, "decomposition");
        op.add(Builder::hiraganaQuaternaryMode, JsonpDeserializer.booleanDeserializer(), "hiragana_quaternary_mode");
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.add(Builder::numeric, JsonpDeserializer.booleanDeserializer(), "numeric");
        op.add(Builder::rules, JsonpDeserializer.stringDeserializer(), "rules");
        op.add(Builder::strength, IcuCollationStrength._DESERIALIZER, "strength");
        op.add(Builder::variableTop, JsonpDeserializer.stringDeserializer(), "variable_top");
        op.add(Builder::variant, JsonpDeserializer.stringDeserializer(), "variant");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuCollationTokenFilter> {
        @Nullable
        private IcuCollationAlternate alternate;
        @Nullable
        private IcuCollationCaseFirst caseFirst;
        @Nullable
        private Boolean caseLevel;
        @Nullable
        private String country;
        @Nullable
        private IcuCollationDecomposition decomposition;
        @Nullable
        private Boolean hiraganaQuaternaryMode;
        @Nullable
        private String language;
        @Nullable
        private Boolean numeric;
        @Nullable
        private String rules;
        @Nullable
        private IcuCollationStrength strength;
        @Nullable
        private String variableTop;
        @Nullable
        private String variant;

        public final Builder alternate(@Nullable IcuCollationAlternate value) {
            this.alternate = value;
            return this;
        }

        public final Builder caseFirst(@Nullable IcuCollationCaseFirst value) {
            this.caseFirst = value;
            return this;
        }

        public final Builder caseLevel(@Nullable Boolean value) {
            this.caseLevel = value;
            return this;
        }

        public final Builder country(@Nullable String value) {
            this.country = value;
            return this;
        }

        public final Builder decomposition(@Nullable IcuCollationDecomposition value) {
            this.decomposition = value;
            return this;
        }

        public final Builder hiraganaQuaternaryMode(@Nullable Boolean value) {
            this.hiraganaQuaternaryMode = value;
            return this;
        }

        public final Builder language(@Nullable String value) {
            this.language = value;
            return this;
        }

        public final Builder numeric(@Nullable Boolean value) {
            this.numeric = value;
            return this;
        }

        public final Builder rules(@Nullable String value) {
            this.rules = value;
            return this;
        }

        public final Builder strength(@Nullable IcuCollationStrength value) {
            this.strength = value;
            return this;
        }

        public final Builder variableTop(@Nullable String value) {
            this.variableTop = value;
            return this;
        }

        public final Builder variant(@Nullable String value) {
            this.variant = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuCollationTokenFilter build() {
            this._checkSingleUse();
            return new IcuCollationTokenFilter(this);
        }
    }
}

