/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.dysmsapi20180501.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SmsConversionRequest
extends Request {
    @Query
    @NameInMap(value="ConversionTime")
    private Long conversionTime;
    @Query
    @NameInMap(value="Delivered")
    @Validation(required=true)
    private Boolean delivered;
    @Query
    @NameInMap(value="MessageId")
    private String messageId;
    @Query
    @NameInMap(value="To")
    private String to;

    private SmsConversionRequest(Builder builder) {
        super((Request.Builder)builder);
        this.conversionTime = builder.conversionTime;
        this.delivered = builder.delivered;
        this.messageId = builder.messageId;
        this.to = builder.to;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SmsConversionRequest create() {
        return SmsConversionRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getConversionTime() {
        return this.conversionTime;
    }

    public Boolean getDelivered() {
        return this.delivered;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getTo() {
        return this.to;
    }

    public static final class Builder
    extends Request.Builder<SmsConversionRequest, Builder> {
        private Long conversionTime;
        private Boolean delivered;
        private String messageId;
        private String to;

        private Builder() {
        }

        private Builder(SmsConversionRequest request) {
            super((Request)request);
            this.conversionTime = request.conversionTime;
            this.delivered = request.delivered;
            this.messageId = request.messageId;
            this.to = request.to;
        }

        public Builder conversionTime(Long conversionTime) {
            this.putQueryParameter("ConversionTime", conversionTime);
            this.conversionTime = conversionTime;
            return this;
        }

        public Builder delivered(Boolean delivered) {
            this.putQueryParameter("Delivered", delivered);
            this.delivered = delivered;
            return this;
        }

        public Builder messageId(String messageId) {
            this.putQueryParameter("MessageId", messageId);
            this.messageId = messageId;
            return this;
        }

        public Builder to(String to) {
            this.putQueryParameter("To", to);
            this.to = to;
            return this;
        }

        public SmsConversionRequest build() {
            return new SmsConversionRequest(this);
        }
    }
}

