package com.aliyun.httpcomponent.httpclient.implementation;

import com.aliyun.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import com.aliyun.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import com.aliyun.apache.hc.core5.http.HttpResponse;
import com.aliyun.apache.hc.core5.http.protocol.HttpContext;
import com.aliyun.apache.hc.core5.util.TimeValue;

public class SdkConnectionKeepAliveStrategy implements ConnectionKeepAliveStrategy {

    private final long maxIdleTime;

    public SdkConnectionKeepAliveStrategy(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public TimeValue getKeepAliveDuration(
            HttpResponse response,
            HttpContext context) {

        // If there's a Keep-Alive timeout directive in the response and it's
        // shorter than our configured max, honor that. Otherwise go with the
        // configured maximum.

        long duration = DefaultConnectionKeepAliveStrategy.INSTANCE
                .getKeepAliveDuration(response, context).getDuration();

        if (0 < duration && duration < maxIdleTime) {
            return TimeValue.ofMilliseconds(duration);
        }

        return TimeValue.ofMilliseconds(maxIdleTime);
    }
}

