/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.Ansi;
import com.blade.kit.BladeCache;
import com.blade.kit.StringKit;
import com.blade.mvc.Const;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.route.Route;
import com.blade.task.TaskStruct;
import com.blade.task.annotation.Schedule;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.SerializedLambda;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class BladeKit {
    private static boolean isWindows = System.getProperties().getProperty("os.name").toLowerCase().contains("win");

    public static String getLambdaFieldName(Serializable lambda) {
        for (Class<?> cl = lambda.getClass(); cl != null; cl = cl.getSuperclass()) {
            try {
                Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                Object replacement = m.invoke((Object)lambda, new Object[0]);
                if (replacement instanceof SerializedLambda) {
                    SerializedLambda serializedLambda = (SerializedLambda)replacement;
                    return BladeCache.getLambdaFieldName(serializedLambda);
                }
                break;
            }
            catch (NoSuchMethodException m) {
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                break;
            }
        }
        return null;
    }

    public static String methodToFieldName(String methodName) {
        return BladeKit.capitalize(methodName.replace("get", ""));
    }

    public static String capitalize(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1, input.length());
    }

    public static List<TaskStruct> getTasks(Class<?> type) {
        return Arrays.stream(type.getMethods()).filter(m -> null != m.getAnnotation(Schedule.class)).map(m -> {
            TaskStruct taskStruct = new TaskStruct();
            taskStruct.setSchedule(m.getAnnotation(Schedule.class));
            taskStruct.setMethod((Method)m);
            taskStruct.setType(type);
            return taskStruct;
        }).collect(Collectors.toList());
    }

    public static boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    public static <T> boolean isEmpty(T[] arr) {
        return null == arr || arr.length == 0;
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return null != c && !c.isEmpty();
    }

    public static boolean isWebHook(HttpMethod httpMethod) {
        return httpMethod == HttpMethod.BEFORE || httpMethod == HttpMethod.AFTER;
    }

    public static boolean epollIsAvailable() {
        try {
            Object obj = Class.forName("io.netty.channel.epoll.Epoll").getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
            return null != obj && Boolean.valueOf(obj.toString()) != false && System.getProperty("os.name").toLowerCase().contains("linux");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> void okThen(T value, Predicate<T> predicate, Consumer<T> consumer) {
        if (predicate.test(value)) {
            consumer.accept(value);
        }
    }

    public static <T> void equalThen(T a, T b, BiConsumer<T, T> consumer) {
        if (a.equals(b)) {
            consumer.accept(a, b);
        }
    }

    public static <T> void notNullThen(T value, Consumer<T> consumer) {
        if (null != value) {
            consumer.accept(value);
        }
    }

    public static boolean runtimeIsJAR() {
        return Const.CLASSPATH.endsWith(".jar");
    }

    public static String getCurrentClassPath() {
        String path;
        URL url = BladeKit.class.getResource("/");
        if (null == url) {
            File f = new File(BladeKit.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            path = f.getPath();
        } else {
            path = url.getPath();
        }
        if (BladeKit.isWindows()) {
            return BladeKit.decode(path.replaceFirst("^/(.:/)", "$1"));
        }
        return BladeKit.decode(path);
    }

    private static String decode(String path) {
        try {
            return URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return path;
        }
    }

    public static long getCostMS(Instant start) {
        return Duration.between(start, Instant.now()).toMillis();
    }

    public static void log500(Logger log, String method, String uri) {
        String pad = StringKit.padLeft("", 6);
        String msg500 = Ansi.BgRed.and(Ansi.Black).format(" 500 ", new Object[0]);
        log.error("{} {}  {} {}", new Object[]{msg500, pad, method, uri});
    }

    public static void log304(Logger log, String method, String uri) {
        if (!log.isWarnEnabled()) {
            return;
        }
        String pad = StringKit.padLeft("", 6);
        String msg304 = Ansi.BgGreen.and(Ansi.Black).format(" 304 ", new Object[0]);
        log.warn("{} {}  {} {}", new Object[]{msg304, pad, method, uri});
    }

    public static void log200(Logger log, String method, String uri) {
        if (!log.isInfoEnabled()) {
            return;
        }
        String pad = StringKit.padLeft("", 6);
        String msg200 = Ansi.BgGreen.and(Ansi.Black).format(" 200 ", new Object[0]);
        log.info("{} {}  {} {}", new Object[]{msg200, pad, method, uri});
    }

    public static long log200AndCost(Logger log, Instant start, String method, String uri) {
        long cost = BladeKit.getCostMS(start);
        if (!log.isInfoEnabled()) {
            return cost;
        }
        String pad = StringKit.padLeft(String.valueOf(cost) + "ms", 6);
        String msg200 = Ansi.BgGreen.and(Ansi.Black).format(" 200 ", new Object[0]);
        log.info("{} {}  {} {}", new Object[]{msg200, pad, method, uri});
        return cost;
    }

    public static void log403(Logger log, String method, String uri) {
        if (!log.isWarnEnabled()) {
            return;
        }
        String pad = StringKit.padLeft("", 6);
        String msg403 = Ansi.BgYellow.and(Ansi.Black).format(" 403 ", new Object[0]);
        log.warn("{} {}  {} {}", new Object[]{msg403, pad, method, uri});
    }

    public static void log404(Logger log, String method, String uri) {
        if (!log.isWarnEnabled()) {
            return;
        }
        String pad = StringKit.padLeft("", 6);
        String msg404 = Ansi.BgRed.and(Ansi.Black).format(" 404 ", new Object[0]);
        log.warn("{} {}  {} {}", new Object[]{msg404, pad, method, uri});
    }

    public static void log405(Logger log, String method, String uri) {
        if (!log.isWarnEnabled()) {
            return;
        }
        String pad = StringKit.padLeft("", 6);
        String msg404 = Ansi.BgRed.and(Ansi.Black).format(" 405 ", new Object[0]);
        log.warn("{} {}  {} {}", new Object[]{msg404, pad, method, uri});
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static String getStartedSymbol() {
        return BladeKit.isWindows() ? "" : "\u00bb ";
    }

    public static String getPrefixSymbol() {
        return BladeKit.isWindows() ? "=> " : "\u00bb ";
    }

    public static void logAddRoute(Logger log, Route route) {
        String method = StringKit.padRight(route.getHttpMethod().name(), 6);
        switch (route.getHttpMethod()) {
            case ALL: {
                method = Ansi.BgBlack.and(Ansi.White).format(" %s ", method);
                break;
            }
            case GET: {
                method = Ansi.BgGreen.and(Ansi.Black).format(" %s ", method);
                break;
            }
            case POST: {
                method = Ansi.BgBlue.and(Ansi.Black).format(" %s ", method);
                break;
            }
            case DELETE: {
                method = Ansi.BgRed.and(Ansi.Black).format(" %s ", method);
                break;
            }
            case PUT: {
                method = Ansi.BgYellow.and(Ansi.Black).format(" %s ", method);
                break;
            }
            case OPTIONS: {
                method = Ansi.BgCyan.and(Ansi.Black).format(" %s ", method);
                break;
            }
            case BEFORE: {
                method = Ansi.BgMagenta.and(Ansi.Black).format(" %s ", method);
                break;
            }
            case AFTER: {
                method = Ansi.BgWhite.and(Ansi.Black).format(" %s ", method);
            }
        }
        String msg = route.getHttpMethod().equals((Object)HttpMethod.BEFORE) || route.getHttpMethod().equals((Object)HttpMethod.AFTER) ? " hook" : "route";
        log.info("{}Add {} {} {}", new Object[]{BladeKit.getStartedSymbol(), msg, method, route.getPath()});
    }

    public static void logWebSocket(Logger log, String path) {
        log.info("{}Add WebSocket {}", (Object)BladeKit.getStartedSymbol(), (Object)path);
    }

    public static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        if (null == args || args.length == 0) {
            return argsMap;
        }
        for (String arg : args) {
            if (!arg.startsWith("--") || !arg.contains("=")) continue;
            String[] param = arg.substring(2).split("=");
            argsMap.put(param[0], param[1]);
        }
        return argsMap;
    }

    public static Integer getPID() {
        String mbean = ManagementFactory.getRuntimeMXBean().getName();
        if (mbean.contains("@")) {
            return Integer.valueOf(mbean.substring(0, mbean.indexOf("@")));
        }
        return -1;
    }

    private BladeKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

