/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.cors;

import com.blade.mvc.RouteContext;
import com.blade.mvc.handler.RouteHandler;
import com.blade.mvc.http.Response;
import com.blade.security.web.cors.CorsConfiger;
import java.util.StringJoiner;
import java.util.stream.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsMiddleware
implements RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(CorsMiddleware.class);
    private CorsConfiger corsConfig;

    public CorsMiddleware() {
    }

    public CorsMiddleware(CorsConfiger corsConfiger) {
        this.corsConfig = corsConfiger;
    }

    @Override
    public void handle(RouteContext context) {
        context.header("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
        context.header("Access-Control-Allow-Origin", "*");
        context.header("Access-Control-Allow-Headers", "*");
        context.status(204);
    }

    private CorsMiddleware allowHeads(Response response) {
        boolean isDefaultAllowHeads;
        boolean bl = isDefaultAllowHeads = this.corsConfig == null || this.corsConfig.getAllowedHeaders() == null || this.corsConfig.getAllowedHeaders().size() == 0;
        if (isDefaultAllowHeads) {
            response.header("Access-Control-Allow-Headers", "*");
            return this;
        }
        String heads = this.corsConfig.getAllowedHeaders().stream().collect(Collector.of(() -> new StringJoiner(","), StringJoiner::add, StringJoiner::merge, StringJoiner::toString, new Collector.Characteristics[0]));
        response.header("Access-Control-Allow-Headers", heads);
        return this;
    }

    private CorsMiddleware allowMethods(Response response) {
        boolean isDefaultAllowMethods;
        boolean bl = isDefaultAllowMethods = this.corsConfig == null || this.corsConfig.getAllowedMethods() == null || this.corsConfig.getAllowedMethods().size() == 0;
        if (isDefaultAllowMethods) {
            response.header("Access-Control-Allow-Methods", "GET, OPTIONS, HEAD, PUT, POST, DELETE");
            return this;
        }
        String methods = this.corsConfig.getAllowedMethods().stream().collect(Collector.of(() -> new StringJoiner(", "), (j, method) -> j.add(method.toUpperCase()), StringJoiner::merge, StringJoiner::toString, new Collector.Characteristics[0]));
        response.header("Access-Control-Allow-Methods", methods);
        return this;
    }

    private CorsMiddleware allowCredentials(Response response) {
        boolean isDefaultAllowCredentials;
        boolean bl = isDefaultAllowCredentials = this.corsConfig == null || this.corsConfig.getAllowCredentials() == null;
        if (isDefaultAllowCredentials) {
            response.header("Access-Control-Allow-Credentials", "true");
            return this;
        }
        response.header("Access-Control-Allow-Credentials", this.corsConfig.getAllowCredentials().toString());
        return this;
    }

    private CorsMiddleware setMaxAge(Response response) {
        boolean isDefaultMaxAge;
        boolean bl = isDefaultMaxAge = this.corsConfig == null || this.corsConfig.getMaxAge() == null;
        if (isDefaultMaxAge) {
            response.header("Access-Control-Max-Age", CorsConfiger.DEFAULT_MAX_AGE.toString());
            return this;
        }
        response.header("Access-Control-Max-Age", this.corsConfig.getMaxAge().toString());
        return this;
    }
}

