/*
 * Decompiled with CFR 0.152.
 */
package com.blade.task;

import com.blade.kit.BladeKit;
import com.blade.task.cron.CronExpression;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    private String name;
    private Runnable task;
    private ScheduledFuture<?> future;
    private CronExpression cronExpression;
    private volatile boolean isRunning = true;
    private long delay;

    public Task(String name, CronExpression cronExpression, long delay) {
        this.name = name;
        this.cronExpression = cronExpression;
        this.delay = delay;
    }

    public boolean stop() {
        if (!this.isRunning) {
            return true;
        }
        this.isRunning = false;
        boolean flag = this.future.cancel(true);
        log.info("{}Task [{}] stoped", (Object)BladeKit.getStartedSymbol(), (Object)this.name);
        return flag;
    }

    private Task() {
    }

    public String getName() {
        return this.name;
    }

    public Runnable getTask() {
        return this.task;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTask(Runnable task) {
        this.task = task;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }

    public void setCronExpression(CronExpression cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Runnable this$task = this.getTask();
        Runnable other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        ScheduledFuture<?> this$future = this.getFuture();
        ScheduledFuture<?> other$future = other.getFuture();
        if (this$future == null ? other$future != null : !this$future.equals(other$future)) {
            return false;
        }
        CronExpression this$cronExpression = this.getCronExpression();
        CronExpression other$cronExpression = other.getCronExpression();
        if (this$cronExpression == null ? other$cronExpression != null : !this$cronExpression.equals(other$cronExpression)) {
            return false;
        }
        if (this.isRunning() != other.isRunning()) {
            return false;
        }
        return this.getDelay() == other.getDelay();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Runnable $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        ScheduledFuture<?> $future = this.getFuture();
        result = result * 59 + ($future == null ? 43 : $future.hashCode());
        CronExpression $cronExpression = this.getCronExpression();
        result = result * 59 + ($cronExpression == null ? 43 : $cronExpression.hashCode());
        result = result * 59 + (this.isRunning() ? 79 : 97);
        long $delay = this.getDelay();
        result = result * 59 + (int)($delay >>> 32 ^ $delay);
        return result;
    }

    public String toString() {
        return "Task(name=" + this.getName() + ", task=" + this.getTask() + ", future=" + this.getFuture() + ", cronExpression=" + this.getCronExpression() + ", isRunning=" + this.isRunning() + ", delay=" + this.getDelay() + ")";
    }
}

