/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.logger;

import com.codingapi.txlcn.common.util.SpringUtils;
import com.codingapi.txlcn.logger.db.LogDbHelper;
import com.codingapi.txlcn.logger.db.LogDbProperties;
import com.codingapi.txlcn.logger.exception.TxLoggerException;
import com.codingapi.txlcn.logger.helper.MysqlLoggerHelper;
import com.codingapi.txlcn.logger.helper.TxLcnLogDbHelper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@ComponentScan
@Configuration
public class TxLoggerConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TxLcnLogDbHelper txLcnLoggerHelper() {
        return new MysqlLoggerHelper();
    }

    @Bean
    public SpringUtils springUtils() {
        return new SpringUtils();
    }

    @Configuration
    @ConditionalOnProperty(name={"tx-lcn.logger.enabled"}, havingValue="true")
    class LoggerEnabledTrueConfig {
        LoggerEnabledTrueConfig() {
        }

        @Bean
        public LogDbHelper logDbHelper(LogDbProperties logDbProperties) throws TxLoggerException {
            return new LogDbHelper(logDbProperties);
        }
    }
}

