/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.aspect.interceptor;

import com.codingapi.txlcn.tc.annotation.DTXPropagation;
import com.codingapi.txlcn.tc.annotation.LcnTransaction;
import com.codingapi.txlcn.tc.annotation.TccTransaction;
import com.codingapi.txlcn.tc.annotation.TxTransaction;
import com.codingapi.txlcn.tc.annotation.TxcTransaction;
import com.codingapi.txlcn.tc.aspect.DTXInfo;
import java.util.Objects;
import java.util.Properties;
import org.aopalliance.intercept.MethodInvocation;

class InterceptorInvocationUtils {
    InterceptorInvocationUtils() {
    }

    static DTXInfo load(MethodInvocation invocation, Properties transactionAttributes) {
        TxTransaction txTransaction;
        String transactionType = "lcn";
        DTXPropagation dtxPropagation = DTXPropagation.REQUIRED;
        if (transactionAttributes != null) {
            transactionType = transactionAttributes.getProperty("DTX_TYPE");
            dtxPropagation = DTXPropagation.parser(transactionAttributes.getProperty("DTX_PROPAGATION"));
        }
        if (Objects.nonNull(txTransaction = invocation.getMethod().getAnnotation(TxTransaction.class))) {
            transactionType = txTransaction.type();
            dtxPropagation = txTransaction.propagation();
        } else {
            LcnTransaction lcnTransaction = invocation.getMethod().getAnnotation(LcnTransaction.class);
            if (Objects.nonNull(lcnTransaction)) {
                transactionType = "lcn";
                dtxPropagation = lcnTransaction.propagation();
            } else {
                TxcTransaction txcTransaction = invocation.getMethod().getAnnotation(TxcTransaction.class);
                if (Objects.nonNull(txcTransaction)) {
                    transactionType = "txc";
                    dtxPropagation = txcTransaction.propagation();
                } else {
                    TccTransaction tccTransaction = invocation.getMethod().getAnnotation(TccTransaction.class);
                    if (Objects.nonNull(tccTransaction)) {
                        transactionType = "tcc";
                        dtxPropagation = tccTransaction.propagation();
                    }
                }
            }
        }
        DTXInfo dtxInfo = DTXInfo.getFromCache(invocation);
        dtxInfo.setTransactionType(transactionType);
        dtxInfo.setTransactionPropagation(dtxPropagation);
        return dtxInfo;
    }
}

