/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.checking;

import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tc.config.TxClientConfig;
import com.codingapi.txlcn.tc.core.checking.DTXChecking;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.context.TxContext;
import com.codingapi.txlcn.tc.core.template.TransactionCleanTemplate;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLogger;
import com.codingapi.txlcn.tc.txmsg.ReliableMessenger;
import com.codingapi.txlcn.tc.txmsg.TMReporter;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleDTXChecking
implements DTXChecking,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SimpleDTXChecking.class);
    private static final Map<String, ScheduledFuture> delayTasks = new ConcurrentHashMap<String, ScheduledFuture>();
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private static final TxLogger txLogger = TxLogger.newLogger(SimpleDTXChecking.class);
    private TransactionCleanTemplate transactionCleanTemplate;
    private final ReliableMessenger reliableMessenger;
    private final TxClientConfig clientConfig;
    private final AspectLogger aspectLogger;
    private final TMReporter tmReporter;
    private final TCGlobalContext globalContext;

    @Autowired
    public SimpleDTXChecking(TxClientConfig clientConfig, AspectLogger aspectLogger, TMReporter tmReporter, TCGlobalContext globalContext, ReliableMessenger reliableMessenger) {
        this.clientConfig = clientConfig;
        this.aspectLogger = aspectLogger;
        this.tmReporter = tmReporter;
        this.globalContext = globalContext;
        this.reliableMessenger = reliableMessenger;
    }

    public void setTransactionCleanTemplate(TransactionCleanTemplate transactionCleanTemplate) {
        this.transactionCleanTemplate = transactionCleanTemplate;
    }

    @Override
    public void startDelayCheckingAsync(String groupId, String unitId, String transactionType) {
        txLogger.taskTrace(groupId, unitId, "start delay checking task", new Object[0]);
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(() -> {
            try {
                TxContext txContext = this.globalContext.txContext(groupId);
                if (Objects.nonNull(txContext)) {
                    Object object = txContext.getLock();
                    synchronized (object) {
                        txLogger.taskTrace(groupId, unitId, "checking waiting for business code finish.", new Object[0]);
                        txContext.getLock().wait();
                    }
                }
                int state = this.reliableMessenger.askTransactionState(groupId, unitId);
                txLogger.taskTrace(groupId, unitId, "ask transaction state {}", new Object[]{state});
                if (state == -1) {
                    txLogger.error(this.getClass().getSimpleName(), "delay clean transaction error.", new Object[0]);
                    this.onAskTransactionStateException(groupId, unitId, transactionType);
                } else {
                    this.transactionCleanTemplate.clean(groupId, unitId, transactionType, state);
                    this.aspectLogger.clearLog(groupId, unitId);
                }
            }
            catch (RpcException e) {
                this.onAskTransactionStateException(groupId, unitId, transactionType);
            }
            catch (TransactionClearException | InterruptedException e) {
                txLogger.error(this.getClass().getSimpleName(), "{} clean transaction error.", new Object[]{transactionType});
            }
        }, this.clientConfig.getDtxTime(), TimeUnit.MILLISECONDS);
        delayTasks.put(groupId + unitId, scheduledFuture);
    }

    @Override
    public void stopDelayChecking(String groupId, String unitId) {
        ScheduledFuture scheduledFuture = delayTasks.get(groupId + unitId);
        if (Objects.nonNull(scheduledFuture)) {
            txLogger.taskTrace(groupId, unitId, "cancel {}:{} checking.", new Object[]{groupId, unitId});
            scheduledFuture.cancel(true);
        }
    }

    private void onAskTransactionStateException(String groupId, String unitId, String transactionType) {
        try {
            this.tmReporter.reportTransactionState(groupId, unitId, (short)1, 0);
            log.warn("{} > has compensation info!", (Object)transactionType);
            this.transactionCleanTemplate.cleanWithoutAspectLog(groupId, unitId, transactionType, 0);
        }
        catch (TransactionClearException e) {
            txLogger.error(groupId, unitId, "Transaction Task", "{} > clean transaction error.", new Object[]{transactionType});
        }
    }

    public void destroy() {
        scheduledExecutorService.shutdown();
        try {
            scheduledExecutorService.awaitTermination(6L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

