/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.template;

import com.codingapi.txlcn.common.exception.LcnBusinessException;
import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tc.aspect.TransactionInfo;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.checking.DTXChecking;
import com.codingapi.txlcn.tc.core.checking.DTXExceptionHandler;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.template.TransactionCleanTemplate;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLogger;
import com.codingapi.txlcn.tc.txmsg.ReliableMessenger;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionControlTemplate {
    private static final TxLogger txLogger = TxLogger.newLogger(TransactionControlTemplate.class);
    private final AspectLogger aspectLogger;
    private final DTXChecking dtxChecking;
    private final DTXExceptionHandler dtxExceptionHandler;
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final ReliableMessenger reliableMessenger;
    private final TCGlobalContext globalContext;

    @Autowired
    public TransactionControlTemplate(AspectLogger aspectLogger, DTXChecking dtxChecking, DTXExceptionHandler dtxExceptionHandler, TransactionCleanTemplate transactionCleanTemplate, ReliableMessenger reliableMessenger, TCGlobalContext globalContext) {
        this.aspectLogger = aspectLogger;
        this.dtxChecking = dtxChecking;
        this.dtxExceptionHandler = dtxExceptionHandler;
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.reliableMessenger = reliableMessenger;
        this.globalContext = globalContext;
    }

    public void createGroup(String groupId, String unitId, TransactionInfo transactionInfo, String transactionType) throws TransactionException {
        try {
            txLogger.txTrace(groupId, unitId, "create group > transaction type: {}", new Object[]{transactionType});
            this.reliableMessenger.createGroup(groupId);
            this.aspectLogger.trace(groupId, unitId, transactionInfo);
        }
        catch (RpcException e) {
            this.dtxExceptionHandler.handleCreateGroupMessageException(groupId, e);
        }
        catch (LcnBusinessException e) {
            this.dtxExceptionHandler.handleCreateGroupBusinessException(groupId, e.getCause());
        }
        txLogger.txTrace(groupId, unitId, "create group over", new Object[0]);
    }

    public void joinGroup(String groupId, String unitId, String transactionType, TransactionInfo transactionInfo) throws TransactionException {
        try {
            txLogger.txTrace(groupId, unitId, "join group > transaction type: {}", new Object[]{transactionType});
            this.reliableMessenger.joinGroup(groupId, unitId, transactionType, DTXLocalContext.transactionState(this.globalContext.dtxState(groupId)));
            txLogger.txTrace(groupId, unitId, "join group message over.", new Object[0]);
            this.dtxChecking.startDelayCheckingAsync(groupId, unitId, transactionType);
            this.aspectLogger.trace(groupId, unitId, transactionInfo);
        }
        catch (RpcException e) {
            this.dtxExceptionHandler.handleJoinGroupMessageException(Arrays.asList(groupId, unitId, transactionType), e);
        }
        catch (LcnBusinessException e) {
            this.dtxExceptionHandler.handleJoinGroupBusinessException(Arrays.asList(groupId, unitId, transactionType), e);
        }
        txLogger.txTrace(groupId, unitId, "join group logic over", new Object[0]);
    }

    public void notifyGroup(String groupId, String unitId, String transactionType, int state) {
        try {
            txLogger.txTrace(groupId, unitId, "notify group > transaction type: {}, state: {}.", new Object[]{transactionType, state});
            if (this.globalContext.isDTXTimeout()) {
                throw new LcnBusinessException("dtx timeout.");
            }
            state = this.reliableMessenger.notifyGroup(groupId, state);
            this.transactionCleanTemplate.clean(groupId, unitId, transactionType, state);
        }
        catch (TransactionClearException e) {
            txLogger.trace(groupId, unitId, "Transaction Error", "clean transaction fail.", new Object[0]);
        }
        catch (RpcException e) {
            this.dtxExceptionHandler.handleNotifyGroupMessageException(Arrays.asList(groupId, state, unitId, transactionType), e);
        }
        catch (LcnBusinessException e) {
            this.dtxExceptionHandler.handleNotifyGroupBusinessException(Arrays.asList(groupId, state, unitId, transactionType), e.getCause());
        }
        txLogger.txTrace(groupId, unitId, "notify group exception state {}.", new Object[]{state});
    }
}

