/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.lcn.control;

import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.DTXLocalControl;
import com.codingapi.txlcn.tc.core.TxTransactionInfo;
import com.codingapi.txlcn.tc.core.template.TransactionCleanTemplate;
import com.codingapi.txlcn.tc.core.template.TransactionControlTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="control_lcn_running")
public class LcnRunningTransaction
implements DTXLocalControl {
    private static final Logger log = LoggerFactory.getLogger(LcnRunningTransaction.class);
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TransactionControlTemplate transactionControlTemplate;

    @Autowired
    public LcnRunningTransaction(TransactionCleanTemplate transactionCleanTemplate, TransactionControlTemplate transactionControlTemplate) {
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.transactionControlTemplate = transactionControlTemplate;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) {
        DTXLocalContext.makeProxy();
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        try {
            this.transactionCleanTemplate.clean(info.getGroupId(), info.getUnitId(), info.getTransactionType(), 0);
        }
        catch (TransactionClearException e) {
            log.error("{} > clean transaction error.", (Object)"lcn");
        }
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) throws TransactionException {
        log.debug("join group: [GroupId: {},Method: {}]", (Object)info.getGroupId(), (Object)info.getTransactionInfo().getMethodStr());
        this.transactionControlTemplate.joinGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), info.getTransactionInfo());
    }
}

