/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.corelog.txc;

import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.UndoLogDO;
import com.codingapi.txlcn.tc.corelog.H2DbHelper;
import com.codingapi.txlcn.tc.corelog.LogHelper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TxcLogHelper
implements LogHelper {
    private static final Logger log = LoggerFactory.getLogger(TxcLogHelper.class);
    private final H2DbHelper h2DbHelper;

    @Autowired
    public TxcLogHelper(H2DbHelper h2DbHelper) {
        this.h2DbHelper = h2DbHelper;
    }

    public void init() {
        this.h2DbHelper.update("CREATE TABLE IF NOT EXISTS TXC_UNDO_LOG (ID BIGINT NOT NULL AUTO_INCREMENT, UNIT_ID VARCHAR(32) NOT NULL,GROUP_ID VARCHAR(64) NOT NULL,SQL_TYPE INT NOT NULL,ROLLBACK_INFO BLOB NOT NULL,CREATE_TIME CHAR(23) NOT NULL, PRIMARY KEY(ID) )", new Object[0]);
        log.info("Txc log table finish (H2 DATABASE)");
    }

    public void saveUndoLog(UndoLogDO undoLogDO) throws SQLException {
        String sql = "INSERT INTO TXC_UNDO_LOG (UNIT_ID,GROUP_ID,SQL_TYPE,ROLLBACK_INFO,CREATE_TIME) VALUES(?,?,?,?,?)";
        this.h2DbHelper.queryRunner().update(sql, new Object[]{undoLogDO.getUnitId(), undoLogDO.getGroupId(), undoLogDO.getSqlType(), undoLogDO.getRollbackInfo(), undoLogDO.getCreateTime()});
    }

    public List<UndoLogDO> getUndoLogByGroupAndUnitId(String groupId, String unitId) throws SQLException {
        String sql = "SELECT * FROM TXC_UNDO_LOG WHERE GROUP_ID = ? and UNIT_ID = ?";
        return (List)this.h2DbHelper.queryRunner().query(sql, rs -> {
            ArrayList<UndoLogDO> undoLogDOList = new ArrayList<UndoLogDO>();
            while (rs.next()) {
                UndoLogDO undoLogDO = new UndoLogDO();
                undoLogDO.setSqlType(rs.getInt("SQL_TYPE"));
                undoLogDO.setRollbackInfo(rs.getBytes("ROLLBACK_INFO"));
                undoLogDO.setUnitId(rs.getString("UNIT_ID"));
                undoLogDO.setGroupId("GROUP_ID");
                undoLogDO.setCreateTime(rs.getString("CREATE_TIME"));
                undoLogDOList.add(undoLogDO);
            }
            return undoLogDOList;
        }, new Object[]{groupId, unitId});
    }

    public void deleteUndoLog(String groupId, String unitId) throws SQLException {
        String sql = "DELETE FROM TXC_UNDO_LOG WHERE GROUP_ID=? AND UNIT_ID=?";
        this.h2DbHelper.queryRunner().update(sql, new Object[]{groupId, unitId});
    }
}

