/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg;

import com.codingapi.txlcn.common.exception.TxClientException;
import com.codingapi.txlcn.tc.support.TxLcnBeanHelper;
import com.codingapi.txlcn.tc.txmsg.MessageCreator;
import com.codingapi.txlcn.tc.txmsg.MessageParser;
import com.codingapi.txlcn.tc.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tc.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.RpcAnswer;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.dto.RpcCmd;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientRpcAnswer
implements RpcAnswer,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ClientRpcAnswer.class);
    private final TxLcnBeanHelper transactionBeanHelper;
    private final RpcClient rpcClient;
    private final ExecutorService executorService;

    @Autowired
    public ClientRpcAnswer(TxLcnBeanHelper transactionBeanHelper, RpcClient rpcClient) {
        this.transactionBeanHelper = transactionBeanHelper;
        this.rpcClient = rpcClient;
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 5, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("tc-rpc-service-%d").build());
    }

    public void callback(RpcCmd rpcCmd) {
        this.executorService.submit(() -> {
            log.debug("Receive Message: {}", (Object)rpcCmd.getMsg());
            TransactionCmd transactionCmd = MessageParser.parser(rpcCmd);
            String transactionType = transactionCmd.getTransactionType();
            String action = transactionCmd.getMsg().getAction();
            RpcExecuteService executeService = this.transactionBeanHelper.loadRpcExecuteService(transactionType, transactionCmd.getType());
            MessageDto messageDto = null;
            try {
                Serializable message = executeService.execute(transactionCmd);
                messageDto = MessageCreator.notifyUnitOkResponse(message, action);
            }
            catch (TxClientException e) {
                log.error("message > execute error.", (Throwable)e);
                messageDto = MessageCreator.notifyUnitFailResponse((Serializable)((Object)e), action);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (Objects.nonNull(rpcCmd.getKey())) {
                    try {
                        rpcCmd.setMsg(messageDto);
                        this.rpcClient.send(rpcCmd);
                    }
                    catch (RpcException e) {
                        log.error("response request[{}] error. error message: {}", (Object)rpcCmd.getKey(), (Object)e.getMessage());
                    }
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.executorService.shutdown();
        this.executorService.awaitTermination(6L, TimeUnit.SECONDS);
    }
}

