/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg.transaction;

import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.common.exception.TxClientException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.context.TxContext;
import com.codingapi.txlcn.tc.core.template.TransactionCleanTemplate;
import com.codingapi.txlcn.tc.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tc.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.params.NotifyUnitParams;
import java.io.Serializable;
import java.util.Objects;

public class DefaultNotifiedUnitService
implements RpcExecuteService {
    private static final TxLogger txLogger = TxLogger.newLogger(DefaultNotifiedUnitService.class);
    private final TransactionCleanTemplate transactionCleanTemplate;
    private TCGlobalContext globalContext;

    public DefaultNotifiedUnitService(TransactionCleanTemplate transactionCleanTemplate, TCGlobalContext globalContext) {
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.globalContext = globalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxClientException {
        try {
            NotifyUnitParams notifyUnitParams = (NotifyUnitParams)transactionCmd.getMsg().loadBean(NotifyUnitParams.class);
            TxContext txContext = this.globalContext.txContext(transactionCmd.getGroupId());
            if (Objects.nonNull(txContext)) {
                Object object = txContext.getLock();
                synchronized (object) {
                    txLogger.txTrace(transactionCmd.getGroupId(), notifyUnitParams.getUnitId(), "clean transaction cmd waiting for business code finish.", new Object[0]);
                    txContext.getLock().wait();
                }
            }
            this.transactionCleanTemplate.clean(notifyUnitParams.getGroupId(), notifyUnitParams.getUnitId(), notifyUnitParams.getUnitType(), notifyUnitParams.getState());
            return Boolean.valueOf(true);
        }
        catch (TransactionClearException | InterruptedException e) {
            throw new TxClientException(e);
        }
    }
}

