/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.core.storage.redis;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisConfiguration {
    @Bean
    @ConditionalOnClass(name={"org.springframework.data.redis.connection.RedisConnectionFactory"})
    public RedisTemplate<String, Object> functionDomainRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        JdkSerializationRedisSerializer serializationRedisSerializer = new JdkSerializationRedisSerializer();
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)serializationRedisSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)serializationRedisSerializer);
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        return redisTemplate;
    }
}

