/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.txlcn.common.exception.TransactionStateException;
import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.tm.support.db.domain.TxException;
import com.codingapi.txlcn.tm.support.db.jpa.TxExceptionRepository;
import com.codingapi.txlcn.tm.support.restapi.ao.WriteTxExceptionDTO;
import com.codingapi.txlcn.tm.support.restapi.vo.ExceptionInfo;
import com.codingapi.txlcn.tm.support.restapi.vo.ExceptionList;
import com.codingapi.txlcn.tm.support.service.TxExceptionService;
import com.codingapi.txlcn.tm.support.txex.TxExceptionListener;
import com.codingapi.txlcn.tm.txmsg.MessageCreator;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.util.MessageUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TxExceptionServiceImpl
implements TxExceptionService {
    private static final Logger log = LoggerFactory.getLogger(TxExceptionServiceImpl.class);
    private final RpcClient rpcClient;
    private final TxExceptionListener txExceptionListener;
    private final TxExceptionRepository txExceptionRepository;

    @Autowired
    public TxExceptionServiceImpl(RpcClient rpcClient, TxExceptionListener txExceptionListener, TxExceptionRepository txExceptionRepository) {
        this.rpcClient = rpcClient;
        this.txExceptionListener = txExceptionListener;
        this.txExceptionRepository = txExceptionRepository;
    }

    @Override
    public void writeTxException(WriteTxExceptionDTO writeTxExceptionReq) {
        log.info("write tx_exception. {}", (Object)writeTxExceptionReq);
        TxException txException = new TxException();
        txException.setCreateTime(new Date());
        txException.setGroupId(writeTxExceptionReq.getGroupId());
        txException.setTransactionState(writeTxExceptionReq.getTransactionState());
        txException.setUnitId(writeTxExceptionReq.getUnitId());
        txException.setRegistrar(writeTxExceptionReq.getRegistrar());
        txException.setModId(writeTxExceptionReq.getModId());
        txException.setExState((short)0);
        txException.setRemark(writeTxExceptionReq.getRemark());
        this.txExceptionRepository.save(txException);
        this.txExceptionListener.onException(txException);
    }

    @Override
    public int transactionState(String groupId) {
        log.debug("transactionState > groupId: {}", (Object)groupId);
        List<Integer> lists = this.txExceptionRepository.getTransactionStateByGroupId(groupId, (Pageable)PageRequest.of((int)0, (int)1));
        if (lists.size() <= 0) {
            return -1;
        }
        return lists.get(0);
    }

    @Override
    @Transactional
    public ExceptionList exceptionList(Integer page, Integer limit, Integer exState, String keyword, Integer registrar) {
        if (Objects.isNull(page) || page <= 0) {
            page = 1;
        }
        if (Objects.isNull(limit) || limit < 1) {
            limit = 10;
        }
        Specification & Serializable specification = (Specification & Serializable)(root, cq, cb) -> {
            ArrayList<Predicate> predicatesList = new ArrayList<Predicate>();
            if (Objects.nonNull(exState) && exState != -2 && Objects.nonNull(registrar) && registrar != -2) {
                predicatesList.add(cb.equal((Expression)root.get("exState"), (Object)exState));
                predicatesList.add(cb.equal((Expression)root.get("registrar"), (Object)registrar));
            } else if (Objects.nonNull(exState) && exState != -2) {
                predicatesList.add(cb.equal((Expression)root.get("exState"), (Object)exState));
            } else if (Objects.nonNull(registrar) && registrar != -2) {
                predicatesList.add(cb.equal((Expression)root.get("registrar"), (Object)registrar));
            }
            Predicate[] predicates = new Predicate[predicatesList.size()];
            return cb.and(predicatesList.toArray(predicates));
        };
        Page pageTxExceptions = this.txExceptionRepository.findAll(specification, (Pageable)PageRequest.of((int)(page - 1), (int)limit));
        List txExceptions = pageTxExceptions.getContent();
        ArrayList<ExceptionInfo> exceptionInfoList = new ArrayList<ExceptionInfo>(txExceptions.size());
        for (TxException txException : txExceptions) {
            ExceptionInfo exceptionInfo;
            block6: {
                exceptionInfo = new ExceptionInfo();
                BeanUtils.copyProperties((Object)txException, (Object)exceptionInfo);
                if (txException.getExState() != 1) {
                    try {
                        JSONObject transactionInfo = this.getTransactionInfo(exceptionInfo.getGroupId(), exceptionInfo.getUnitId());
                        exceptionInfo.setTransactionInfo(transactionInfo);
                    }
                    catch (TransactionStateException e) {
                        if (e.getCode() != 11) break block6;
                        this.txExceptionRepository.changeExState(txException.getId(), (short)1);
                        exceptionInfo.setExState((short)1);
                    }
                }
            }
            exceptionInfoList.add(exceptionInfo);
        }
        ExceptionList exceptionList = new ExceptionList();
        exceptionList.setTotal(pageTxExceptions.getTotalElements());
        exceptionList.setExceptions(exceptionInfoList);
        return exceptionList;
    }

    @Override
    public JSONObject getTransactionInfo(String groupId, String unitId) throws TransactionStateException {
        TxException exception = this.txExceptionRepository.findByGroupIdAndUnitId(groupId, unitId);
        if (Objects.isNull(exception)) {
            throw new TransactionStateException("non exists aspect log", 11);
        }
        List remoteKeys = this.rpcClient.remoteKeys(exception.getModId());
        if (remoteKeys.isEmpty()) {
            throw new TransactionStateException("non mod found", 10);
        }
        try {
            for (String remoteKey : remoteKeys) {
                MessageDto messageDto = this.rpcClient.request(remoteKey, MessageCreator.getAspectLog(groupId, unitId), 5000L);
                if (!MessageUtils.statusOk((MessageDto)messageDto)) continue;
                return (JSONObject)messageDto.loadBean(JSONObject.class);
            }
            throw new TransactionStateException("non exists aspect log", 11);
        }
        catch (RpcException e) {
            throw new TransactionStateException((Throwable)e, 12);
        }
    }

    @Override
    public void deleteExceptions(List<Long> ids) {
        for (Long id : ids) {
            this.txExceptionRepository.deleteById(id);
        }
    }

    @Override
    public void deleteTransactionInfo(String groupId, String unitId, String modId) throws TxManagerException {
        List remoteKeys = this.rpcClient.remoteKeys(modId);
        if (remoteKeys.isEmpty()) {
            throw new TxManagerException("\u4e0d\u5b58\u5728\u7684\u6a21\u5757");
        }
        try {
            for (String remoteKey : remoteKeys) {
                MessageDto messageDto = this.rpcClient.request(remoteKey, MessageCreator.deleteAspectLog(groupId, unitId), 5000L);
                if (!MessageUtils.statusOk((MessageDto)messageDto)) continue;
                return;
            }
        }
        catch (RpcException e) {
            throw new TxManagerException(e.getMessage());
        }
    }
}

