/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.support.txex;

import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.tm.support.db.domain.TxException;
import com.codingapi.txlcn.tm.support.txex.TxExceptionListener;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AsyncTxExceptionListener
implements TxExceptionListener {
    private final TxManagerConfig txManagerConfig;
    private final RestTemplate restTemplate;
    @Value(value="${server.port}")
    private Integer managerServicePort = 8083;
    private final ExecutorService executorService;

    @Autowired
    public AsyncTxExceptionListener(TxManagerConfig txManagerConfig, RestTemplate restTemplate, ExecutorService executorService) {
        this.txManagerConfig = txManagerConfig;
        this.restTemplate = restTemplate;
        this.executorService = executorService;
    }

    @Override
    public void onException(TxException txException) {
        if (this.txManagerConfig.isExUrlEnabled()) {
            this.executorService.submit(() -> {
                try {
                    if (!this.txManagerConfig.getExUrl().startsWith("http")) {
                        this.txManagerConfig.setExUrl("http://127.0.0.1:" + this.managerServicePort + this.txManagerConfig.getExUrl());
                    }
                    this.restTemplate.postForObject(this.txManagerConfig.getExUrl(), (Object)txException, String.class, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }
}

