/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data.style;

import com.deepoove.poi.xwpf.XWPFHighlightColor;
import java.io.Serializable;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;

public class Style
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String color;
    private String fontFamily;
    private String westernFontFamily;
    private double fontSize;
    private Boolean isBold;
    private Boolean isItalic;
    private Boolean isStrike;
    private UnderlinePatterns underlinePatterns;
    private String underlineColor;
    private XWPFHighlightColor highlightColor;
    private int characterSpacing;
    private String vertAlign;

    public Style() {
    }

    public static StyleBuilder builder() {
        return new StyleBuilder();
    }

    public Style(String color) {
        this.color = color;
    }

    public Style(String fontFamily, double fontSize) {
        this.fontFamily = fontFamily;
        this.fontSize = fontSize;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public Boolean isBold() {
        return this.isBold;
    }

    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    public Boolean isItalic() {
        return this.isItalic;
    }

    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    public Boolean isStrike() {
        return this.isStrike;
    }

    public void setStrike(Boolean isStrike) {
        this.isStrike = isStrike;
    }

    public UnderlinePatterns getUnderlinePatterns() {
        return this.underlinePatterns;
    }

    public void setUnderlinePatterns(UnderlinePatterns underlinePatterns) {
        this.underlinePatterns = underlinePatterns;
    }

    public String getUnderlineColor() {
        return this.underlineColor;
    }

    public void setUnderlineColor(String underlineColor) {
        this.underlineColor = underlineColor;
    }

    public XWPFHighlightColor getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(XWPFHighlightColor highlightColor) {
        this.highlightColor = highlightColor;
    }

    public int getCharacterSpacing() {
        return this.characterSpacing;
    }

    public void setCharacterSpacing(int characterSpacing) {
        this.characterSpacing = characterSpacing;
    }

    public String getVertAlign() {
        return this.vertAlign;
    }

    public void setVertAlign(String vertAlign) {
        this.vertAlign = vertAlign;
    }

    public String getWesternFontFamily() {
        return this.westernFontFamily;
    }

    public void setWesternFontFamily(String westernFontFamily) {
        this.westernFontFamily = westernFontFamily;
    }

    public static final class StyleBuilder {
        private Style style = new Style();

        private StyleBuilder() {
        }

        public StyleBuilder buildColor(String color) {
            this.style.setColor(color);
            return this;
        }

        public StyleBuilder buildFontFamily(String fontFamily) {
            this.style.setFontFamily(fontFamily);
            return this;
        }

        public StyleBuilder buildWesternFontFamily(String fontFamily) {
            this.style.setWesternFontFamily(fontFamily);
            return this;
        }

        public StyleBuilder buildFontSize(double fontSize) {
            this.style.setFontSize(fontSize);
            return this;
        }

        public StyleBuilder buildBold() {
            this.style.setBold(true);
            return this;
        }

        public StyleBuilder buildItalic() {
            this.style.setItalic(true);
            return this;
        }

        public StyleBuilder buildStrike() {
            this.style.setStrike(true);
            return this;
        }

        public StyleBuilder buildUnderlineColor(String color) {
            this.style.setUnderlineColor(color);
            return this;
        }

        public StyleBuilder buildUnderlinePatterns(UnderlinePatterns pattern) {
            this.style.setUnderlinePatterns(pattern);
            return this;
        }

        public StyleBuilder buildSuper() {
            this.style.setVertAlign("superscript");
            return this;
        }

        public StyleBuilder buildSub() {
            this.style.setVertAlign("subscript");
            return this;
        }

        public Style build() {
            return this.style;
        }
    }
}

