/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.reference;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.policy.reference.AbstractTemplateRenderPolicy;
import com.deepoove.poi.template.PictImageTemplate;
import com.deepoove.poi.xwpf.CTPictWrapper;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class DefaultPictImageTemplateRenderPolicy
extends AbstractTemplateRenderPolicy<PictImageTemplate, PictureRenderData> {
    @Override
    public void doRender(PictImageTemplate pictImageTemplate, PictureRenderData data, XWPFTemplate template) throws Exception {
        XWPFRun run;
        CTPictWrapper t = pictImageTemplate.getPicture();
        byte[] image = data.readPictureData();
        PictureType pictureType = data.getPictureType();
        if (null == pictureType) {
            pictureType = PictureType.suggestFileType(image);
        }
        if ((run = pictImageTemplate.getRun()).getParent().getPart() instanceof XWPFHeaderFooter) {
            XWPFHeaderFooter headerFooter = (XWPFHeaderFooter)run.getParent().getPart();
            this.setPictureReference(t, headerFooter.addPictureData(image, pictureType.type()));
        } else {
            this.setPictureReference(t, template.getXWPFDocument().addPictureData(image, pictureType.type()));
        }
    }

    private void setPictureReference(CTPictWrapper pictWrapper, String rid) {
        pictWrapper.setImageData(rid);
    }
}

