/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedImageUtils {
    private static Logger logger = LoggerFactory.getLogger(BufferedImageUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBufferByteArray(BufferedImage image, String format) {
        String formatName;
        if (null == image) {
            return null;
        }
        String string = formatName = StringUtils.isNotEmpty((CharSequence)format) && format.charAt(0) == '.' ? format.substring(1) : format;
        if (StringUtils.isEmpty((CharSequence)formatName)) {
            formatName = "png";
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, formatName, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("getBufferByteArray error", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)os);
        }
    }

    public static BufferedImage getUrlBufferedImage(String urlPath) {
        try {
            URL url = new URL(urlPath);
            return ImageIO.read(url);
        }
        catch (Exception e) {
            logger.error("getUrlBufferedImage error, {}, {}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static BufferedImage getLocalBufferedImage(File res) {
        try {
            return ImageIO.read(res);
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFound", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("getLocalBufferedImage IO error", (Throwable)e);
        }
        return null;
    }

    public static BufferedImage newBufferImage(int width, int height) {
        return new BufferedImage(width, height, 5);
    }

    public static BufferedImage readBufferedImage(byte[] image) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(image);
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException e) {
            logger.error("readBufferedImage IO error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }
}

