/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.NumberingFormat;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TextRenderData;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class NumberingRenderData
implements RenderData {
    private static final long serialVersionUID = 1L;
    private NumberingFormat format;
    private List<ParagraphRenderData> items;

    NumberingRenderData() {
    }

    public NumberingRenderData(List<ParagraphRenderData> items) {
        this(NumberingFormat.BULLET, items);
    }

    public NumberingRenderData(NumberingFormat format, List<ParagraphRenderData> items) {
        this.format = format;
        this.items = items;
    }

    public NumberingRenderData(TextRenderData ... text) {
        this(NumberingFormat.BULLET, text);
    }

    public NumberingRenderData(NumberingFormat format, TextRenderData ... text) {
        this.format = format;
        if (null != text) {
            this.items = Arrays.stream(text).map(data -> Paragraphs.of(data).create()).collect(Collectors.toList());
        }
    }

    public static NumberingRenderData build(String ... text) {
        if (null != text) {
            return new NumberingRenderData(Arrays.stream(text).map(TextRenderData::new).map(data -> Paragraphs.of(data).create()).collect(Collectors.toList()));
        }
        return new NumberingRenderData(NumberingFormat.BULLET, new TextRenderData[]{null});
    }

    public static NumberingRenderData build(TextRenderData ... text) {
        return new NumberingRenderData(NumberingFormat.BULLET, text);
    }

    public List<ParagraphRenderData> getItems() {
        return this.items;
    }

    public void setItems(List<ParagraphRenderData> items) {
        this.items = items;
    }

    public NumberingFormat getFormat() {
        return this.format;
    }

    public void setFormat(NumberingFormat format) {
        this.format = format;
    }
}

