/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.util.BufferedImageUtils;
import com.deepoove.poi.util.ByteUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;

public class Pictures {
    private Pictures() {
    }

    public static PictureBuilder ofLocal(String src) {
        return Pictures.ofBytes(ByteUtils.getLocalByteArray(new File(src)), PictureType.suggestFileType(src));
    }

    public static PictureBuilder ofUrl(String url, PictureType pictureType) {
        return Pictures.ofBytes(ByteUtils.getUrlByteArray(url), pictureType);
    }

    public static PictureBuilder ofStream(InputStream inputStream, PictureType pictureType) {
        return Pictures.ofBytes(ByteUtils.toByteArray(inputStream), pictureType);
    }

    public static PictureBuilder ofBufferedImage(BufferedImage image, PictureType pictureType) {
        return Pictures.ofBytes(BufferedImageUtils.getBufferByteArray(image, pictureType.format()), pictureType);
    }

    public static PictureBuilder ofBase64(String base64, PictureType pictureType) {
        return Pictures.ofBytes(ByteUtils.getBase64ByteArray(base64), pictureType);
    }

    public static PictureBuilder ofBytes(byte[] bytes, PictureType pictureType) {
        return new PictureBuilder(pictureType, bytes);
    }

    public static class PictureBuilder
    implements RenderDataBuilder<PictureRenderData> {
        private PictureRenderData data;

        private PictureBuilder(PictureType pictureType, byte[] bytes) {
            this.data = new PictureRenderData(0, 0, pictureType, bytes);
        }

        public PictureBuilder size(int width, int height) {
            this.data.setWidth(width);
            this.data.setHeight(height);
            return this;
        }

        public PictureBuilder altMeta(String altMeta) {
            this.data.setAltMeta(altMeta);
            return this;
        }

        @Override
        public PictureRenderData create() {
            return this.data;
        }
    }
}

