/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import org.apache.commons.lang3.ClassUtils;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderPolicy<T>
implements RenderPolicy {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        Object model = null;
        try {
            model = data;
        }
        catch (ClassCastException e) {
            throw new RenderException("Error Render Data format for template: " + eleTemplate.getSource(), e);
        }
        RenderContext<Object> context = new RenderContext<Object>(eleTemplate, model, template);
        try {
            if (!this.validate(model)) {
                this.postValidError(context);
                return;
            }
            this.beforeRender(context);
            this.doRender(context);
            this.afterRender(context);
        }
        catch (Exception e) {
            this.reThrowException(context, e);
        }
    }

    public abstract void doRender(RenderContext<T> var1) throws Exception;

    protected boolean validate(T data) {
        return true;
    }

    protected void beforeRender(RenderContext<T> context) {
    }

    protected void afterRender(RenderContext<T> context) {
    }

    protected void reThrowException(RenderContext<T> context, Exception e) {
        throw new RenderException("Render template " + context.getEleTemplate() + " failed!", e);
    }

    protected void postValidError(RenderContext<T> context) {
        Configure.ValidErrorHandler errorHandler = context.getConfig().getValidErrorHandler();
        this.logger.info("The data [{}] of the template {} is illegal, will apply error handler [{}]", new Object[]{context.getData(), context.getTagSource(), ClassUtils.getSimpleName(errorHandler.getClass())});
        errorHandler.handler(context);
    }

    protected void clearPlaceholder(RenderContext<?> context, boolean clearParagraph) {
        XWPFRun run = context.getRun();
        if (clearParagraph) {
            BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(run);
            bodyContainer.clearPlaceholder(run);
        } else {
            run.setText("", 0);
        }
    }
}

