/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public final class ParagraphUtils {
    public static String trimLine(XWPFParagraph paragraph) {
        return ParagraphUtils.trimLine(paragraph.getText());
    }

    public static String trimLine(String value) {
        int st;
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = 0; st < len && val[st] == '\n'; ++st) {
        }
        while (st < len && val[len - 1] == '\n') {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    public static Integer getRunPos(XWPFRun run) {
        XWPFParagraph paragraph = (XWPFParagraph)run.getParent();
        List runs = paragraph.getRuns();
        for (int i = 0; i < runs.size(); ++i) {
            if (run != runs.get(i)) continue;
            return i;
        }
        return null;
    }

    public static boolean havePictures(XWPFParagraph paragraph) {
        List runs = paragraph.getRuns();
        for (XWPFRun run : runs) {
            if (!CollectionUtils.isNotEmpty((Collection)run.getEmbeddedPictures())) continue;
            return true;
        }
        return false;
    }
}

