/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import java.math.BigInteger;

class Page {
    public static final Page A4_NORMAL = new Page(210, 297, new PageMargin(1440L, 1440L, 1800L, 1800L));
    public static final Page A4_NARROW = new Page(210, 297, new PageMargin(720L, 720L, 720L, 720L));
    public static final Page A4_MEDIUM = new Page(210, 297, new PageMargin(1440L, 1440L, 1080L, 1080L));
    public static final Page A4_EXTEND = new Page(210, 297, new PageMargin(1440L, 1440L, 2880L, 2880L));
    private int widthInMilli;
    private int heightInMilli;
    private PageMargin pageMar;

    Page(int width, int height, PageMargin pageMar) {
        this.widthInMilli = width;
        this.heightInMilli = height;
        this.pageMar = pageMar;
    }

    public BigInteger tableWidth() {
        long fullWidth = (long)((double)(this.widthInMilli / 10) / 2.54 * 1440.0);
        return BigInteger.valueOf(fullWidth - this.pageMar.left.longValue() - this.pageMar.right.longValue());
    }

    public int getWidthInMilli() {
        return this.widthInMilli;
    }

    public int getHeightInMilli() {
        return this.heightInMilli;
    }

    public PageMargin getPageMar() {
        return this.pageMar;
    }

    static class PageMargin {
        private BigInteger top;
        private BigInteger bottom;
        private BigInteger right;
        private BigInteger left;
        private BigInteger gutter = BigInteger.ZERO;

        public PageMargin(long t, long b, long r, long l) {
            this.top = BigInteger.valueOf(t);
            this.bottom = BigInteger.valueOf(b);
            this.right = BigInteger.valueOf(r);
            this.left = BigInteger.valueOf(l);
        }

        public BigInteger getTop() {
            return this.top;
        }

        public BigInteger getBottom() {
            return this.bottom;
        }

        public BigInteger getRight() {
            return this.right;
        }

        public BigInteger getLeft() {
            return this.left;
        }

        public BigInteger getGutter() {
            return this.gutter;
        }
    }
}

