/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.tree;

import com.diffplug.common.tree.TreeDef;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class TreeIterable {
    private TreeIterable() {
    }

    public static <T> Iterable<T> toParent(final TreeDef.Parented<T> treeDef, final T node) {
        Objects.requireNonNull(treeDef);
        Objects.requireNonNull(node);
        return () -> new Iterator<T>(){
            Object tip;
            {
                this.tip = node;
            }

            @Override
            public boolean hasNext() {
                return this.tip != null;
            }

            @Override
            public T next() {
                if (this.tip == null) {
                    throw new NoSuchElementException();
                }
                Object next = this.tip;
                this.tip = treeDef.parentOf(this.tip);
                return next;
            }
        };
    }

    public static <T> Iterable<T> breadthFirst(final TreeDef<T> treeDef, final T node) {
        Objects.requireNonNull(treeDef);
        Objects.requireNonNull(node);
        return () -> new Iterator<T>(){
            Deque queue;
            {
                this.queue = new ArrayDeque<Object>(Arrays.asList(node));
            }

            @Override
            public boolean hasNext() {
                return !this.queue.isEmpty();
            }

            @Override
            public T next() {
                if (this.queue.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object next = this.queue.removeFirst();
                treeDef.childrenOf(next).forEach(this.queue::addLast);
                return next;
            }
        };
    }

    public static <T> Iterable<T> depthFirst(final TreeDef<T> treeDef, final T node) {
        Objects.requireNonNull(treeDef);
        Objects.requireNonNull(node);
        return () -> new Iterator<T>(){
            Deque queue;
            {
                this.queue = new ArrayDeque<Object>(Arrays.asList(node));
            }

            @Override
            public boolean hasNext() {
                return !this.queue.isEmpty();
            }

            @Override
            public T next() {
                if (this.queue.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object next = this.queue.removeLast();
                List children = treeDef.childrenOf(next);
                ListIterator iterator = children.listIterator(children.size());
                while (iterator.hasPrevious()) {
                    this.queue.addLast(iterator.previous());
                }
                return next;
            }
        };
    }
}

