/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanPropertyWriter;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializer;
import com.fasterxml.jackson.dataformat.xml.util.AnnotationUtil;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import com.fasterxml.jackson.dataformat.xml.util.XmlInfo;
import java.io.Serializable;
import java.util.List;

public class XmlBeanSerializerModifier
extends BeanSerializerModifier
implements Serializable {
    private static final long serialVersionUID = 1L;

    public List<BeanPropertyWriter> changeProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = list.get(i);
            AnnotatedMember annotatedMember = beanPropertyWriter.getMember();
            String string = AnnotationUtil.findNamespaceAnnotation(annotationIntrospector, annotatedMember);
            Boolean bl = AnnotationUtil.findIsAttributeAnnotation(annotationIntrospector, annotatedMember);
            Boolean bl2 = AnnotationUtil.findIsTextAnnotation(annotationIntrospector, annotatedMember);
            beanPropertyWriter.setInternalSetting((Object)XmlBeanSerializer.KEY_XML_INFO, (Object)new XmlInfo(bl, string, bl2));
            if (!TypeUtil.isIndexedType(beanPropertyWriter.getType())) continue;
            PropertyName propertyName = PropertyName.construct((String)beanPropertyWriter.getName(), (String)string);
            PropertyName propertyName2 = beanPropertyWriter.getWrapperName();
            if (propertyName2 == null || propertyName2 == PropertyName.NO_NAME) continue;
            String string2 = propertyName2.getSimpleName();
            if (string2 == null || string2.length() == 0) {
                propertyName2 = propertyName;
            }
            list.set(i, new XmlBeanPropertyWriter(beanPropertyWriter, propertyName2, propertyName));
        }
        return list;
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig serializationConfig, BeanDescription beanDescription, JsonSerializer<?> jsonSerializer) {
        if (!(jsonSerializer instanceof BeanSerializerBase)) {
            return jsonSerializer;
        }
        return new XmlBeanSerializer((BeanSerializerBase)jsonSerializer);
    }
}

