/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis;

import com.gitee.starblues.extension.mybatis.utils.MybatisInjectWrapper;
import com.gitee.starblues.factory.PluginInfoContainer;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.SpringBeanRegister;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessorExtend;
import com.gitee.starblues.factory.process.pipe.bean.name.PluginAnnotationBeanNameGenerator;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.OrderPriority;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.AnnotationScopeMetadataResolver;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.GenericApplicationContext;

public class PluginMybatisMapperProcessor
implements PluginPipeProcessorExtend {
    private static final Logger LOG = LoggerFactory.getLogger(PluginMybatisMapperProcessor.class);
    private static final String KEY = "PluginMybatisMapperProcessor";
    private ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();
    private final GenericApplicationContext applicationContext;
    private final MybatisInjectWrapper mybatisInjectWrapper;
    private final SpringBeanRegister springBeanRegister;

    PluginMybatisMapperProcessor(ApplicationContext applicationContext) {
        this.applicationContext = (GenericApplicationContext)applicationContext;
        this.springBeanRegister = new SpringBeanRegister(applicationContext);
        this.springBeanRegister.register(KEY, MybatisInjectWrapper.class);
        this.mybatisInjectWrapper = (MybatisInjectWrapper)applicationContext.getBean(MybatisInjectWrapper.class);
    }

    private boolean mybatisExist() {
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.applicationContext.getBean(SqlSessionFactory.class);
        SqlSessionTemplate sqlSessionTemplate = (SqlSessionTemplate)this.applicationContext.getBean(SqlSessionTemplate.class);
        return sqlSessionFactory != null && sqlSessionTemplate != null;
    }

    public void initialize() throws Exception {
    }

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        if (!this.mybatisExist()) {
            return;
        }
        List groupClasses = pluginRegistryInfo.getGroupClasses("plugin_mybatis_mapper");
        if (groupClasses == null || groupClasses.isEmpty()) {
            return;
        }
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        HashSet<String> beanNames = new HashSet<String>();
        for (Class groupClass : groupClasses) {
            if (groupClass == null) continue;
            PluginAnnotationBeanNameGenerator beanNameGenerator = new PluginAnnotationBeanNameGenerator(basePlugin.getWrapper().getPluginId());
            AnnotatedGenericBeanDefinition abd = new AnnotatedGenericBeanDefinition(groupClass);
            ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata((BeanDefinition)abd);
            abd.setScope(scopeMetadata.getScopeName());
            String beanName = beanNameGenerator.generateBeanName((BeanDefinition)abd, (BeanDefinitionRegistry)this.applicationContext);
            BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)abd, beanName);
            AnnotationConfigUtils.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)abd);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)this.applicationContext);
            this.mybatisInjectWrapper.processBeanDefinitions(definitionHolder, groupClass);
            beanNames.add(beanName);
            PluginInfoContainer.addRegisterBeanName((String)pluginId, (String)beanName);
        }
        pluginRegistryInfo.addProcessorInfo(KEY, beanNames);
    }

    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Set beanNames = (Set)pluginRegistryInfo.getProcessorInfo(KEY);
        if (beanNames == null) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        for (String beanName : beanNames) {
            this.applicationContext.removeBeanDefinition(beanName);
            PluginInfoContainer.removeRegisterBeanName((String)pluginId, (String)beanName);
        }
    }

    public String key() {
        return KEY;
    }

    public OrderPriority order() {
        return OrderPriority.getHighPriority();
    }
}

