/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis;

import com.gitee.starblues.extension.mybatis.utils.MybatisXmlProcess;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.PluginPipeProcessorExtend;
import com.gitee.starblues.loader.PluginResourceLoadFactory;
import com.gitee.starblues.loader.ResourceWrapper;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.OrderPriority;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.pf4j.PluginWrapper;
import org.springframework.context.ApplicationContext;

public class PluginMybatisXmlProcessor
implements PluginPipeProcessorExtend {
    private final MybatisXmlProcess mybatisXmlProcess;
    private final SqlSessionFactory sqlSessionFactory;

    PluginMybatisXmlProcessor(ApplicationContext mainApplicationContext) {
        this.sqlSessionFactory = (SqlSessionFactory)mainApplicationContext.getBean(SqlSessionFactory.class);
        this.mybatisXmlProcess = this.sqlSessionFactory != null ? MybatisXmlProcess.getInstance(this.sqlSessionFactory) : null;
    }

    public String key() {
        return "PluginMybatisXmlProcessor";
    }

    public OrderPriority order() {
        return OrderPriority.getLowPriority();
    }

    public void initialize() throws Exception {
    }

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        if (this.mybatisXmlProcess == null || this.sqlSessionFactory == null) {
            return;
        }
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        PluginResourceLoadFactory pluginResourceLoadFactory = basePlugin.getBasePluginExtend().getPluginResourceLoadFactory();
        ResourceWrapper resourceWrapper = pluginResourceLoadFactory.getPluginResources("PluginMybatisXmlLoader");
        if (resourceWrapper == null) {
            return;
        }
        this.processAliases(pluginRegistryInfo);
        List pluginResources = resourceWrapper.getResources();
        if (pluginResources == null || pluginResources.isEmpty()) {
            return;
        }
        this.mybatisXmlProcess.loadXmlResource(pluginResources, pluginWrapper.getPluginClassLoader());
    }

    private void processAliases(PluginRegistryInfo pluginRegistryInfo) {
    }

    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
    }
}

