/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.user;

import com.gitee.starblues.factory.PluginInfoContainer;
import com.gitee.starblues.integration.user.PluginUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.pf4j.PluginManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class DefaultPluginUser
implements PluginUser {
    private final GenericApplicationContext applicationContext;
    private final PluginManager pluginManager;

    public DefaultPluginUser(ApplicationContext applicationContext, PluginManager pluginManager) {
        Objects.requireNonNull(applicationContext, "ApplicationContext can't be null");
        Objects.requireNonNull(pluginManager, "PluginManager can't be null");
        this.applicationContext = (GenericApplicationContext)applicationContext;
        this.pluginManager = pluginManager;
    }

    @Override
    public <T> T getBean(String name) {
        Object bean = this.applicationContext.getBean(name);
        if (bean == null) {
            return null;
        }
        return (T)bean;
    }

    @Override
    public <T> T getBean(Class<T> aClass) {
        return (T)this.applicationContext.getBean(aClass);
    }

    @Override
    public <T> T getPluginBean(String name) {
        if (this.isPluginBean(name)) {
            return this.getBean(name);
        }
        return null;
    }

    @Override
    public <T> List<T> getBeans(Class<T> aClass) {
        Map beansOfTypeMap = this.applicationContext.getBeansOfType(aClass);
        if (beansOfTypeMap == null) {
            return Collections.emptyList();
        }
        return beansOfTypeMap.values().stream().filter(beansOfType -> beansOfTypeMap != null).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> getMainBeans(Class<T> aClass) {
        Map beansOfTypeMap = this.applicationContext.getBeansOfType(aClass);
        if (beansOfTypeMap == null) {
            return Collections.emptyList();
        }
        ArrayList beans = new ArrayList();
        beansOfTypeMap.forEach((beanName, bean) -> {
            if (!this.isPluginBean((String)beanName)) {
                beans.add(bean);
            }
        });
        return beans;
    }

    @Override
    public <T> List<T> getPluginBeans(Class<T> aClass) {
        Map beansOfTypeMap = this.applicationContext.getBeansOfType(aClass);
        if (beansOfTypeMap == null) {
            return Collections.emptyList();
        }
        ArrayList beans = new ArrayList();
        beansOfTypeMap.forEach((beanName, bean) -> {
            if (this.isPluginBean((String)beanName)) {
                beans.add(bean);
            }
        });
        return beans;
    }

    @Override
    public <T> List<T> getPluginBeans(String pluginId, Class<T> aClass) {
        Map beansOfTypeMap = this.applicationContext.getBeansOfType(aClass);
        if (beansOfTypeMap == null) {
            return Collections.emptyList();
        }
        ArrayList beans = new ArrayList();
        beansOfTypeMap.forEach((beanName, bean) -> {
            if (PluginInfoContainer.existRegisterBeanName(pluginId, beanName)) {
                beans.add(bean);
            }
        });
        return beans;
    }

    @Override
    public <T> List<T> getPluginExtensions(Class<T> tClass) {
        return this.pluginManager.getExtensions(tClass);
    }

    private boolean isPluginBean(String beanName) {
        if (beanName == null) {
            return false;
        }
        return PluginInfoContainer.existRegisterBeanName(beanName);
    }
}

