/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.loader.load;

import com.gitee.starblues.loader.PluginResourceLoader;
import com.gitee.starblues.loader.ResourceWrapper;
import com.gitee.starblues.realize.BasePlugin;
import com.gitee.starblues.utils.OrderPriority;
import java.io.File;
import java.util.ArrayList;
import org.pf4j.RuntimeMode;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;

public class PluginConfigFileLoader
implements PluginResourceLoader {
    private final String configFilePath;
    private final String fileName;
    private final RuntimeMode runtimeMode;

    public PluginConfigFileLoader(String configFilePath, String fileName, RuntimeMode runtimeMode) {
        this.configFilePath = configFilePath;
        this.fileName = fileName;
        this.runtimeMode = runtimeMode;
    }

    @Override
    public String key() {
        return null;
    }

    @Override
    public ResourceWrapper load(BasePlugin basePlugin) throws Exception {
        FileUrlResource resource;
        String path;
        if (this.runtimeMode == RuntimeMode.DEVELOPMENT) {
            path = this.configFilePath + this.fileName;
            resource = new ClassPathResource("/" + path, basePlugin.getWrapper().getPluginClassLoader());
        } else {
            path = this.configFilePath + File.separatorChar + this.fileName;
            resource = new FileUrlResource(path);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add((Resource)resource);
        return new ResourceWrapper(resources);
    }

    @Override
    public void unload(BasePlugin basePlugin, ResourceWrapper resourceWrapper) throws Exception {
    }

    @Override
    public OrderPriority order() {
        return OrderPriority.getHighPriority().down(20);
    }
}

