/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.autoconfigure;

import com.github.pagehelper.PageInterceptor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={SqlSessionFactory.class})
@ConfigurationProperties
@EnableConfigurationProperties
@AutoConfigureAfter(value={MybatisAutoConfiguration.class})
public class PageHelperAutoConfiguration {
    private final SqlSessionFactory sqlSessionFactory;
    private Map<String, String> pagehelper = new LinkedHashMap<String, String>();

    public PageHelperAutoConfiguration(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    @PostConstruct
    public void addPageInterceptor() {
        PageInterceptor interceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.putAll(this.pagehelper);
        interceptor.setProperties(properties);
        this.sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)interceptor);
    }

    public Map<String, String> getPagehelper() {
        return this.pagehelper;
    }

    public void setPagehelper(Map<String, String> pagehelper) {
        this.pagehelper = pagehelper;
    }
}

