/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty;

import com.github.netty.Version;
import com.github.netty.core.AbstractNettyServer;
import com.github.netty.core.AbstractProtocol;
import com.github.netty.core.Ordered;
import com.github.netty.core.ProtocolHandler;
import com.github.netty.core.ServerListener;
import com.github.netty.core.TcpChannel;
import com.github.netty.core.util.HostUtil;
import com.github.netty.core.util.SystemPropertyUtil;
import com.github.netty.protocol.DynamicProtocolChannelHandler;
import com.github.netty.protocol.HttpServletProtocol;
import com.github.netty.protocol.servlet.ServletContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.util.ResourceLeakDetector;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.TreeSet;

public class StartupServer
extends AbstractNettyServer {
    private final Collection<ProtocolHandler> protocolHandlers = new TreeSet<Ordered>(Ordered.COMPARATOR);
    private final Collection<ServerListener> serverListeners = new TreeSet<Ordered>(Ordered.COMPARATOR);
    private DynamicProtocolChannelHandler dynamicProtocolChannelHandler = new DynamicProtocolChannelHandler();

    public StartupServer(int port) {
        this(StartupServer.getServerSocketAddress(null, port));
    }

    public StartupServer(InetSocketAddress serverAddress) {
        super(serverAddress);
    }

    public void start() throws IllegalStateException {
        try {
            super.init();
            for (ServerListener serverListener : this.serverListeners) {
                serverListener.onServerStart(this);
            }
            super.run();
        }
        catch (Exception e) {
            throw new IllegalStateException("tcp server start fail.. cause = " + e, e);
        }
    }

    @Override
    public void stop() throws IllegalStateException {
        for (ServerListener serverListener : this.serverListeners) {
            try {
                serverListener.onServerStop(this);
            }
            catch (Throwable t) {
                this.logger.error("case by stop event [" + t.getMessage() + "]", t);
            }
        }
        try {
            super.stop();
            for (TcpChannel tcpChannel : TcpChannel.getChannels().values()) {
                tcpChannel.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    protected void startAfter(ChannelFuture future) {
        Throwable cause = future.cause();
        if (cause != null) {
            this.logger.error("server startup fail. cause={}", (Object)cause.toString(), (Object)cause);
            System.exit(-1);
            return;
        }
        this.logger.info("{} start (version = {}, port = {}, pid = {}, protocol = {}, os = {}) ...", this.getName(), Version.getServerNumber(), this.getPort() + "", HostUtil.getPid() + "", this.protocolHandlers, HostUtil.getOsName());
    }

    @Override
    protected void config(ServerBootstrap bootstrap) throws Exception {
        super.config(bootstrap);
        if (SystemPropertyUtil.get("io.netty.leakDetectionLevel") == null && SystemPropertyUtil.get("io.netty.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        }
        if (SystemPropertyUtil.get("io.netty.maxDirectMemory") == null) {
            long maxDirectMemory = -1L;
            System.setProperty("io.netty.maxDirectMemory", String.valueOf(maxDirectMemory));
        }
        bootstrap.childOption(ChannelOption.WRITE_SPIN_COUNT, (Object)Integer.MAX_VALUE);
        bootstrap.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(32768, Integer.MAX_VALUE));
        bootstrap.childOption(ChannelOption.AUTO_CLOSE, (Object)true);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)false);
        for (ServerListener serverListener : this.serverListeners) {
            serverListener.config(bootstrap);
        }
    }

    @Override
    protected ChannelHandler newWorkerChannelHandler() {
        DynamicProtocolChannelHandler handler = this.dynamicProtocolChannelHandler;
        handler.setProtocolHandlers(this.protocolHandlers);
        return handler;
    }

    public ServletContext getServletContext() {
        for (ProtocolHandler protocolHandler : this.protocolHandlers) {
            if (!(protocolHandler instanceof HttpServletProtocol)) continue;
            return ((HttpServletProtocol)protocolHandler).getServletContext();
        }
        return null;
    }

    public Collection<ProtocolHandler> getProtocolHandlers() {
        return this.protocolHandlers;
    }

    public Collection<ServerListener> getServerListeners() {
        return this.serverListeners;
    }

    public void addProtocol(AbstractProtocol protocol) {
        this.protocolHandlers.add(protocol);
        this.serverListeners.add(protocol);
    }

    public DynamicProtocolChannelHandler getDynamicProtocolChannelHandler() {
        return this.dynamicProtocolChannelHandler;
    }

    public void setDynamicProtocolChannelHandler(DynamicProtocolChannelHandler dynamicProtocolChannelHandler) {
        this.dynamicProtocolChannelHandler = dynamicProtocolChannelHandler;
    }

    public static InetSocketAddress getServerSocketAddress(InetAddress address, int port) {
        if (address == null) {
            try {
                address = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
                if (!address.isAnyLocalAddress()) {
                    address = InetAddress.getByName("::1");
                }
                if (!address.isAnyLocalAddress()) {
                    address = new InetSocketAddress(port).getAddress();
                }
            }
            catch (UnknownHostException e) {
                address = new InetSocketAddress(port).getAddress();
            }
        }
        return new InetSocketAddress(address, port);
    }
}

