/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.RecyclableUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class AbstractChannelHandler<I, O>
extends ChannelDuplexHandler {
    protected LoggerX logger = LoggerFactoryX.getLogger(((Object)((Object)this)).getClass());
    private final TypeParameterMatcher matcherInbound = TypeParameterMatcher.find((Object)((Object)this), AbstractChannelHandler.class, (String)"I");
    private final TypeParameterMatcher matcherOutbound = TypeParameterMatcher.find((Object)((Object)this), AbstractChannelHandler.class, (String)"O");
    private final boolean autoRelease;

    protected AbstractChannelHandler() {
        this(true);
    }

    protected AbstractChannelHandler(boolean autoRelease) {
        this.autoRelease = autoRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        boolean release = true;
        try {
            boolean match = this.matcherInbound.match(msg);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("ChannelRead({}) -> match({}) ", (Object)this.messageToString(msg), (Object)match);
            }
            if (match) {
                Object imsg = msg;
                this.onMessageReceived(ctx, imsg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (this.autoRelease && release) {
                RecyclableUtil.release(msg);
            }
        }
    }

    protected void onMessageReceived(ChannelHandlerContext ctx, I msg) throws Exception {
        ctx.fireChannelRead(msg);
    }

    public final void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        boolean match = this.matcherOutbound.match(msg);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("ChannelWrite({}) -> match({}) ", (Object)this.messageToString(msg), (Object)match);
        }
        if (match) {
            Object imsg = msg;
            this.onMessageWriter(ctx, imsg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    protected void onMessageWriter(ChannelHandlerContext ctx, O msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            switch (e.state()) {
                case READER_IDLE: {
                    this.onReaderIdle(ctx);
                    break;
                }
                case WRITER_IDLE: {
                    this.onWriterIdle(ctx);
                    break;
                }
                case ALL_IDLE: {
                    this.onAllIdle(ctx);
                    break;
                }
            }
        } else {
            this.onUserEventTriggered(ctx, evt);
        }
        ctx.fireUserEventTriggered(evt);
    }

    protected void onUserEventTriggered(ChannelHandlerContext ctx, Object evt) {
    }

    protected void onAllIdle(ChannelHandlerContext ctx) {
    }

    protected void onWriterIdle(ChannelHandlerContext ctx) {
    }

    protected void onReaderIdle(ChannelHandlerContext ctx) {
    }

    public String messageToString(Object msg) {
        if (msg == null) {
            return "null";
        }
        return msg.getClass().getSimpleName();
    }
}

