/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.util.ByteBufAllocatorX;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.NamespaceUtil;
import com.github.netty.core.util.ThreadFactoryX;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ChannelFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractNettyClient
implements Closeable {
    protected LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private final String name;
    private final String namePre;
    private Bootstrap bootstrap;
    private EventLoopGroup worker;
    protected InetSocketAddress remoteAddress;
    private boolean enableEpoll;
    private volatile SocketChannel channel;
    protected final AtomicBoolean connectIngFlag = new AtomicBoolean(false);
    private int ioThreadCount = 0;
    private int ioRatio = 100;
    private AtomicBoolean initFlag = new AtomicBoolean(false);

    public AbstractNettyClient() {
        this("", null);
    }

    public AbstractNettyClient(String remoteHost, int remotePort) {
        this(new InetSocketAddress(remoteHost, remotePort));
    }

    public AbstractNettyClient(InetSocketAddress remoteAddress) {
        this("", remoteAddress);
    }

    public AbstractNettyClient(String namePre, InetSocketAddress remoteAddress) {
        this.enableEpoll = Epoll.isAvailable();
        this.remoteAddress = remoteAddress;
        this.namePre = namePre;
        this.name = NamespaceUtil.newIdName(namePre, this.getClass());
        if (this.enableEpoll) {
            this.logger.info("enable epoll client = {}", (Object)this);
        }
    }

    public void setIoRatio(int ioRatio) {
        if (this.worker instanceof NioEventLoopGroup) {
            ((NioEventLoopGroup)this.worker).setIoRatio(ioRatio);
        } else if (this.worker instanceof EpollEventLoopGroup) {
            // empty if block
        }
        this.ioRatio = ioRatio;
    }

    public void setIoThreadCount(int ioThreadCount) {
        this.ioThreadCount = ioThreadCount;
    }

    protected abstract ChannelHandler newBossChannelHandler();

    protected Bootstrap newClientBootstrap() {
        return new Bootstrap();
    }

    protected EventLoopGroup newWorkerEventLoopGroup() {
        EpollEventLoopGroup worker;
        if (this.enableEpoll) {
            EpollEventLoopGroup epollWorker;
            worker = epollWorker = new EpollEventLoopGroup(this.ioThreadCount, (ThreadFactory)new ThreadFactoryX("Epoll", this.namePre + "Client-Worker"));
        } else {
            NioEventLoopGroup nioWorker = new NioEventLoopGroup(this.ioThreadCount, (ThreadFactory)new ThreadFactoryX("NIO", this.namePre + "Client-Worker"));
            nioWorker.setIoRatio(this.ioRatio);
            worker = nioWorker;
        }
        return worker;
    }

    protected ChannelFactory<? extends Channel> newClientChannelFactory() {
        ChannelFactory channelFactory = this.enableEpoll ? EpollSocketChannel::new : NioSocketChannel::new;
        return channelFactory;
    }

    protected AbstractNettyClient init() {
        this.bootstrap = this.newClientBootstrap();
        this.worker = this.newWorkerEventLoopGroup();
        ChannelFactory<? extends Channel> channelFactory = this.newClientChannelFactory();
        ChannelHandler bossChannelHandler = this.newBossChannelHandler();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.worker)).channelFactory(channelFactory)).handler(bossChannelHandler)).remoteAddress((SocketAddress)this.remoteAddress).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)ByteBufAllocatorX.INSTANCE);
        return this;
    }

    public AbstractNettyClient config(Bootstrap bootstrap) {
        return this;
    }

    public boolean isConnect() {
        return this.getActiveSocketChannelCount() > 0;
    }

    public Optional<ChannelFuture> connect() {
        return this.connect(this.remoteAddress);
    }

    public Optional<ChannelFuture> connect(InetSocketAddress remoteAddress) {
        if (this.connectIngFlag.compareAndSet(false, true)) {
            if (this.initFlag.compareAndSet(false, true)) {
                this.init();
            }
            this.remoteAddress = remoteAddress == null ? (InetSocketAddress)this.bootstrap.config().remoteAddress() : remoteAddress;
            return Optional.of(this.bootstrap.connect((SocketAddress)this.remoteAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                try {
                    if (future.isSuccess()) {
                        this.setChannel((SocketChannel)future.channel());
                    } else {
                        future.channel().close();
                    }
                }
                finally {
                    this.connectIngFlag.set(false);
                }
                this.connectAfter((ChannelFuture)future);
            })));
        }
        return Optional.empty();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SocketChannel channel) {
        this.channel = channel;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public EventLoopGroup getWorker() {
        return this.worker;
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public boolean isConnectIng() {
        return this.connectIngFlag.get();
    }

    public boolean isEnableEpoll() {
        return this.enableEpoll;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public ChannelFuture stop() {
        if (this.channel == null) {
            throw new IllegalStateException("channel is null");
        }
        return this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            this.bootstrap = null;
            this.worker.shutdownGracefully();
            this.worker = null;
            this.initFlag.set(false);
            this.channel = null;
            this.stopAfter((ChannelFuture)future);
        }));
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.stop();
        }
    }

    protected void stopAfter(ChannelFuture future) {
        if (future.cause() != null) {
            this.logger.error("stopAfter. error={}", (Object)future.cause(), (Object)future.cause());
        }
        this.logger.info("{} stop [remoteAddress = {}]...", (Object)this.getName(), (Object)this.getRemoteAddress());
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.remoteAddress.getPort();
    }

    protected void connectAfter(ChannelFuture future) {
        this.logger.info("{} connect [activeSocketConnectCount = {}, remoteAddress = {}]...", this.getName(), this.getActiveSocketChannelCount(), this.getRemoteAddress());
    }

    public int getActiveSocketChannelCount() {
        return this.channel != null && this.channel.isActive() ? 1 : 0;
    }

    public String toString() {
        return this.name + "{channel=" + this.channel + ", remoteAddress=" + this.remoteAddress.getHostName() + ":" + this.remoteAddress.getPort() + "}";
    }
}

