/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.Packet;
import com.github.netty.core.util.AsciiStringCachePool;
import com.github.netty.core.util.RecyclableUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.AsciiString;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractProtocolDecoder
extends LengthFieldBasedFrameDecoder {
    private int protocolVersionLength;

    public AbstractProtocolDecoder() {
        this(0, 0xA00000);
    }

    public AbstractProtocolDecoder(int maxLength) {
        this(0, maxLength);
    }

    public AbstractProtocolDecoder(int protocolVersionLength, int maxLength) {
        super(maxLength, 0, 2, 0, 2, true);
        this.protocolVersionLength = protocolVersionLength;
    }

    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.copy(index, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        ByteBuf msg = (ByteBuf)super.decode(ctx, buffer);
        if (msg == null) {
            return null;
        }
        boolean release = true;
        Packet packet = null;
        try {
            packet = this.newPacket(msg.readUnsignedByte());
            if (Packet.isDebugPacket()) {
                Packet.Debug debug = packet.getDebug();
                debug.setInstancePacket(msg.toString(Charset.defaultCharset()));
                debug.setInstanceThread(Thread.currentThread());
            }
            packet.setRawPacket(msg);
            packet.setAck(msg.readByte());
            packet.setProtocolVersion(msg.readSlice(this.protocolVersionLength));
            int fieldCount = msg.readUnsignedByte();
            Map<AsciiString, ByteBuf> fieldMap = packet.getFieldMap();
            if (fieldMap == null && fieldCount != 0) {
                fieldMap = new ConcurrentHashMap<AsciiString, ByteBuf>(fieldCount);
                packet.setFieldMap(fieldMap);
            }
            for (int i = 0; i < fieldCount; ++i) {
                short keyLen = msg.readUnsignedByte();
                AsciiString key = AsciiStringCachePool.newInstance(ByteBufUtil.getBytes((ByteBuf)msg, (int)msg.readerIndex(), (int)keyLen, (boolean)false));
                msg.skipBytes((int)keyLen);
                ByteBuf value = msg.readSlice(msg.readUnsignedShort());
                fieldMap.put(key, value);
            }
            int bodyLength = msg.readableBytes();
            if (bodyLength > 0) {
                packet.setBody(msg.readSlice(bodyLength));
            } else {
                packet.setBody(Unpooled.EMPTY_BUFFER);
            }
            release = false;
            Packet packet2 = packet;
            return packet2;
        }
        finally {
            if (release) {
                RecyclableUtil.release(msg);
                RecyclableUtil.release(packet);
            }
        }
    }

    protected Packet newPacket(int packetType) {
        return new Packet(packetType);
    }

    public void setProtocolVersionLength(int protocolVersionLength) {
        this.protocolVersionLength = protocolVersionLength;
    }
}

