/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.AbstractChannelHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AutoFlushChannelHandler
extends AbstractChannelHandler<Object, Object> {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long writerIdleTimeNanos;
    private volatile ScheduledFuture<?> writerIdleTimeout;
    private volatile long lastWriteTime;
    private volatile int state;

    public AutoFlushChannelHandler(long writerIdleTime, TimeUnit unit) {
        super(false);
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.writerIdleTimeNanos = Math.max(unit.toNanos(writerIdleTime), MIN_TIMEOUT_NANOS);
    }

    public static boolean isAutoFlush(ChannelPipeline pipeline) {
        return pipeline.context(AutoFlushChannelHandler.class) != null;
    }

    public static boolean flushIfNeed(ChannelHandlerContext context) {
        if (AutoFlushChannelHandler.isAutoFlush(context.pipeline())) {
            context.flush();
            return true;
        }
        return false;
    }

    public static ChannelFuture writeIfFlush(ChannelHandlerContext context, Object message) {
        if (AutoFlushChannelHandler.isAutoFlush(context.pipeline())) {
            return context.write(message);
        }
        return context.writeAndFlush(message);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.initialize(ctx);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.destroy();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    private void initialize(ChannelHandlerContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Initializing autoflush handler on channel {}", (Object)ctx.channel());
        }
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        EventExecutor loop = ctx.executor();
        this.lastWriteTime = System.nanoTime();
        this.writerIdleTimeout = loop.schedule((Runnable)new WriterIdleTimeoutTask(ctx), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
    }

    private void destroy() {
        this.state = 2;
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
    }

    private void channelIdle(ChannelHandlerContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Flushing idle Netty channel {}", (Object)ctx.channel());
        }
        ctx.channel().flush();
    }

    private final class WriterIdleTimeoutTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        WriterIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            long nextDelay = AutoFlushChannelHandler.this.writerIdleTimeNanos - (System.nanoTime() - AutoFlushChannelHandler.this.lastWriteTime);
            if (nextDelay <= 0L) {
                AutoFlushChannelHandler.this.writerIdleTimeout = (ScheduledFuture)this.ctx.executor().schedule((Runnable)this, AutoFlushChannelHandler.this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
                try {
                    AutoFlushChannelHandler.this.channelIdle(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            } else {
                AutoFlushChannelHandler.this.writerIdleTimeout = (ScheduledFuture)this.ctx.executor().schedule((Runnable)this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }
}

