/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.core.MessageToRunnable;
import com.github.netty.core.util.RecyclableUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;

@ChannelHandler.Sharable
public class DispatcherChannelHandler
extends AbstractChannelHandler<Object, Object> {
    public static final AttributeKey<MessageToRunnable> CHANNEL_ATTR_KEY_MESSAGE_TO_RUNNABLE = AttributeKey.valueOf((String)(MessageToRunnable.class + "#MessageToRunnable"));
    private Supplier<Executor> dispatcherExecutor;

    public DispatcherChannelHandler(Supplier<Executor> dispatcherExecutor) {
        super(false);
        this.dispatcherExecutor = dispatcherExecutor;
    }

    public static void setMessageToRunnable(Channel channel, MessageToRunnable messageToRunnable) {
        channel.attr(CHANNEL_ATTR_KEY_MESSAGE_TO_RUNNABLE).set((Object)messageToRunnable);
    }

    public static MessageToRunnable getMessageToRunnable(Channel channel) {
        MessageToRunnable taskFactory = (MessageToRunnable)channel.attr(CHANNEL_ATTR_KEY_MESSAGE_TO_RUNNABLE).get();
        return taskFactory;
    }

    @Override
    protected void onMessageReceived(ChannelHandlerContext context, Object msg) throws Exception {
        MessageToRunnable messageToRunnable = DispatcherChannelHandler.getMessageToRunnable(context.channel());
        if (messageToRunnable != null) {
            Runnable runnable = messageToRunnable.onMessage(context, msg);
            if (runnable != null) {
                this.run(runnable);
            }
        } else {
            this.logger.error("no handler message = {}", (Object)msg.getClass());
            RecyclableUtil.release(msg);
        }
    }

    protected void run(Runnable task) {
        Executor executor = this.getExecutor();
        try {
            if (executor != null) {
                executor.execute(task);
            } else {
                task.run();
            }
        }
        catch (RejectedExecutionException e) {
            this.logger.error("RejectedExecutionException message = {}", (Object)e.toString(), (Object)e);
        }
    }

    private Executor getExecutor() {
        if (this.dispatcherExecutor != null) {
            try {
                return this.dispatcherExecutor.get();
            }
            catch (Exception e) {
                this.logger.warn("get dispatcherExecutor failure.  msg = {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    public void setDispatcherExecutor(Supplier<Executor> dispatcherExecutor) {
        this.dispatcherExecutor = dispatcherExecutor;
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        Runnable runnable;
        MessageToRunnable messageToRunnable = DispatcherChannelHandler.getMessageToRunnable(context.channel());
        if (messageToRunnable != null && (runnable = messageToRunnable.onClose(context)) != null) {
            this.run(runnable);
        }
        super.channelInactive(context);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        Runnable runnable;
        MessageToRunnable messageToRunnable;
        if (cause.getClass() != IOException.class) {
            this.logger.error("handler exception. case={}, channel={}", cause.toString(), context.channel(), cause);
        }
        if ((messageToRunnable = DispatcherChannelHandler.getMessageToRunnable(context.channel())) != null && (runnable = messageToRunnable.onError(context, cause)) != null) {
            this.run(runnable);
        }
        context.close();
    }
}

