/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.ProtocolHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelId;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TcpChannel {
    private static final Map<ChannelId, TcpChannel> CHANNELS = new ConcurrentHashMap<ChannelId, TcpChannel>(32);
    private final Channel channel;
    private final ProtocolHandler protocol;
    private final ChannelHandler channelHandler;

    public TcpChannel(Channel channel, ProtocolHandler protocol, ChannelHandler channelHandler) {
        this.channel = channel;
        this.protocol = protocol;
        this.channelHandler = channelHandler;
    }

    public static Map<ChannelId, TcpChannel> getChannels() {
        return CHANNELS;
    }

    public String getProtocolName() {
        return this.protocol.getProtocolName();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelHandler getChannelHandler() {
        return this.channelHandler;
    }

    public ProtocolHandler getProtocol() {
        return this.protocol;
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public ChannelFuture writeAndFlush(byte[] msg) {
        return this.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])msg));
    }

    public ChannelFuture writeAndFlush(String msg, Charset charset) {
        return this.channel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)msg, (Charset)charset));
    }

    public ChannelFuture writeAndFlush(ByteBuf byteBuf) {
        return this.channel.writeAndFlush((Object)byteBuf);
    }

    public ChannelFuture close() {
        return this.channel.close();
    }

    public SocketAddress remoteAddress() {
        return this.channel.remoteAddress();
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.channel.attr(key);
    }

    public String toString() {
        return this.protocol.toString() + this.channel;
    }
}

