/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.ConcurrentLinkedHashMap;
import java.lang.ref.Reference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExpiryLRUMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    public static final Object NULL = new Object(){

        public String toString() {
            return "ExpiryLRUMap.NULL";
        }
    };
    private static final ConcurrentSkipListSet<Node> NO_EXPIRY_NODES = new ConcurrentSkipListSet((o1, o2) -> {
        long y;
        if (o1 == o2) {
            return 0;
        }
        long x = o1.getExpiryTimestamp();
        return x <= (y = o2.getExpiryTimestamp()) ? -1 : 1;
    });
    private static final BlockingQueue<Node<?, ?>> EXPIRY_NOTIFY_QUEUE = new LinkedBlockingQueue();
    private static final Set<ExpiryLRUMap<?, ?>> INSTANCE_SET = Collections.newSetFromMap(new WeakHashMap());
    private static volatile ScheduledFuture<?> SCHEDULED_FUTURE;
    private final transient LongAdder missCount = new LongAdder();
    private final transient LongAdder hitCount = new LongAdder();
    private final ConcurrentLinkedHashMap<K, Node<K, V>> map;
    private long defaultExpiryTime;
    private boolean replaceNullValueFlag = false;
    private transient Collection<V> values;
    private transient EntrySet entrySet;
    private volatile transient Consumer<Node<K, V>> onExpiryConsumer = this::onExpiry;
    private volatile transient Consumer<Node<K, V>> onEvictionConsumer = this::onEviction;
    private volatile transient Consumer<Node<K, V>> onRemoveConsumer = this::onRemove;

    public ExpiryLRUMap() {
        this(Long.MAX_VALUE);
    }

    public ExpiryLRUMap(long defaultExpiryTime) {
        this(256, Long.MAX_VALUE, defaultExpiryTime, null);
    }

    public ExpiryLRUMap(int initialCapacity, long maxCacheSize, long defaultExpiryTime, ConcurrentLinkedHashMap.Weigher<Node<K, V>> weigher) {
        this(initialCapacity, maxCacheSize, defaultExpiryTime, weigher, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpiryLRUMap(int initialCapacity, long maxCacheSize, long defaultExpiryTime, ConcurrentLinkedHashMap.Weigher<Node<K, V>> weigher, Class<? extends Reference> referenceType) {
        this.defaultExpiryTime = defaultExpiryTime < 0L ? -1L : defaultExpiryTime;
        this.map = new ConcurrentLinkedHashMap.Builder().initialCapacity(initialCapacity).maximumWeightedCapacity(maxCacheSize).referenceType(referenceType).weigher(weigher == null ? ConcurrentLinkedHashMap.Weighers.singleton() : weigher).listener((key, value) -> {
            Consumer<Node<K, V>> onEvictionConsumer = this.onEvictionConsumer;
            if (onEvictionConsumer != null) {
                onEvictionConsumer.accept((Node<K, V>)value);
            }
        }).build();
        Set<ExpiryLRUMap<?, ?>> set = INSTANCE_SET;
        synchronized (set) {
            INSTANCE_SET.add(this);
            if (SCHEDULED_FUTURE == null) {
                SCHEDULED_FUTURE = ExpiresScan.scheduleWithFixedDelay();
            }
        }
    }

    public static Set<ExpiryLRUMap> getInstanceSet() {
        return Collections.unmodifiableSet(INSTANCE_SET);
    }

    public static BlockingQueue<Node<?, ?>> getExpiryNotifyQueue() {
        return EXPIRY_NOTIFY_QUEUE;
    }

    public static boolean isExpiry(Node node) {
        if (node.expiryTimestamp == Long.MAX_VALUE) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime > node.expiryTimestamp;
    }

    private static void localVarTest() throws InterruptedException {
        Object aa;
        ExpiryLRUMap<String, String> lruMap = new ExpiryLRUMap<String, String>();
        lruMap.put("data3", "1233", -1L);
        lruMap.put("data", "123", 5000L);
        System.out.println("\u521d\u59cb\u5316 new ExpiryLRUMap() set = " + INSTANCE_SET);
        do {
            aa = lruMap.get("data");
            System.out.println("data = " + aa);
            Thread.sleep(1000L);
        } while (aa != null);
    }

    public static void main(String[] args) throws InterruptedException {
        int j;
        System.out.println("set = " + INSTANCE_SET);
        System.out.println("gc \u524d set = " + INSTANCE_SET);
        System.gc();
        System.out.println("gc \u540e set = " + INSTANCE_SET);
        int i = 0;
        ExpiryLRUMap<String, Integer> expiryLRUMap = new ExpiryLRUMap<String, Integer>(1, 3333L, Integer.MAX_VALUE, null);
        for (j = 0; j < 100; ++j) {
            expiryLRUMap.put(j + "", j);
        }
        for (j = 1000; j > 0; --j) {
            expiryLRUMap.put(j + "", j);
        }
        System.out.println("expiryLRUMap = " + expiryLRUMap);
        expiryLRUMap.setOnEvictionConsumer(node -> {
            long expiry = node.getExpiryTimestamp() - node.getCreateTimestamp();
            long timeout = System.currentTimeMillis() - node.getCreateTimestamp();
            System.out.println("eviction event. expiry = " + expiry + ", timeout=" + timeout);
        });
        expiryLRUMap.setOnExpiryConsumer(node -> {
            long expiry = node.getExpiryTimestamp() - node.getCreateTimestamp();
            long timeout = System.currentTimeMillis() - node.getCreateTimestamp();
            System.out.println("expiry event. expiry = " + expiry + ", timeout=" + timeout);
        });
        while (i++ < 3) {
            expiryLRUMap.put(i + "", i, 1000L);
            Set<ExpiryLRUMap<?, ?>> set = INSTANCE_SET;
            System.out.println("set = " + INSTANCE_SET);
        }
        System.gc();
    }

    public long weightedSize() {
        return this.map.weightedSize();
    }

    public long getMaxCacheSize() {
        return this.map.capacity();
    }

    public void setMaxCacheSize(long maxCacheSize) {
        this.map.setCapacity(maxCacheSize);
    }

    public Consumer<Node<K, V>> getOnEvictionConsumer() {
        return this.onEvictionConsumer;
    }

    public void setOnEvictionConsumer(Consumer<Node<K, V>> onEvictionConsumer) {
        this.onEvictionConsumer = onEvictionConsumer;
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public Consumer<Node<K, V>> getOnExpiryConsumer() {
        return this.onExpiryConsumer;
    }

    public void setOnExpiryConsumer(Consumer<Node<K, V>> onExpiryConsumer) {
        this.onExpiryConsumer = onExpiryConsumer;
    }

    public void setOnRemoveConsumer(Consumer<Node<K, V>> onRemoveConsumer) {
        this.onRemoveConsumer = onRemoveConsumer;
    }

    public boolean isReplaceNullValueFlag() {
        return this.replaceNullValueFlag;
    }

    public void setReplaceNullValueFlag(boolean replaceNullValueFlag) {
        this.replaceNullValueFlag = replaceNullValueFlag;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, this.defaultExpiryTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value, long timeout) {
        if (value == null) {
            value = NULL;
        }
        Node<K, V> old = this.map.get(key);
        Node<K, V> node = new Node<K, V>(timeout, key, value, this);
        if (old != null) {
            Node<K, V> node2 = old;
            synchronized (node2) {
                ((Node)old).covered = true;
                this.map.put(key, node);
                return old.getData();
            }
        }
        this.map.put(key, node);
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node<K, V> node : this.map.values()) {
            if (!Objects.equals(node.getData(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        Node<K, V> old = this.map.remove(key);
        if (old == null) {
            return null;
        }
        this.notifyRemove(old);
        return old.getData();
    }

    public void notifyRemove(Node<K, V> node) {
        Consumer<Node<K, V>> onRemoveConsumer = this.onRemoveConsumer;
        if (onRemoveConsumer != null) {
            onRemoveConsumer.accept(node);
        }
    }

    public V atomicGet(K key, Supplier<V> supplier) {
        Node<K, V> old = this.map.get(key);
        if (old == null) {
            this.missCount.increment();
            V value = supplier.get();
            this.put(key, value);
            return value;
        }
        this.hitCount.increment();
        return old.getData();
    }

    @Override
    public V get(Object key) {
        Node<K, V> old = this.map.get(key);
        if (old == null) {
            this.missCount.increment();
            return null;
        }
        this.hitCount.increment();
        return old.getDataIfExpiry();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        if (vs == null) {
            vs = this.values = new Values(this.map.values());
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (this.entrySet == null) {
            es = this.entrySet = new EntrySet(this.map.entrySet());
        }
        return es;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.get(key);
        return v != null ? v : defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            action.accept(k, v);
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        Node<K, V> old = this.map.get(key);
        if (old != null && Objects.equals(old.getData(), value)) {
            this.map.remove(key, old);
            this.notifyRemove(old);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V newValue) {
        Node<K, V> old = this.map.get(key);
        if (old != null) {
            this.map.put(key, new Node<K, V>(((Node)old).expiryTime, key, newValue, this));
            return old.getData();
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Node<K, V> old = this.map.get(key);
        if (old != null && Objects.equals(old.getData(), oldValue)) {
            this.map.put(key, new Node<K, V>(((Node)old).expiryTime, key, newValue, this));
            return true;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        for (Map.Entry<K, Node<K, Node<K, V>>> entry : this.map.entrySet()) {
            Node<K, V> old = entry.getValue();
            K key = entry.getKey();
            V value = old.getData();
            V newValue = function.apply(key, value);
            entry.setValue(new Node<K, V>(((Node)old).expiryTime, key, newValue, this));
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        V v = this.get(key);
        return v == null && (newValue = mappingFunction.apply(key)) != null && (v = this.putIfAbsent(key, newValue)) == null ? newValue : v;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V oldValue;
        Objects.requireNonNull(remappingFunction);
        while ((oldValue = this.get(key)) != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                if (!this.replace(key, oldValue, newValue)) continue;
                return newValue;
            }
            if (!this.remove(key, oldValue)) continue;
            return null;
        }
        return oldValue;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Objects.requireNonNull(remappingFunction);
        V oldValue = this.get(key);
        while (true) {
            if ((newValue = remappingFunction.apply(key, oldValue)) == null) {
                if (oldValue != null || this.containsKey(key)) {
                    if (this.remove(key, oldValue)) {
                        return null;
                    }
                    oldValue = this.get(key);
                    continue;
                }
                return null;
            }
            if (oldValue != null) {
                if (this.replace(key, oldValue, newValue)) {
                    return newValue;
                }
                oldValue = this.get(key);
                continue;
            }
            oldValue = this.putIfAbsent(key, newValue);
            if (oldValue == null) break;
        }
        return newValue;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        V oldValue = this.get(key);
        while (true) {
            if (oldValue != null) {
                V newValue = remappingFunction.apply(oldValue, value);
                if (newValue != null) {
                    if (this.replace(key, oldValue, newValue)) {
                        return newValue;
                    }
                } else if (this.remove(key, oldValue)) {
                    return null;
                }
                oldValue = this.get(key);
                continue;
            }
            oldValue = this.putIfAbsent(key, value);
            if (oldValue == null) break;
        }
        return value;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V v = this.get(key);
        if (v == null) {
            v = this.put(key, value);
        }
        return v;
    }

    public long getDefaultExpiryTime() {
        return this.defaultExpiryTime;
    }

    public void setDefaultExpiryTime(long defaultExpiryTime) {
        this.defaultExpiryTime = defaultExpiryTime;
    }

    @Override
    public String toString() {
        ConcurrentLinkedHashMap<K, Node<K, V>> concurrentLinkedHashMap = this.map;
        synchronized (concurrentLinkedHashMap) {
            Iterator<Map.Entry<K, Node<K, V>>> i = this.map.entrySet().iterator();
            if (!i.hasNext()) {
                return "{}";
            }
            long currentTime = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            while (true) {
                Map.Entry<K, Node<K, V>> e = i.next();
                K key = e.getKey();
                Node<K, V> node = e.getValue();
                V value = node.getDataIfExpiry();
                long timeout = ((Node)node).expiryTimestamp;
                sb.append((Object)(key == this ? "(this Map)" : key));
                sb.append('=');
                sb.append((Object)(value == this ? "(this Map)" : value));
                sb.append('|');
                sb.append((timeout - currentTime) / 1000L);
                sb.append("/s");
                if (!i.hasNext()) {
                    return sb.append('}').toString();
                }
                sb.append(',').append(' ');
            }
        }
    }

    public void onExpiry(Node<K, V> node) {
    }

    public void onEviction(Node<K, V> node) {
    }

    public void onRemove(Node<K, V> node) {
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, Node<K, V>>> entries;

        EntrySet(Set<Map.Entry<K, Node<K, V>>> entries) {
            this.entries = entries;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private Iterator<Map.Entry<K, Node<K, V>>> iterator;
                {
                    this.iterator = EntrySet.this.entries.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Map.Entry next = this.iterator.next();
                    final Object key = next.getKey();
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return ((Node)next.getValue()).getDataIfExpiry();
                        }

                        @Override
                        public V setValue(V value) {
                            Node old = (Node)next.getValue();
                            if (old == null) {
                                return null;
                            }
                            next.setValue(new Node(old.expiryTime, key, value, ExpiryLRUMap.this));
                            return old.getData();
                        }

                        @Override
                        public boolean equals(Object o) {
                            if (this == o) {
                                return true;
                            }
                            if (!(o instanceof Map.Entry)) {
                                return false;
                            }
                            Map.Entry node = (Map.Entry)o;
                            return Objects.equals(this.getKey(), node.getKey()) && Objects.equals(this.getValue(), node.getValue());
                        }

                        @Override
                        public int hashCode() {
                            return Objects.hash(this.getKey(), this.getValue());
                        }
                    };
                }

                @Override
                public void remove() {
                    this.iterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.entries.size();
        }
    }

    class Values
    extends AbstractCollection<V> {
        private final Collection<Node<K, V>> values;

        Values(Collection<Node<K, V>> values) {
            this.values = values;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private Iterator<Node<K, V>> iterator;
                {
                    this.iterator = Values.this.values.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public V next() {
                    return this.iterator.next().getDataIfExpiry();
                }

                @Override
                public void remove() {
                    this.iterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.values.size();
        }
    }

    public static class ExpiresScan
    implements Runnable {
        public static final ExpiresNotify NOTIFY_INSTANCE = new ExpiresNotify();
        static final ScheduledExecutorService SCHEDULED = Executors.newScheduledThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("ExpiryLRUMap-ExpiresScan-" + thread.getId());
            thread.setPriority(1);
            return thread;
        });
        private static final ExpiresScan INSTANCE = new ExpiresScan();
        private final Consumer<Node<?, ?>> removeConsumer = ExpiryLRUMap.access$400()::offer;

        static long getScheduleInterval() {
            String intervalMillisecond = System.getProperty("ExpiryLRUMap-ExpiresScan.interval");
            long intervalLong = 100L;
            if (intervalMillisecond != null && !intervalMillisecond.isEmpty()) {
                try {
                    intervalLong = Long.parseLong(intervalMillisecond);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return intervalLong;
        }

        public static ScheduledFuture<?> scheduleWithFixedDelay() {
            long intervalLong = ExpiresScan.getScheduleInterval();
            return SCHEDULED.scheduleWithFixedDelay(INSTANCE, intervalLong, intervalLong, TimeUnit.MICROSECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (INSTANCE_SET.isEmpty()) {
                Set set = INSTANCE_SET;
                synchronized (set) {
                    if (INSTANCE_SET.isEmpty()) {
                        NO_EXPIRY_NODES.clear();
                        ScheduledFuture scheduledFuture = SCHEDULED_FUTURE;
                        scheduledFuture.cancel(false);
                        SCHEDULED_FUTURE = null;
                    }
                }
                return;
            }
            if (NO_EXPIRY_NODES.isEmpty()) {
                return;
            }
            Node<Object, Object> now = new Node<Object, Object>(0L, null, null, null);
            SortedSet expiryNodes = NO_EXPIRY_NODES.headSet(now);
            if (expiryNodes.isEmpty()) {
                return;
            }
            Iterator iterator = expiryNodes.iterator();
            while (iterator.hasNext()) {
                Node expiryRemoveNode;
                Node node = expiryRemoveNode = (Node)iterator.next();
                synchronized (node) {
                    boolean remove = expiryRemoveNode.getExpiryLRUMap().map.remove(expiryRemoveNode.getKey(), expiryRemoveNode);
                    if (!remove && !expiryRemoveNode.covered) {
                        continue;
                    }
                }
                try {
                    iterator.remove();
                    this.removeConsumer.accept(expiryRemoveNode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        static {
            NOTIFY_INSTANCE.setName("ExpiryLRUMap-ExpiresNotify-" + NOTIFY_INSTANCE.getId());
            NOTIFY_INSTANCE.start();
        }
    }

    public static class ExpiresNotify
    extends Thread {
        @Override
        public void run() {
            while (true) {
                Node node;
                try {
                    node = (Node)EXPIRY_NOTIFY_QUEUE.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                Consumer consumer = node.expiryLRUMap.onExpiryConsumer;
                if (consumer == null) continue;
                try {
                    consumer.accept(node);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public static class Node<KEY, VALUE> {
        private final ExpiryLRUMap<KEY, VALUE> expiryLRUMap;
        private final long createTimestamp = System.currentTimeMillis();
        private final long expiryTimestamp;
        private final long expiryTime;
        private final VALUE data;
        private final KEY key;
        private volatile boolean covered = false;

        Node(long timeout, KEY key, VALUE value, ExpiryLRUMap<KEY, VALUE> expiryLRUMap) {
            long expiryTimestamp;
            this.expiryTime = timeout;
            if (timeout == Long.MAX_VALUE || timeout < 0L) {
                expiryTimestamp = Long.MAX_VALUE;
            } else {
                expiryTimestamp = System.currentTimeMillis() + timeout;
                if (expiryTimestamp < 0L) {
                    expiryTimestamp = Long.MAX_VALUE;
                }
            }
            this.expiryTimestamp = expiryTimestamp;
            this.key = key;
            this.data = value;
            this.expiryLRUMap = expiryLRUMap;
            if (expiryLRUMap != null && expiryTimestamp != Long.MAX_VALUE) {
                NO_EXPIRY_NODES.add(this);
            }
        }

        public boolean isCovered() {
            return this.covered;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public ExpiryLRUMap<KEY, VALUE> getExpiryLRUMap() {
            return this.expiryLRUMap;
        }

        public long getExpiryTime() {
            return this.expiryTime;
        }

        public VALUE getDataIfExpiry() {
            if (this.isExpiry()) {
                return null;
            }
            return this.getData();
        }

        public VALUE getData() {
            if (this.expiryLRUMap.isReplaceNullValueFlag()) {
                return this.data;
            }
            return this.data == NULL ? null : (VALUE)this.data;
        }

        public KEY getKey() {
            return this.key;
        }

        public long getExpiryTimestamp() {
            return this.expiryTimestamp;
        }

        public long getCreateTimestamp() {
            return this.createTimestamp;
        }

        public boolean isExpiry() {
            return ExpiryLRUMap.isExpiry(this);
        }

        public String toString() {
            VALUE data = this.getData();
            return data == null ? "null" : data.toString();
        }
    }
}

