/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.StringJoiner;

public class HostUtil {
    private static InetAddress inetAddress;
    private static String userName;
    private static String osName;
    private static String osArch;
    private static boolean embedded;
    private static boolean is64bit;
    private static int pid;

    public static boolean isExistPort(int port) {
        try {
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress("127.0.0.1", port);
            socket.bind(address);
            socket.close();
            return false;
        }
        catch (Exception e) {
            return e instanceof BindException;
        }
    }

    public static boolean isLocalhost(String host) {
        return "localhost".equalsIgnoreCase(host) || host.contains("0.0.0.0") || host.contains("127.0.0.1");
    }

    public static int getPid() {
        return pid;
    }

    public static String getUserName() {
        return userName;
    }

    public static String getOsName() {
        return osName;
    }

    public static boolean is64Bit() {
        return is64bit;
    }

    public static boolean isWindows() {
        return osName.startsWith("windows");
    }

    public static boolean isMacOSX() {
        return osName.startsWith("mac os x");
    }

    public static boolean isLinux() {
        return osName.startsWith("linux");
    }

    public static boolean isIOS() {
        return osName.startsWith("ios");
    }

    public static String getIPAddress() {
        InetAddress inetAddress = HostUtil.getInetAddress();
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    public static InetAddress getInetAddress() {
        if (inetAddress != null) {
            return inetAddress;
        }
        try {
            InetAddress address = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        inetAddress = inetAddr;
                        return inetAddress;
                    }
                    if (address != null) continue;
                    address = inetAddr;
                }
            }
            if (address == null) {
                address = InetAddress.getLocalHost();
            }
            inetAddress = address;
            return inetAddress;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isEmbedded() {
        return embedded;
    }

    public static String getMac() {
        try {
            Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
            while (el.hasMoreElements()) {
                byte[] mac = el.nextElement().getHardwareAddress();
                if (mac == null || mac.length <= 0) continue;
                String hexstr = HostUtil.bytesToHexString(mac);
                return HostUtil.getSplitString(hexstr, "-", 2).toUpperCase();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static String getSplitString(String str, String split, int length) {
        if (str == null || split.length() == 0) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i % length == 0 && i > 0) {
                sb.append(split);
            }
            sb.append(str.charAt(i));
        }
        String[] attrs = sb.toString().split(split);
        StringJoiner stringJoiner = new StringJoiner(split);
        for (String attr : attrs) {
            stringJoiner.add(attr);
        }
        return stringJoiner.toString();
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    static {
        is64bit = false;
        embedded = AccessController.doPrivileged(() -> {
            osName = System.getProperty("os.name").toLowerCase();
            osArch = System.getProperty("os.arch").toLowerCase();
            String name = ManagementFactory.getRuntimeMXBean().getName();
            pid = Integer.parseInt(name.split("@")[0]);
            userName = name.split("@")[1];
            is64bit = osArch.equals("x64") || osArch.equals("x86_64") || osArch.equals("ia64");
            return Boolean.getBoolean("com.sun.javafx.isEmbedded");
        });
    }
}

