/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.core.util.ThreadPoolX;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;

public class IOUtil {
    public static final int BYTE_LENGTH = 1;
    public static final int INT_LENGTH = 4;
    public static final int CHAR_LENGTH = 2;
    public static final int SHORT_LENGTH = 2;
    public static final int LONG_LENGTH = 8;
    public static boolean FORCE_META_DATA = false;

    public static byte[] merge(byte[] bytes1, byte[] bytes2) {
        byte[] newBytes = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, newBytes, 0, bytes1.length);
        System.arraycopy(bytes2, 0, newBytes, bytes1.length, bytes2.length);
        return newBytes;
    }

    public static void writerModeToReadMode(ByteBuf byteBuf) {
        if (byteBuf == null) {
            return;
        }
        if (byteBuf.readableBytes() == 0 && byteBuf.capacity() > 0) {
            byteBuf.writerIndex(byteBuf.capacity());
        }
    }

    public static void copyFile(String sourcePath, String sourceFileName, String targetPath, String targetFileName, boolean append) throws FileNotFoundException, IOException {
        if (sourcePath == null) {
            sourcePath = "";
        }
        if (targetPath == null) {
            targetPath = "";
        }
        File parentTarget = new File(targetPath);
        parentTarget.mkdirs();
        File inFile = new File(sourcePath.concat(File.separator).concat(sourceFileName));
        File outFile = new File(parentTarget, targetFileName);
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        try (FileChannel inChannel = new FileInputStream(inFile).getChannel();
             FileChannel outChannel = new FileOutputStream(outFile, append).getChannel();){
            long writeBeginIndex = append ? outChannel.size() : 0L;
            FileLock lock = outChannel.lock(writeBeginIndex, Long.MAX_VALUE - writeBeginIndex, false);
            outChannel.transferFrom(inChannel, writeBeginIndex, inChannel.size());
            lock.release();
            outChannel.force(FORCE_META_DATA);
        }
    }

    public static File writeFile(final byte[] data, String targetPath, String targetFileName, boolean append) throws IOException {
        return IOUtil.writeFile(new Iterator<ByteBuffer>(){
            ByteBuffer buffer;
            {
                this.buffer = ByteBuffer.wrap(data);
            }

            @Override
            public boolean hasNext() {
                return this.buffer != null;
            }

            @Override
            public ByteBuffer next() {
                ByteBuffer tempBuffer = this.buffer;
                this.buffer = null;
                return tempBuffer;
            }
        }, targetPath, targetFileName, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeFile(InputStream in, String targetPath, String targetFileName, boolean append) throws IOException {
        if (targetPath == null) {
            targetPath = "";
        }
        File parent = new File(targetPath);
        parent.mkdirs();
        File outFile = new File(parent, targetFileName);
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        FileChannel outChannel = new FileOutputStream(outFile, append).getChannel();
        long writeBeginIndex = append ? outChannel.size() : 0L;
        ReadableByteChannel inChannel = Channels.newChannel(in);
        FileLock lock = outChannel.lock(writeBeginIndex, Long.MAX_VALUE - writeBeginIndex, false);
        try {
            outChannel.transferFrom(inChannel, writeBeginIndex, Long.MAX_VALUE);
        }
        finally {
            lock.release();
            outChannel.force(FORCE_META_DATA);
            inChannel.close();
            outChannel.close();
        }
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeFile(Iterator<ByteBuffer> dataIterator, String targetPath, String targetFileName, boolean append) throws IOException {
        if (targetPath == null) {
            targetPath = "";
        }
        new File(targetPath).mkdirs();
        File outFile = new File(targetPath.concat(File.separator).concat(targetFileName));
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        FileChannel outChannel = new FileOutputStream(outFile, append).getChannel();
        long writeBeginIndex = append ? outChannel.size() : 0L;
        FileLock lock = outChannel.lock(writeBeginIndex, Long.MAX_VALUE - writeBeginIndex, false);
        try {
            while (dataIterator.hasNext()) {
                ByteBuffer buffer = dataIterator.next();
                if (buffer == null) continue;
                if (!buffer.hasRemaining()) {
                    buffer.flip();
                }
                outChannel.write(buffer);
            }
        }
        finally {
            lock.release();
            outChannel.force(FORCE_META_DATA);
            outChannel.close();
        }
        return outFile;
    }

    public static String trimFilename(String fileName) {
        return fileName.replace(":", "").replace("?", "").replace("|", "").replace("<", "").replace(">", "").replace("*", "").replace("\"", "").trim();
    }

    /*
     * Exception decompiling
     */
    public static ByteBuf readFileToByteBuf(String sourcePath, String sourceFileName) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToBytes(String sourcePath, String sourceFileName) throws FileNotFoundException, IOException {
        ByteBuf byteBuf = IOUtil.readFileToByteBuf(sourcePath, sourceFileName);
        IOUtil.writerModeToReadMode(byteBuf);
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)byteBuf.readerIndex(), (int)byteBuf.readableBytes(), (boolean)false);
            return byArray;
        }
        finally {
            RecyclableUtil.release(byteBuf);
        }
    }

    public static String readFileToString(String sourcePath, String sourceFileName, String charset) throws FileNotFoundException {
        return IOUtil.readInput(IOUtil.newFileInputStream(sourcePath, sourceFileName), charset);
    }

    public static String readInput(InputStream inputStream) {
        return IOUtil.readInput(inputStream, Charset.defaultCharset().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInput(InputStream inputStream, String encode) {
        StringBuilder sb = RecyclableUtil.newStringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, encode));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            if (sb.length() > 0) {
                String string = sb.substring(0, sb.length() - 1);
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static FileOutputStream newFileOutputStream(String targetPath, String targetFileName, boolean append) throws IOException {
        if (targetPath == null) {
            targetPath = "";
        }
        new File(targetPath).mkdirs();
        File outFile = new File(targetPath.concat(File.separator).concat(targetFileName));
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        return new FileOutputStream(outFile, append);
    }

    public static FileInputStream newFileInputStream(String sourcePath, String sourceFileName) throws FileNotFoundException {
        if (sourcePath == null) {
            sourcePath = "";
        }
        File inFile = new File(sourcePath.concat(File.separator).concat(sourceFileName));
        return new FileInputStream(inFile);
    }

    public static int indexOf(ByteBuf byteBuf, byte value) {
        int len = byteBuf.readableBytes();
        for (int i = 0; i < len; ++i) {
            byte b = byteBuf.getByte(i);
            if (b != value) continue;
            return i;
        }
        return -1;
    }

    public static void deleteDirChild(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        String[] childrens = dir.list();
        if (childrens != null) {
            for (String children : childrens) {
                IOUtil.deleteDir(new File(dir, children));
            }
        }
    }

    public static boolean deleteDir(File dir) {
        String[] childrens;
        if (dir.isDirectory() && (childrens = dir.list()) != null) {
            for (String children : childrens) {
                boolean success = IOUtil.deleteDir(new File(dir, children));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static long readLong(InputStream in) throws IOException {
        byte[] bytes = new byte[8];
        in.read(bytes);
        return IOUtil.getLong(bytes, 0);
    }

    public static String getString(byte[] memory, Charset charset) {
        return new String(memory, charset);
    }

    public static byte getByte(byte[] memory, int index) {
        return memory[index];
    }

    public static short getShort(byte[] memory, int index) {
        return (short)(memory[index] << 8 | memory[index + 1] & 0xFF);
    }

    public static short getShortLE(byte[] memory, int index) {
        return (short)(memory[index] & 0xFF | memory[index + 1] << 8);
    }

    public static long getUnsignedInt(byte[] memory, int index) {
        return (long)IOUtil.getInt(memory, index) & 0xFFFFFFFFL;
    }

    public static int getUnsignedByte(byte[] memory, int index) {
        return IOUtil.getByte(memory, index) & 0xFF;
    }

    public static int getUnsignedShort(byte[] memory, int index) {
        return IOUtil.getShort(memory, index) & 0xFFFF;
    }

    public static int getUnsignedMedium(byte[] memory, int index) {
        return (memory[index] & 0xFF) << 16 | (memory[index + 1] & 0xFF) << 8 | memory[index + 2] & 0xFF;
    }

    public static int getUnsignedMediumLE(byte[] memory, int index) {
        return memory[index] & 0xFF | (memory[index + 1] & 0xFF) << 8 | (memory[index + 2] & 0xFF) << 16;
    }

    public static int getInt(byte[] memory, int index) {
        return (memory[index] & 0xFF) << 24 | (memory[index + 1] & 0xFF) << 16 | (memory[index + 2] & 0xFF) << 8 | memory[index + 3] & 0xFF;
    }

    public static int getInt(AsciiString memory) {
        return (memory.byteAt(0) & 0xFF) << 24 | (memory.byteAt(1) & 0xFF) << 16 | (memory.byteAt(2) & 0xFF) << 8 | memory.byteAt(3) & 0xFF;
    }

    public static int getIntLE(byte[] memory, int index) {
        return memory[index] & 0xFF | (memory[index + 1] & 0xFF) << 8 | (memory[index + 2] & 0xFF) << 16 | (memory[index + 3] & 0xFF) << 24;
    }

    public static long getLong(byte[] memory, int index) {
        return ((long)memory[index] & 0xFFL) << 56 | ((long)memory[index + 1] & 0xFFL) << 48 | ((long)memory[index + 2] & 0xFFL) << 40 | ((long)memory[index + 3] & 0xFFL) << 32 | ((long)memory[index + 4] & 0xFFL) << 24 | ((long)memory[index + 5] & 0xFFL) << 16 | ((long)memory[index + 6] & 0xFFL) << 8 | (long)memory[index + 7] & 0xFFL;
    }

    public static long getLongLE(byte[] memory, int index) {
        return (long)memory[index] & 0xFFL | ((long)memory[index + 1] & 0xFFL) << 8 | ((long)memory[index + 2] & 0xFFL) << 16 | ((long)memory[index + 3] & 0xFFL) << 24 | ((long)memory[index + 4] & 0xFFL) << 32 | ((long)memory[index + 5] & 0xFFL) << 40 | ((long)memory[index + 6] & 0xFFL) << 48 | ((long)memory[index + 7] & 0xFFL) << 56;
    }

    public static void setByte(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
    }

    public static void setShort(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 8);
        memory[index + 1] = (byte)value;
    }

    public static void setShortLE(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
        memory[index + 1] = (byte)(value >>> 8);
    }

    public static void setMedium(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 16);
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)value;
    }

    public static void setMediumLE(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)(value >>> 16);
    }

    public static void setInt(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 24);
        memory[index + 1] = (byte)(value >>> 16);
        memory[index + 2] = (byte)(value >>> 8);
        memory[index + 3] = (byte)value;
    }

    public static void setIntLE(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)(value >>> 16);
        memory[index + 3] = (byte)(value >>> 24);
    }

    public static void setLong(byte[] memory, int index, long value) {
        memory[index] = (byte)(value >>> 56);
        memory[index + 1] = (byte)(value >>> 48);
        memory[index + 2] = (byte)(value >>> 40);
        memory[index + 3] = (byte)(value >>> 32);
        memory[index + 4] = (byte)(value >>> 24);
        memory[index + 5] = (byte)(value >>> 16);
        memory[index + 6] = (byte)(value >>> 8);
        memory[index + 7] = (byte)value;
    }

    public static void setLongLE(byte[] memory, int index, long value) {
        memory[index] = (byte)value;
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)(value >>> 16);
        memory[index + 3] = (byte)(value >>> 24);
        memory[index + 4] = (byte)(value >>> 32);
        memory[index + 5] = (byte)(value >>> 40);
        memory[index + 6] = (byte)(value >>> 48);
        memory[index + 7] = (byte)(value >>> 56);
    }

    public static void main(String[] args) throws InterruptedException {
        System.setProperty("netty-core.defaultThreadPoolCount", "1000");
        int count = 100;
        final CountDownLatch latch = new CountDownLatch(count);
        for (int i = 0; i < count; ++i) {
            ThreadPoolX.getDefaultInstance().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IOUtil.copyFile("C:\\ProgramData\\MySQL\\MySQL Server 5.5\\data\\messagecenter", "db.opt", "D:\\", "test_copyFile_bytes.txt", false);
                        byte[] bytes = IOUtil.readFileToBytes("D:\\", "test_copyFile_bytes.txt");
                        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                        IOUtil.writeFile(in, "D:\\", "test_writeFile_bytes.txt", false);
                        IOUtil.writeFile(Arrays.asList(ByteBuffer.wrap("1".getBytes()), ByteBuffer.wrap("2".getBytes()), ByteBuffer.wrap("\r\n".getBytes())).iterator(), "D:\\", "test_writeFile_123.txt", false);
                        System.out.println(Thread.currentThread());
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        latch.await();
        ThreadPoolX.getDefaultInstance().shutdown();
    }
}

