/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaClassFile {
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private static final Attribute.CodeException[] EMPTY_CODE_EXCEPTIONS = new Attribute.CodeException[0];
    private static final Attribute.LineNumber[] EMPTY_LINE_NUMBER_TABLE = new Attribute.LineNumber[0];
    private static final Attribute.LocalVariable[] EMPTY_LOCAL_VARIABLE_TABLE = new Attribute.LocalVariable[0];
    private static final Attribute.InnerClass[] EMPTY_INNER_CLASSES = new Attribute.InnerClass[0];
    private static final Attribute.StackMapEntry[] EMPTY_STACK_MAP_ENTRY = new Attribute.StackMapEntry[0];
    private static final Attribute.StackMapFrame[] EMPTY_STACK_MAP_FRAME = new Attribute.StackMapFrame[0];
    private static final Attribute.BootstrapMethod[] EMPTY_BOOT_STRAP_METHOD = new Attribute.BootstrapMethod[0];
    private static final Attribute.StackMapType[] EMPTY_STACK_MAP_TYPE = new Attribute.StackMapType[0];
    private static final Attribute.MethodParameter[] EMPTY_METHOD_PARAMETER = new Attribute.MethodParameter[0];
    private static final int[] EMPTY_EXCEPTION_INDEX_TABLE = new int[0];
    private static final String[] EMPTY_STRING = new String[0];
    private long minorVersion;
    private JavaVersion majorVersion;
    private ConstantPool constantPool;
    private int accessFlags;
    private int thisClassIndex;
    private int superClassIndex;
    private int[] interfacesIndex;
    private Member[] fields;
    private Member[] methods;
    private Attribute[] attributes;
    private Class clazz;

    public static String getClassFileName(Class<?> clazz) {
        Objects.requireNonNull(clazz, "Class must not be null");
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + ".class";
    }

    public JavaClassFile(Class clazz) throws ClassNotFoundException, IOException, IllegalClassFormatException {
        this(new ClassReader(clazz));
        this.clazz = clazz;
    }

    public JavaClassFile(String path, String name) throws ClassNotFoundException, IOException, IllegalClassFormatException {
        this(new ClassReader(path, name));
    }

    public JavaClassFile(InputStream in) throws IOException, IllegalClassFormatException {
        this(new ClassReader(in));
    }

    public JavaClassFile(byte[] codes) throws IllegalClassFormatException {
        this(new ClassReader(codes));
    }

    public JavaClassFile(ClassReader reader) throws IllegalClassFormatException {
        int magic = reader.readInt32();
        if (magic != -889275714) {
            throw new IllegalClassFormatException("is not a Java .class file");
        }
        this.minorVersion = reader.readUint16();
        this.majorVersion = JavaVersion.valueOf(reader.readUint16());
        this.constantPool = this.readConstantPool(reader);
        this.accessFlags = this.readAccessFlags(reader);
        this.thisClassIndex = reader.readUint16();
        this.superClassIndex = reader.readUint16();
        this.interfacesIndex = reader.readUint16s();
        this.fields = this.readMembers(reader, false);
        this.methods = this.readMembers(reader, true);
        this.attributes = this.readAttributes(reader, null);
        reader.close();
    }

    private int readAccessFlags(ClassReader reader) {
        int accessFlags = reader.readUint16();
        if ((accessFlags & 0x200) != 0) {
            accessFlags |= 0x400;
        }
        return accessFlags;
    }

    private ConstantPool readConstantPool(ClassReader reader) {
        int constantPoolCount = reader.readUint16();
        return new ConstantPool(constantPoolCount, reader);
    }

    private Member[] readMembers(ClassReader reader, boolean method) {
        int memberCount = reader.readUint16();
        Member[] members = new Member[memberCount];
        for (int i = 0; i < members.length; ++i) {
            members[i] = new Member();
            members[i].method = method;
            members[i].classFile = this;
            members[i].accessFlags = reader.readUint16();
            members[i].nameIndex = reader.readUint16();
            members[i].descriptorIndex = reader.readUint16();
            members[i].name = this.constantPool.getUtf8(members[i].nameIndex);
            members[i].descriptorName = this.constantPool.getUtf8(members[i].descriptorIndex);
            Member.access$702(members[i], this.readAttributes(reader, null));
        }
        return members;
    }

    private Attribute[] readAttributes(ClassReader reader, Attribute parent) {
        int attributesCount = reader.readUint16();
        if (attributesCount == 0) {
            return EMPTY_ATTRIBUTES;
        }
        Attribute[] attributes = new Attribute[attributesCount];
        for (int i = 0; i < attributes.length; ++i) {
            int attrNameIndex = reader.readUint16();
            attributes[i] = new Attribute(attrNameIndex, reader.readInt32(), parent, reader);
        }
        return attributes;
    }

    public JavaVersion getMajorVersion() {
        return this.majorVersion;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public Member[] getFields() {
        return this.fields;
    }

    public Member[] getMethods() {
        return this.methods;
    }

    public Member.Type getThisType() {
        return Member.Type.getObjectType(this.getThisClassName());
    }

    public Class getThisClass() {
        if (this.clazz == null) {
            this.clazz = this.getThisType().resolveClass();
        }
        return this.clazz;
    }

    public String getThisClassName() {
        return this.constantPool.getClassName(this.thisClassIndex);
    }

    public String getSuperClassName() {
        if (this.superClassIndex != 0) {
            return this.constantPool.getClassName(this.superClassIndex);
        }
        return "";
    }

    public JavaClassFile getSuperClassFile() throws IllegalClassFormatException, IOException, ClassNotFoundException {
        if (this.superClassIndex != 0) {
            return new JavaClassFile(this.getSuperClass());
        }
        return null;
    }

    public Member.Type getSuperType() {
        if (this.superClassIndex != 0) {
            return Member.Type.getObjectType(this.getSuperClassName());
        }
        return null;
    }

    public Class getSuperClass() {
        if (this.superClassIndex != 0) {
            return this.getSuperType().resolveClass();
        }
        return null;
    }

    public String[] getInterfaceNames() {
        String[] interfaceNames = new String[this.interfacesIndex.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaceNames[i] = this.constantPool.getClassName(this.interfacesIndex[i]);
        }
        return interfaceNames;
    }

    public Member.Type[] getInterfaceTypes() {
        String[] interfaceNames = this.getInterfaceNames();
        Member.Type[] types = new Member.Type[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            types[i] = Member.Type.getObjectType(interfaceNames[i]);
        }
        return types;
    }

    public Class[] getInterfaceClasses() {
        String[] interfaceNames = this.getInterfaceNames();
        Class[] types = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            types[i] = Member.Type.getObjectType(interfaceNames[i]).resolveClass();
        }
        return types;
    }

    public Member getMethod(String methodName, Class<?>[] parameterTypes, Class<?> returnType) {
        String methodDescriptor = Member.Type.getMethodDescriptor(parameterTypes, returnType);
        for (Member method : this.methods) {
            if (!methodName.equals(method.getName()) || !methodDescriptor.equals(method.getDescriptorName())) continue;
            return method;
        }
        return null;
    }

    public List<Attribute.LocalVariable[]> getLocalVariableTableList() {
        return Stream.of(this.getMethods()).map(Member::getLocalVariableTable).collect(Collectors.toList());
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlags);
    }

    public String toString() {
        return new StringJoiner(",", "{", "}").add("\"majorVersion\":\"" + (Object)((Object)this.majorVersion) + "\"").add("\"minorVersion\":" + this.minorVersion).add("\"accessFlags\":\"" + Modifier.toString(this.accessFlags) + "\"").add("\"thisClassIndex\":" + this.thisClassIndex).add("\"thisClassName\":\"" + this.getThisClassName() + "\"").add("\"superClassIndex\":" + this.superClassIndex).add("\"superClassName\":\"" + this.getSuperClassName() + "\"").add("\"interfaces\":" + JavaClassFile.toJsonArray(this.getInterfaceNames())).add("\"fields\":" + JavaClassFile.toJsonArray(this.getFields())).add("\"methods\":" + JavaClassFile.toJsonArray(this.getMethods())).add("\"attributes\":" + JavaClassFile.toJsonArray(this.attributes)).add("\"constantPool\":" + JavaClassFile.toJsonArray(this.constantPool.constants)).add("\"constantPoolDataLength\":" + Arrays.stream(this.constantPool.constants).filter(Objects::nonNull).mapToInt(ConstantPool.ConstantInfo::length).sum()).toString();
    }

    private static String toJsonArray(Object array) {
        if (array == null) {
            return "null";
        }
        if (array instanceof Object[]) {
            StringJoiner joiner = new StringJoiner(",", "[", "]");
            for (Object e : (Object[])array) {
                if (e instanceof Number) {
                    joiner.add(e.toString());
                    continue;
                }
                if (e == null) {
                    joiner.add("null");
                    continue;
                }
                if (e.getClass().isArray()) {
                    joiner.add(JavaClassFile.toJsonArray(array));
                    continue;
                }
                if (e instanceof CharSequence) {
                    joiner.add("\"" + e + "\"");
                    continue;
                }
                joiner.add(e.toString());
            }
            return joiner.toString();
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        return array.toString();
    }

    public static void main(String[] args) throws Exception {
        JavaClassFile classFile = new JavaClassFile(LinkedHashMap.class);
        String path = "D:\\java\\github\\spring-boot-protocol\\target\\classes\\com\\github\\netty\\protocol\\servlet";
        HashMap<String, JavaClassFile> javaClassMap = new HashMap<String, JavaClassFile>();
        File[] files = new File(path).listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!fileName.endsWith(".class")) continue;
                JavaClassFile javaClassFile = new JavaClassFile(path, fileName);
                List localVariables = Stream.of(javaClassFile.getMethods()).map(Member::getLocalVariableTable).collect(Collectors.toList());
                javaClassMap.put(fileName, javaClassFile);
            }
        }
        System.out.println("end..");
    }

    public static class Opcodes {
        public static final int T_BOOLEAN = 4;
        public static final int T_CHAR = 5;
        public static final int T_FLOAT = 6;
        public static final int T_DOUBLE = 7;
        public static final int T_BYTE = 8;
        public static final int T_SHORT = 9;
        public static final int T_INT = 10;
        public static final int T_LONG = 11;
        public static final int H_GETFIELD = 1;
        public static final int H_GETSTATIC = 2;
        public static final int H_PUTFIELD = 3;
        public static final int H_PUTSTATIC = 4;
        public static final int H_INVOKEVIRTUAL = 5;
        public static final int H_INVOKESTATIC = 6;
        public static final int H_INVOKESPECIAL = 7;
        public static final int H_NEWINVOKESPECIAL = 8;
        public static final int H_INVOKEINTERFACE = 9;
        public static final String[] METHOD_HANDLES_NAMES = new String[]{null, "REF_getField", "REF_getStatic", "REF_putField", "REF_putStatic", "REF_invokeVirtual", "REF_invokeStatic", "REF_invokeSpecial", "REF_newInvokeSpecial", "REF_invokeInterface"};
        public static final int F_NEW = -1;
        public static final int F_FULL = 0;
        public static final int F_APPEND = 1;
        public static final int F_CHOP = 2;
        public static final int F_SAME = 3;
        public static final int F_SAME1 = 4;
        public static final byte ITEM_TOP = 0;
        public static final byte ITEM_INTEGER = 1;
        public static final byte ITEM_FLOAT = 2;
        public static final byte ITEM_DOUBLE = 3;
        public static final byte ITEM_LONG = 4;
        public static final byte ITEM_NULL = 5;
        public static final byte ITEM_UNINITIALIZED_THIS = 6;
        public static final byte ITEM_OBJECT = 7;
        public static final byte ITEM_UNINITIALIZED = 8;
        public static final short NOP = 0;
        public static final short ACONST_NULL = 1;
        public static final short ICONST_M1 = 2;
        public static final short ICONST_0 = 3;
        public static final short ICONST_1 = 4;
        public static final short ICONST_2 = 5;
        public static final short ICONST_3 = 6;
        public static final short ICONST_4 = 7;
        public static final short ICONST_5 = 8;
        public static final short LCONST_0 = 9;
        public static final short LCONST_1 = 10;
        public static final short FCONST_0 = 11;
        public static final short FCONST_1 = 12;
        public static final short FCONST_2 = 13;
        public static final short DCONST_0 = 14;
        public static final short DCONST_1 = 15;
        public static final short BIPUSH = 16;
        public static final short SIPUSH = 17;
        public static final short LDC = 18;
        public static final short LDC_W = 19;
        public static final short LDC2_W = 20;
        public static final short ILOAD = 21;
        public static final short LLOAD = 22;
        public static final short FLOAD = 23;
        public static final short DLOAD = 24;
        public static final short ALOAD = 25;
        public static final short ILOAD_0 = 26;
        public static final short ILOAD_1 = 27;
        public static final short ILOAD_2 = 28;
        public static final short ILOAD_3 = 29;
        public static final short LLOAD_0 = 30;
        public static final short LLOAD_1 = 31;
        public static final short LLOAD_2 = 32;
        public static final short LLOAD_3 = 33;
        public static final short FLOAD_0 = 34;
        public static final short FLOAD_1 = 35;
        public static final short FLOAD_2 = 36;
        public static final short FLOAD_3 = 37;
        public static final short DLOAD_0 = 38;
        public static final short DLOAD_1 = 39;
        public static final short DLOAD_2 = 40;
        public static final short DLOAD_3 = 41;
        public static final short ALOAD_0 = 42;
        public static final short ALOAD_1 = 43;
        public static final short ALOAD_2 = 44;
        public static final short ALOAD_3 = 45;
        public static final short IALOAD = 46;
        public static final short LALOAD = 47;
        public static final short FALOAD = 48;
        public static final short DALOAD = 49;
        public static final short AALOAD = 50;
        public static final short BALOAD = 51;
        public static final short CALOAD = 52;
        public static final short SALOAD = 53;
        public static final short ISTORE = 54;
        public static final short LSTORE = 55;
        public static final short FSTORE = 56;
        public static final short DSTORE = 57;
        public static final short ASTORE = 58;
        public static final short ISTORE_0 = 59;
        public static final short ISTORE_1 = 60;
        public static final short ISTORE_2 = 61;
        public static final short ISTORE_3 = 62;
        public static final short LSTORE_0 = 63;
        public static final short LSTORE_1 = 64;
        public static final short LSTORE_2 = 65;
        public static final short LSTORE_3 = 66;
        public static final short FSTORE_0 = 67;
        public static final short FSTORE_1 = 68;
        public static final short FSTORE_2 = 69;
        public static final short FSTORE_3 = 70;
        public static final short DSTORE_0 = 71;
        public static final short DSTORE_1 = 72;
        public static final short DSTORE_2 = 73;
        public static final short DSTORE_3 = 74;
        public static final short ASTORE_0 = 75;
        public static final short ASTORE_1 = 76;
        public static final short ASTORE_2 = 77;
        public static final short ASTORE_3 = 78;
        public static final short IASTORE = 79;
        public static final short LASTORE = 80;
        public static final short FASTORE = 81;
        public static final short DASTORE = 82;
        public static final short AASTORE = 83;
        public static final short BASTORE = 84;
        public static final short CASTORE = 85;
        public static final short SASTORE = 86;
        public static final short POP = 87;
        public static final short POP2 = 88;
        public static final short DUP = 89;
        public static final short DUP_X1 = 90;
        public static final short DUP_X2 = 91;
        public static final short DUP2 = 92;
        public static final short DUP2_X1 = 93;
        public static final short DUP2_X2 = 94;
        public static final short SWAP = 95;
        public static final short IADD = 96;
        public static final short LADD = 97;
        public static final short FADD = 98;
        public static final short DADD = 99;
        public static final short ISUB = 100;
        public static final short LSUB = 101;
        public static final short FSUB = 102;
        public static final short DSUB = 103;
        public static final short IMUL = 104;
        public static final short LMUL = 105;
        public static final short FMUL = 106;
        public static final short DMUL = 107;
        public static final short IDIV = 108;
        public static final short LDIV = 109;
        public static final short FDIV = 110;
        public static final short DDIV = 111;
        public static final short IREM = 112;
        public static final short LREM = 113;
        public static final short FREM = 114;
        public static final short DREM = 115;
        public static final short INEG = 116;
        public static final short LNEG = 117;
        public static final short FNEG = 118;
        public static final short DNEG = 119;
        public static final short ISHL = 120;
        public static final short LSHL = 121;
        public static final short ISHR = 122;
        public static final short LSHR = 123;
        public static final short IUSHR = 124;
        public static final short LUSHR = 125;
        public static final short IAND = 126;
        public static final short LAND = 127;
        public static final short IOR = 128;
        public static final short LOR = 129;
        public static final short IXOR = 130;
        public static final short LXOR = 131;
        public static final short IINC = 132;
        public static final short I2L = 133;
        public static final short I2F = 134;
        public static final short I2D = 135;
        public static final short L2I = 136;
        public static final short L2F = 137;
        public static final short L2D = 138;
        public static final short F2I = 139;
        public static final short F2L = 140;
        public static final short F2D = 141;
        public static final short D2I = 142;
        public static final short D2L = 143;
        public static final short D2F = 144;
        public static final short I2B = 145;
        public static final short INT2BYTE = 145;
        public static final short I2C = 146;
        public static final short INT2CHAR = 146;
        public static final short I2S = 147;
        public static final short INT2SHORT = 147;
        public static final short LCMP = 148;
        public static final short FCMPL = 149;
        public static final short FCMPG = 150;
        public static final short DCMPL = 151;
        public static final short DCMPG = 152;
        public static final short IFEQ = 153;
        public static final short IFNE = 154;
        public static final short IFLT = 155;
        public static final short IFGE = 156;
        public static final short IFGT = 157;
        public static final short IFLE = 158;
        public static final short IF_ICMPEQ = 159;
        public static final short IF_ICMPNE = 160;
        public static final short IF_ICMPLT = 161;
        public static final short IF_ICMPGE = 162;
        public static final short IF_ICMPGT = 163;
        public static final short IF_ICMPLE = 164;
        public static final short IF_ACMPEQ = 165;
        public static final short IF_ACMPNE = 166;
        public static final short GOTO = 167;
        public static final short JSR = 168;
        public static final short RET = 169;
        public static final short TABLESWITCH = 170;
        public static final short LOOKUPSWITCH = 171;
        public static final short IRETURN = 172;
        public static final short LRETURN = 173;
        public static final short FRETURN = 174;
        public static final short DRETURN = 175;
        public static final short ARETURN = 176;
        public static final short RETURN = 177;
        public static final short GETSTATIC = 178;
        public static final short PUTSTATIC = 179;
        public static final short GETFIELD = 180;
        public static final short PUTFIELD = 181;
        public static final short INVOKEVIRTUAL = 182;
        public static final short INVOKESPECIAL = 183;
        public static final short INVOKENONVIRTUAL = 183;
        public static final short INVOKESTATIC = 184;
        public static final short INVOKEINTERFACE = 185;
        public static final short NEW = 187;
        public static final short NEWARRAY = 188;
        public static final short ANEWARRAY = 189;
        public static final short ARRAYLENGTH = 190;
        public static final short ATHROW = 191;
        public static final short CHECKCAST = 192;
        public static final short INSTANCEOF = 193;
        public static final short MONITORENTER = 194;
        public static final short MONITOREXIT = 195;
        public static final short WIDE = 196;
        public static final short MULTIANEWARRAY = 197;
        public static final short IFNULL = 198;
        public static final short IFNONNULL = 199;
        public static final short GOTO_W = 200;
        public static final short JSR_W = 201;
        public static final short BREAKPOINT = 202;
        public static final short LDC_QUICK = 203;
        public static final short LDC_W_QUICK = 204;
        public static final short LDC2_W_QUICK = 205;
        public static final short GETFIELD_QUICK = 206;
        public static final short PUTFIELD_QUICK = 207;
        public static final short GETFIELD2_QUICK = 208;
        public static final short PUTFIELD2_QUICK = 209;
        public static final short GETSTATIC_QUICK = 210;
        public static final short PUTSTATIC_QUICK = 211;
        public static final short GETSTATIC2_QUICK = 212;
        public static final short PUTSTATIC2_QUICK = 213;
        public static final short INVOKEVIRTUAL_QUICK = 214;
        public static final short INVOKENONVIRTUAL_QUICK = 215;
        public static final short INVOKESUPER_QUICK = 216;
        public static final short INVOKESTATIC_QUICK = 217;
        public static final short INVOKEINTERFACE_QUICK = 218;
        public static final short INVOKEVIRTUALOBJECT_QUICK = 219;
        public static final short NEW_QUICK = 221;
        public static final short ANEWARRAY_QUICK = 222;
        public static final short MULTIANEWARRAY_QUICK = 223;
        public static final short CHECKCAST_QUICK = 224;
        public static final short INSTANCEOF_QUICK = 225;
        public static final short INVOKEVIRTUAL_QUICK_W = 226;
        public static final short GETFIELD_QUICK_W = 227;
        public static final short PUTFIELD_QUICK_W = 228;
        public static final short IMPDEP1 = 254;
        public static final short IMPDEP2 = 255;
        public static final String ILLEGAL_OPCODE = "<illegal opcode>";
        public static final String ILLEGAL_TYPE = "<illegal type>";
        public static final String[] OPCODE_NAMES = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "<illegal opcode>", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w", "breakpoint", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "impdep1", "impdep2"};
        private short[] opcodes;

        public Opcodes(short[] opcodes) {
            this.opcodes = opcodes;
        }

        public short[] getOpcodes() {
            return this.opcodes;
        }

        public String getOpcodeName(int pc) {
            return OPCODE_NAMES[this.opcodes[pc]];
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(",", "[", "]");
            for (int i = 0; i < this.opcodes.length; ++i) {
                short opcode = this.opcodes[i];
                String name = OPCODE_NAMES[opcode];
                joiner.add("{\"index\":" + i + ",\"opcode\":" + opcode + ",\"name\":\"" + name + "\"}");
            }
            return joiner.toString();
        }
    }

    public static class ClassReader
    implements Closeable {
        private byte[] codes;
        private int index;
        private int length;
        private int markIndex;

        public ClassReader(String path, String fileName) throws FileNotFoundException, IOException {
            this(new FileInputStream(new File(path + File.separator + fileName)));
        }

        public ClassReader(Class clazz) throws IOException {
            this(clazz.getResourceAsStream(JavaClassFile.getClassFileName(clazz)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassReader(InputStream in) throws IOException {
            try {
                byte[] buffer = new byte[in.available()];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while (in.read(buffer) != -1) {
                    out.write(buffer);
                }
                this.codes = out.toByteArray();
                this.length = this.codes.length;
            }
            finally {
                in.close();
            }
        }

        public ClassReader(byte[] codes) {
            this.codes = codes;
            this.length = codes.length;
        }

        public void mark() {
            this.markIndex = this.index;
        }

        public void reset() {
            this.index = this.markIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public short readUint8() {
            return (short)(this.readInt8() & 0xFF);
        }

        public byte readInt8() {
            byte value = this.codes[this.index];
            ++this.index;
            return value;
        }

        public int readUint16() {
            return this.readInt16() & 0xFFFF;
        }

        public int readInt16() {
            short value = (short)(this.codes[this.index] << 8 | this.codes[this.index + 1] & 0xFF);
            this.index += 2;
            return value;
        }

        public int readUint32() {
            return this.readInt32() & 0xFFFF;
        }

        public int readInt32() {
            int value = (this.codes[this.index] & 0xFF) << 24 | (this.codes[this.index + 1] & 0xFF) << 16 | (this.codes[this.index + 2] & 0xFF) << 8 | this.codes[this.index + 3] & 0xFF;
            this.index += 4;
            return value;
        }

        public long readUint64() {
            long value = ((long)this.codes[this.index] & 0xFFL) << 56 | ((long)this.codes[this.index + 1] & 0xFFL) << 48 | ((long)this.codes[this.index + 2] & 0xFFL) << 40 | ((long)this.codes[this.index + 3] & 0xFFL) << 32 | ((long)this.codes[this.index + 4] & 0xFFL) << 24 | ((long)this.codes[this.index + 5] & 0xFFL) << 16 | ((long)this.codes[this.index + 6] & 0xFFL) << 8 | (long)this.codes[this.index + 7] & 0xFFL;
            this.index += 8;
            return value;
        }

        public int[] readUint16s() {
            int length = this.readUint16();
            int[] values = new int[length];
            for (int i = 0; i < length; ++i) {
                values[i] = this.readUint16();
            }
            return values;
        }

        public byte[] readInt8s(int length) {
            byte[] values = new byte[length];
            for (int i = 0; i < length; ++i) {
                values[i] = this.readInt8();
            }
            return values;
        }

        public short[] readUInt8s(int length) {
            short[] values = new short[length];
            for (int i = 0; i < length; ++i) {
                values[i] = this.readUint8();
            }
            return values;
        }

        public byte[] getBytes() {
            return this.codes;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.codes);
        }

        @Override
        public void close() {
            this.codes = null;
        }

        public String toString() {
            return new StringJoiner(",", "{", "}").add("\"file\":\"" + this.length + "b, " + this.length / 1024 + "kb\"").add("\"readIndex\":" + this.index).toString();
        }
    }

    public class Attribute
    extends LinkedHashMap<String, Object> {
        public Attribute(int attrNameIndex, int length, Attribute parent, ClassReader reader) {
            String attrName = JavaClassFile.this.constantPool.getUtf8(attrNameIndex);
            this.put("attrNameIndex", attrNameIndex);
            this.put("attrName", attrName);
            this.put("length", length);
            try {
                reader.mark();
                this.decode(attrName, length, parent, reader);
            }
            catch (Exception e) {
                this.put("decodeAttributeException", e.toString());
                reader.reset();
                byte[] decodeAttributeExceptionBytes = reader.readInt8s(length);
                this.put("decodeAttributeExceptionBytes", decodeAttributeExceptionBytes);
            }
        }

        public Opcodes getOpcodes() {
            return (Opcodes)this.get("opcodes");
        }

        private void decode(String attrName, int length, Attribute parent, ClassReader reader) {
            switch (attrName) {
                case "ConstantValue": {
                    int constantValueIndex = reader.readUint16();
                    this.put("constantValueIndex", constantValueIndex);
                    this.put("constantValue", JavaClassFile.this.constantPool.getConstantInfo(constantValueIndex));
                    break;
                }
                case "SourceFile": {
                    int sourceFileIndex = reader.readUint16();
                    this.put("sourceFileIndex", sourceFileIndex);
                    this.put("sourceFileName", JavaClassFile.this.constantPool.getUtf8(sourceFileIndex));
                    break;
                }
                case "Code": {
                    CodeException[] codeExceptions;
                    this.put("maxStack", reader.readUint16());
                    this.put("maxLocals", reader.readUint16());
                    int codeLength = reader.readInt32();
                    short[] opcodes = reader.readUInt8s(codeLength);
                    this.put("opcodes", new Opcodes(opcodes));
                    int codeExceptionsLength = reader.readUint16();
                    if (codeExceptionsLength == 0) {
                        codeExceptions = EMPTY_CODE_EXCEPTIONS;
                    } else {
                        codeExceptions = new CodeException[codeExceptionsLength];
                        for (int i = 0; i < codeExceptions.length; ++i) {
                            codeExceptions[i] = new CodeException(reader.readUint16(), reader.readUint16(), reader.readUint16(), reader.readUint16());
                        }
                    }
                    this.put("exceptionTable", codeExceptions);
                    this.put("attributes", JavaClassFile.this.readAttributes(reader, this));
                    break;
                }
                case "Exceptions": {
                    String[] exceptionNameTable;
                    int[] exceptionIndexTable;
                    int exceptionIndexTableLength = reader.readUint16();
                    if (exceptionIndexTableLength == 0) {
                        exceptionIndexTable = EMPTY_EXCEPTION_INDEX_TABLE;
                        exceptionNameTable = EMPTY_STRING;
                    } else {
                        int i;
                        exceptionIndexTable = new int[exceptionIndexTableLength];
                        for (i = 0; i < exceptionIndexTable.length; ++i) {
                            exceptionIndexTable[i] = reader.readUint16();
                        }
                        exceptionNameTable = new String[exceptionIndexTable.length];
                        for (i = 0; i < exceptionIndexTable.length; ++i) {
                            exceptionNameTable[i] = JavaClassFile.this.constantPool.getClassNameForToString(exceptionIndexTable[i]);
                        }
                    }
                    this.put("exceptionIndexTable", exceptionIndexTable);
                    this.put("exceptionNameTable", exceptionNameTable);
                    break;
                }
                case "LineNumberTable": {
                    LineNumber[] lineNumberTable;
                    int lineNumberTableLength = reader.readUint16();
                    if (lineNumberTableLength == 0) {
                        lineNumberTable = EMPTY_LINE_NUMBER_TABLE;
                    } else {
                        Opcodes opcodes = parent.getOpcodes();
                        lineNumberTable = new LineNumber[lineNumberTableLength];
                        for (int i = 0; i < lineNumberTable.length; ++i) {
                            lineNumberTable[i] = new LineNumber(reader.readUint16(), reader.readUint16(), opcodes);
                        }
                    }
                    this.put("lineNumberTable", lineNumberTable);
                    break;
                }
                case "LocalVariableTable": 
                case "LocalVariableTypeTable": {
                    int localVariableTableLength = reader.readUint16();
                    LocalVariable[] localVariableTable = localVariableTableLength == 0 ? EMPTY_LOCAL_VARIABLE_TABLE : new LocalVariable[localVariableTableLength];
                    for (int i = 0; i < localVariableTable.length; ++i) {
                        localVariableTable[i] = new LocalVariable(reader.readUint16(), reader.readUint16(), reader.readUint16(), reader.readUint16(), reader.readUint16());
                    }
                    this.put("localVariableTable", localVariableTable);
                    break;
                }
                case "InnerClasses": {
                    int numberOfClassesLength = reader.readUint16();
                    InnerClass[] numberOfClasses = numberOfClassesLength == 0 ? EMPTY_INNER_CLASSES : new InnerClass[numberOfClassesLength];
                    for (int i = 0; i < numberOfClasses.length; ++i) {
                        numberOfClasses[i] = new InnerClass(reader.readUint16(), reader.readUint16(), reader.readUint16(), reader.readUint16());
                    }
                    this.put("numberOfClasses", numberOfClasses);
                    break;
                }
                case "Synthetic": {
                    if (length <= 0) break;
                    byte[] syntheticBytes = reader.readInt8s(length);
                    this.put("bytes", syntheticBytes);
                    System.err.println("Synthetic attribute with length > 0");
                    break;
                }
                case "Deprecated": {
                    if (length <= 0) break;
                    byte[] deprecatedBytes = reader.readInt8s(length);
                    this.put("bytes", deprecatedBytes);
                    System.err.println("Deprecated attribute with length > 0");
                    break;
                }
                case "PMGClass": {
                    this.put("pmgClassIndex", reader.readUint16());
                    this.put("pmgIndex", reader.readUint16());
                    break;
                }
                case "Signature": {
                    int signatureIndex = reader.readUint16();
                    ConstantPool.ConstantUtf8Info info = (ConstantPool.ConstantUtf8Info)JavaClassFile.this.constantPool.getConstantInfo(signatureIndex);
                    String signature = info.value();
                    StringBuilder typeBuilder = new StringBuilder();
                    StringBuilder genericBuilder = new StringBuilder();
                    int count = 0;
                    boolean generic = false;
                    for (int i = 0; i < signature.length(); ++i) {
                        char c = signature.charAt(i);
                        if (c == '<') {
                            generic = true;
                            continue;
                        }
                        if (c == '>') {
                            generic = false;
                            continue;
                        }
                        if (c == ';') {
                            ++count;
                            genericBuilder.append(';');
                            continue;
                        }
                        if (generic) {
                            genericBuilder.append(c);
                            continue;
                        }
                        typeBuilder.append(c);
                    }
                    this.put("signatureIndex", signatureIndex);
                    this.put("signature", info);
                    if (count != 1) break;
                    this.put("signatureType", typeBuilder.toString());
                    this.put("signatureGeneric", genericBuilder.toString());
                    break;
                }
                case "StackMap": {
                    StackMapEntry[] stackMaps;
                    int stackMapsLength = reader.readUint16();
                    if (stackMapsLength == 0) {
                        stackMaps = EMPTY_STACK_MAP_ENTRY;
                    } else {
                        stackMaps = new StackMapEntry[stackMapsLength];
                        for (int i = 0; i < stackMaps.length; ++i) {
                            int byteCodeOffset = reader.readInt16();
                            int typesOfLocalsSize = reader.readUint16();
                            StackMapEntry stackMapEntry = new StackMapEntry(byteCodeOffset, typesOfLocalsSize);
                            for (int j = 0; j < stackMapEntry.typesOfLocals.length; ++j) {
                                ((StackMapEntry)stackMapEntry).typesOfLocals[j] = new StackMapType(reader);
                            }
                            stackMaps[i] = stackMapEntry;
                        }
                    }
                    this.put("map", stackMaps);
                    break;
                }
                case "StackMapTable": {
                    StackMapFrame[] entries;
                    int numberOfEntries = reader.readUint16();
                    if (numberOfEntries == 0) {
                        entries = EMPTY_STACK_MAP_FRAME;
                    } else {
                        entries = new StackMapFrame[numberOfEntries];
                        for (int i = 0; i < numberOfEntries; ++i) {
                            entries[i] = new StackMapFrame(reader);
                        }
                    }
                    this.put("entries", entries);
                    break;
                }
                case "RuntimeVisibleAnnotations": {
                    int numberOfAnnotations = reader.readUint16();
                    Annotation[] annotations = new Annotation[numberOfAnnotations];
                    for (int i = 0; i < numberOfAnnotations; ++i) {
                        annotations[i] = new Annotation(reader, i);
                    }
                    this.put("annotations", annotations);
                    break;
                }
                case "BootstrapMethods": {
                    int numberOfBootstrapMethods = reader.readUint16();
                    BootstrapMethod[] bootstrapMethods = numberOfBootstrapMethods == 0 ? EMPTY_BOOT_STRAP_METHOD : new BootstrapMethod[numberOfBootstrapMethods];
                    this.put("bootstrapMethods", bootstrapMethods);
                    for (int i = 0; i < bootstrapMethods.length; ++i) {
                        bootstrapMethods[i] = new BootstrapMethod(reader);
                    }
                    break;
                }
                case "MethodParameters": {
                    short parametersCount = reader.readUint8();
                    MethodParameter[] methodParameters = parametersCount == 0 ? EMPTY_METHOD_PARAMETER : new MethodParameter[parametersCount];
                    this.put("methodParameters", methodParameters);
                    for (int i = 0; i < methodParameters.length; ++i) {
                        methodParameters[i] = new MethodParameter(reader, i);
                    }
                    break;
                }
                default: {
                    byte[] unkownBytes = reader.readInt8s(length);
                    this.put("unkownBytes", unkownBytes);
                    break;
                }
            }
        }

        public int length() {
            return (Integer)this.get("length");
        }

        public String attrName() {
            return (String)this.get("attrName");
        }

        public boolean isAttrLocalVariableTable() {
            return "LocalVariableTable".equals(this.attrName());
        }

        public boolean isAttrLocalVariableTypeTable() {
            return "LocalVariableTypeTable".equals(this.attrName());
        }

        public boolean isAttrCode() {
            return "Code".equals(this.attrName());
        }

        public boolean isMethodParameters() {
            return "MethodParameters".equals(this.attrName());
        }

        public boolean isRuntimeVisibleAnnotations() {
            return "RuntimeVisibleAnnotations".equals(this.attrName());
        }

        public boolean isStackMapTable() {
            return "StackMapTable".equals(this.attrName());
        }

        public boolean isLineNumberTable() {
            return "LineNumberTable".equals(this.attrName());
        }

        public boolean isSignature() {
            return "Signature".equals(this.attrName());
        }

        public LocalVariable[] localVariableTable() {
            Object localVariableTable = this.get("localVariableTable");
            if (localVariableTable instanceof LocalVariable[]) {
                return (LocalVariable[])localVariableTable;
            }
            return null;
        }

        public MethodParameter[] methodParameters() {
            Object methodParameters = this.get("methodParameters");
            if (methodParameters instanceof MethodParameter[]) {
                return (MethodParameter[])methodParameters;
            }
            return null;
        }

        public Attribute[] attributes() {
            Object attributes = this.get("attributes");
            if (attributes instanceof Attribute[]) {
                return (Attribute[])attributes;
            }
            return null;
        }

        @Override
        public String toString() {
            StringJoiner joiner = new StringJoiner(",", "{", "}");
            for (Map.Entry e : this.entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                if (value instanceof Number) {
                    joiner.add("\"" + key + "\":" + value);
                    continue;
                }
                if (value == null) {
                    joiner.add("\"" + key + "\":null");
                    continue;
                }
                if (value.getClass().isArray()) {
                    joiner.add("\"" + key + "\":" + JavaClassFile.toJsonArray(value));
                    continue;
                }
                if (value instanceof CharSequence) {
                    joiner.add("\"" + key + "\":\"" + value + "\"");
                    continue;
                }
                joiner.add("\"" + key + "\":" + value);
            }
            return joiner.toString();
        }

        public class Annotation {
            private int index;
            private int typeIndex;
            private ElementValue[] elementValues;

            public Annotation(ClassReader reader, int index) {
                this.index = index;
                this.typeIndex = reader.readUint16();
                this.elementValues = new ElementValue[reader.readUint16()];
                for (int i = 0; i < this.elementValues.length; ++i) {
                    int valueIndex = reader.readUint16();
                    char tag = (char)reader.readInt8();
                    this.elementValues[i] = this.newElementValue(tag, reader, i);
                    this.elementValues[i].valueIndex = valueIndex;
                }
            }

            public ElementValue newElementValue(char tag, ClassReader reader, int index) {
                ElementValue newElementValue;
                switch (tag) {
                    case 'e': {
                        EnumElementValue elementValue = new EnumElementValue();
                        elementValue.typeNameIndex = reader.readUint16();
                        elementValue.constNameIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case '@': {
                        AnnotationElementValue elementValue = new AnnotationElementValue();
                        elementValue.annotationValue = new Annotation(reader, index);
                        newElementValue = elementValue;
                        break;
                    }
                    case 'c': {
                        ClassElementValue elementValue = new ClassElementValue();
                        elementValue.classInfoIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case '[': {
                        ArrayElementValue elementValue = new ArrayElementValue();
                        ElementValue[] elementValues = new ElementValue[reader.readUint16()];
                        for (int i = 0; i < elementValues.length; ++i) {
                            char elementTag = (char)reader.readInt8();
                            elementValues[i] = this.newElementValue(elementTag, reader, i);
                        }
                        ArrayElementValue.access$3002(elementValue, elementValues);
                        newElementValue = elementValue;
                        break;
                    }
                    case 'B': {
                        ByteElementValue elementValue = new ByteElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case 'C': {
                        CharElementValue elementValue = new CharElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case 'D': {
                        DoubleElementValue elementValue = new DoubleElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case 'F': {
                        FloatElementValue elementValue = new FloatElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case 'I': {
                        IntElementValue elementValue = new IntElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case 'J': {
                        LongElementValue elementValue = new LongElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case 'S': {
                        ShortElementValue elementValue = new ShortElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case 'Z': {
                        BooleanElementValue elementValue = new BooleanElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    case 's': {
                        StringElementValue elementValue = new StringElementValue();
                        elementValue.constValueIndex = reader.readUint16();
                        newElementValue = elementValue;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("a unkown annotation tag. tag = '" + tag + "'");
                    }
                }
                newElementValue.tag = tag;
                return newElementValue;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"typeIndex\":" + this.typeIndex).add("\"type\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.typeIndex) + "\"").add("\"elementValues\":" + JavaClassFile.toJsonArray(this.elementValues)).toString();
            }

            public class EnumElementValue
            extends ElementValue {
                private int constNameIndex;
                private int typeNameIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constNameIndex\":" + this.constNameIndex).add("\"constName\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.constNameIndex) + "\"").add("\"typeNameIndex\":" + this.typeNameIndex).add("\"typeName\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.typeNameIndex) + "\"");
                }
            }

            public class AnnotationElementValue
            extends ElementValue {
                private Annotation annotationValue;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"annotationValue\":" + this.annotationValue);
                }
            }

            public class ArrayElementValue
            extends ElementValue {
                private ElementValue[] arrayValue;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"arrayValue\":" + JavaClassFile.toJsonArray(this.arrayValue)).add("\"length\":" + this.arrayValue.length);
                }

                static /* synthetic */ ElementValue[] access$3002(ArrayElementValue x0, ElementValue[] x1) {
                    x0.arrayValue = x1;
                    return x1;
                }
            }

            public class BooleanElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":" + JavaClassFile.this.constantPool.getInteger(this.constValueIndex));
                }
            }

            public class ShortElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":" + JavaClassFile.this.constantPool.getInteger(this.constValueIndex));
                }
            }

            public class LongElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":" + JavaClassFile.this.constantPool.getLong(this.constValueIndex));
                }
            }

            public class IntElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":" + JavaClassFile.this.constantPool.getInteger(this.constValueIndex));
                }
            }

            public class FloatElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":" + JavaClassFile.this.constantPool.getFloat(this.constValueIndex));
                }
            }

            public class DoubleElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":" + JavaClassFile.this.constantPool.getDouble(this.constValueIndex));
                }
            }

            public class CharElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":" + JavaClassFile.this.constantPool.getInteger(this.constValueIndex));
                }
            }

            public class ByteElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":" + JavaClassFile.this.constantPool.getInteger(this.constValueIndex));
                }
            }

            public class StringElementValue
            extends ElementValue {
                private int constValueIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"constValueIndex\":" + this.constValueIndex).add("\"constValue\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.constValueIndex) + "\"");
                }
            }

            public class ClassElementValue
            extends ElementValue {
                private int classInfoIndex;

                @Override
                public void toStringAppend(StringJoiner joiner) {
                    joiner.add("\"classInfoIndex\":" + this.classInfoIndex).add("\"classInfo\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.classInfoIndex) + "\"");
                }
            }

            public class ElementValue {
                protected int valueIndex;
                protected char tag;

                public String toString() {
                    StringJoiner joiner = new StringJoiner(",", "{", "}").add("\"tag\":\"" + this.tag + "\"").add("\"type\":\"" + this.getClass().getSimpleName() + "\"");
                    if (this.valueIndex != 0) {
                        joiner.add("\"valueIndex\":" + this.valueIndex);
                        joiner.add("\"value\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.valueIndex) + "\"");
                    }
                    this.toStringAppend(joiner);
                    return joiner.toString();
                }

                public void toStringAppend(StringJoiner joiner) {
                }
            }
        }

        public class BootstrapMethod {
            private int bootstrapMethodRef;
            private int[] bootstrapArguments;

            public BootstrapMethod(ClassReader reader) {
                this.bootstrapMethodRef = reader.readUint16();
                this.bootstrapArguments = new int[reader.readUint16()];
                for (int i = 0; i < this.bootstrapArguments.length; ++i) {
                    this.bootstrapArguments[i] = reader.readUint16();
                }
            }

            public String toString() {
                Object[] infos = new ConstantPool.ConstantInfo[this.bootstrapArguments.length];
                for (int i = 0; i < this.bootstrapArguments.length; ++i) {
                    int bootstrapArgument = this.bootstrapArguments[i];
                    infos[i] = JavaClassFile.this.constantPool.getConstantInfo(bootstrapArgument);
                }
                StringJoiner joiner = new StringJoiner(",", "{", "}").add("\"bootstrapMethod\":" + JavaClassFile.this.constantPool.getConstantMethodHandleInfo(this.bootstrapMethodRef)).add("\"bootstrapArguments\":" + Arrays.toString(infos));
                return joiner.toString();
            }
        }

        public class MethodParameter {
            private int nameIndex;
            private int accessFlags;
            private int index;
            public static final int FINAL = 16;
            public static final int SYNTHETIC = 4096;
            public static final int MANDATED = 32768;

            public MethodParameter(ClassReader reader, int index) {
                this.index = index;
                this.nameIndex = reader.readUint16();
                this.accessFlags = reader.readUint16();
            }

            public String getName() {
                String realName = this.getRealName();
                if (realName == null || realName.isEmpty()) {
                    return "arg" + this.index;
                }
                return realName;
            }

            public String getRealName() {
                return JavaClassFile.this.constantPool.getUtf8ForToString(this.nameIndex);
            }

            public int getAccessFlags() {
                return this.accessFlags;
            }

            public int getIndex() {
                return this.index;
            }

            public String toString() {
                StringJoiner joiner = new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"name\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.nameIndex) + "\"").add("\"nameIndex\":" + this.nameIndex).add("\"accessFlags\":" + this.accessFlags).add("\"accFinal\":" + ((this.accessFlags & 0x10) != 0)).add("\"accSynthetic\":" + ((this.accessFlags & 0x1000) != 0)).add("\"accMandated\":" + ((this.accessFlags & 0x8000) != 0));
                return joiner.toString();
            }
        }

        public class StackMapFrame {
            private short frameType;
            private String frameTypeName;
            private Integer offsetDelta;
            private StackMapType[] stacks;
            private StackMapType[] locals;

            public StackMapFrame(ClassReader reader) {
                block4: {
                    int i;
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block3: {
                                            this.frameType = reader.readUint8();
                                            if (this.frameType < 0 || this.frameType > 63) break block3;
                                            this.frameTypeName = "same";
                                            break block4;
                                        }
                                        if (this.frameType < 64 || this.frameType > 127) break block5;
                                        this.frameTypeName = "same_locals_1_stack_item_frame";
                                        this.stacks = new StackMapType[]{new StackMapType(reader)};
                                        break block4;
                                    }
                                    if (this.frameType != 247) break block6;
                                    this.frameTypeName = "same_locals_1_stack_item_frame_extended";
                                    this.offsetDelta = reader.readUint16();
                                    this.stacks = new StackMapType[]{new StackMapType(reader)};
                                    break block4;
                                }
                                if (this.frameType < 248 || this.frameType > 250) break block7;
                                this.frameTypeName = "chop_frame";
                                this.offsetDelta = reader.readUint16();
                                break block4;
                            }
                            if (this.frameType != 251) break block8;
                            this.frameTypeName = "same_frame_extended";
                            this.offsetDelta = reader.readUint16();
                            break block4;
                        }
                        if (this.frameType < 252 || this.frameType > 254) break block9;
                        this.frameTypeName = "append_frame";
                        this.offsetDelta = reader.readUint16();
                        this.locals = new StackMapType[this.frameType - 251];
                        for (int i2 = 0; i2 < this.locals.length; ++i2) {
                            this.locals[i2] = new StackMapType(reader);
                        }
                        break block4;
                    }
                    if (this.frameType != 255) break block4;
                    this.frameTypeName = "full_frame";
                    this.offsetDelta = reader.readUint16();
                    this.locals = new StackMapType[reader.readUint16()];
                    for (i = 0; i < this.locals.length; ++i) {
                        this.locals[i] = new StackMapType(reader);
                    }
                    this.stacks = new StackMapType[reader.readUint16()];
                    for (i = 0; i < this.stacks.length; ++i) {
                        this.stacks[i] = new StackMapType(reader);
                    }
                }
            }

            public short getFrameType() {
                return this.frameType;
            }

            public String getFrameTypeName() {
                return this.frameTypeName;
            }

            public Integer getOffsetDelta() {
                return this.offsetDelta;
            }

            public StackMapType[] getStacks() {
                return this.stacks;
            }

            public StackMapType[] getLocals() {
                return this.locals;
            }

            public String toString() {
                StringJoiner joiner = new StringJoiner(",", "{", "}").add("\"frameType\":" + this.frameType).add("\"frameTypeName\":\"" + this.frameTypeName + "\"");
                if (this.offsetDelta != null) {
                    joiner.add("\"offsetDelta\":" + this.offsetDelta);
                }
                if (this.stacks != null) {
                    joiner.add("\"stacks\":" + JavaClassFile.toJsonArray(this.stacks));
                }
                if (this.locals != null) {
                    joiner.add("\"locals\":" + JavaClassFile.toJsonArray(this.locals));
                }
                return joiner.toString();
            }
        }

        public class StackMapType {
            private byte type;
            private int objectVariableIndex = -1;
            private int offset = -1;

            public StackMapType(ClassReader reader) {
                this.type = reader.readInt8();
                if (this.type == 7) {
                    this.objectVariableIndex = reader.readInt16();
                } else if (this.type == 8) {
                    this.offset = reader.readInt16();
                }
            }

            public String getTypeName() {
                switch (this.type) {
                    case 0: {
                        return "top";
                    }
                    case 1: {
                        return "integer";
                    }
                    case 2: {
                        return "float";
                    }
                    case 3: {
                        return "double";
                    }
                    case 4: {
                        return "long";
                    }
                    case 5: {
                        return "null";
                    }
                    case 6: {
                        return "uninitializedThis";
                    }
                    case 7: {
                        return "object";
                    }
                    case 8: {
                        return "uninitialized";
                    }
                }
                return "unkown";
            }

            public String toString() {
                StringJoiner joiner = new StringJoiner(",", "{", "}").add("\"type\":" + this.type).add("\"typeName\":\"" + this.getTypeName() + "\"");
                if (this.type == 7) {
                    joiner.add("\"objectVariableIndex\":" + this.objectVariableIndex);
                    joiner.add("\"objectVariable\":\"" + JavaClassFile.this.constantPool.getClassNameForToString(this.objectVariableIndex) + "\"");
                }
                if (this.type == 8) {
                    joiner.add("\"offset\":" + this.offset);
                }
                return joiner.toString();
            }
        }

        public class StackMapEntry {
            private int byteCodeOffset;
            private StackMapType[] typesOfLocals;

            public StackMapEntry(int byteCodeOffset, int typesOfLocalsSize) {
                this.byteCodeOffset = byteCodeOffset;
                this.typesOfLocals = typesOfLocalsSize == 0 ? EMPTY_STACK_MAP_TYPE : new StackMapType[typesOfLocalsSize];
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"byteCodeOffset\":" + this.byteCodeOffset).add("\"typesOfLocals\":\"" + JavaClassFile.toJsonArray(this.typesOfLocals)).toString();
            }
        }

        public class InnerClass {
            private int innerClassIndex;
            private int outerClassIndex;
            private int innerNameIndex;
            private int innerAccessFlags;

            public InnerClass(int innerClassIndex, int outerClassIndex, int innerNameIndex, int innerAccessFlags) {
                this.innerClassIndex = innerClassIndex;
                this.outerClassIndex = outerClassIndex;
                this.innerNameIndex = innerNameIndex;
                this.innerAccessFlags = innerAccessFlags;
            }

            public String innerName() {
                if (this.innerNameIndex == 0) {
                    return null;
                }
                return JavaClassFile.this.constantPool.getUtf8(this.innerNameIndex);
            }

            public String innerClassName() {
                return JavaClassFile.this.constantPool.getClassName(this.innerClassIndex);
            }

            public String outerClassName() {
                if (this.outerClassIndex == 0) {
                    return null;
                }
                return JavaClassFile.this.constantPool.getClassName(this.outerClassIndex);
            }

            public String toString() {
                String innerName = JavaClassFile.this.constantPool.getUtf8ForToString(this.innerNameIndex);
                String toStringInnerName = innerName == null ? "null" : "\"" + innerName + "\"";
                String outerClassName = JavaClassFile.this.constantPool.getClassNameForToString(this.outerClassIndex);
                String toStringOuterClassName = outerClassName == null ? "null" : "\"" + outerClassName + "\"";
                return new StringJoiner(",", "{", "}").add("\"innerAccessFlags\":\"" + Modifier.toString(this.innerAccessFlags) + "\"").add("\"innerName\":" + toStringInnerName).add("\"innerClassName\":\"" + this.innerClassName() + "\"").add("\"outerClassName\":" + toStringOuterClassName).add("\"innerNameIndex\":" + this.innerNameIndex).add("\"innerClassIndex\":" + this.innerClassIndex).add("\"outerClassIndex\":" + this.outerClassIndex).toString();
            }
        }

        public class LocalVariable {
            private int startPc;
            private int length;
            private int nameIndex;
            private int signatureIndex;
            private int index;

            public LocalVariable(int startPc, int length, int nameIndex, int signatureIndex, int index) {
                this.startPc = startPc;
                this.length = length;
                this.nameIndex = nameIndex;
                this.signatureIndex = signatureIndex;
                this.index = index;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"name\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.nameIndex) + "\"").add("\"signatureName\":\"" + JavaClassFile.this.constantPool.getUtf8ForToString(this.signatureIndex) + "\"").add("\"startPc\":" + this.startPc).add("\"length\":" + this.length).add("\"nameIndex\":" + this.nameIndex).add("\"signatureIndex\":" + this.signatureIndex).toString();
            }

            public int startPc() {
                return this.startPc;
            }

            public int nameIndex() {
                return this.nameIndex;
            }

            public int signatureIndex() {
                return this.signatureIndex;
            }

            public int index() {
                return this.index;
            }

            public int length() {
                return this.length;
            }

            public String name() {
                return JavaClassFile.this.constantPool.getUtf8(this.nameIndex);
            }

            public String signatureName() {
                return JavaClassFile.this.constantPool.getUtf8(this.signatureIndex);
            }
        }

        public class LineNumber {
            private int startPc;
            private int lineNumber;
            private Opcodes opcodes;

            public LineNumber(int startPc, int lineNumber, Opcodes opcodes) {
                this.startPc = startPc;
                this.lineNumber = lineNumber;
                this.opcodes = opcodes;
            }

            public Opcodes getOpcodes() {
                return this.opcodes;
            }

            public int getLineNumber() {
                return this.lineNumber;
            }

            public int getStartPc() {
                return this.startPc;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"startPcName\":\"" + this.opcodes.getOpcodeName(this.startPc) + "\"").add("\"startPc\":" + this.startPc).add("\"lineNumber\":" + this.lineNumber).toString();
            }
        }

        public class CodeException {
            private int startPc;
            private int endPc;
            private int handlerPc;
            private int catchType;

            public CodeException(int startPc, int endPc, int handlerPc, int catchType) {
                this.startPc = startPc;
                this.endPc = endPc;
                this.handlerPc = handlerPc;
                this.catchType = catchType;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"startPc\":" + this.startPc).add("\"endPc\":" + this.endPc).add("\"handlerPc\":" + this.handlerPc).add("\"catchType\":" + this.catchType).toString();
            }
        }
    }

    public static class Member {
        private boolean method;
        private int accessFlags;
        private int nameIndex;
        private int descriptorIndex;
        private String name;
        private String descriptorName;
        private Attribute[] attributes;
        private Class<?>[] javaArgumentTypes;
        private Type[] argumentTypes;
        private String[] parameterNames;
        private Attribute.MethodParameter[] methodParameters;
        private Attribute.LocalVariable[] localVariables;
        private Attribute.LocalVariable[] localVariablesType;
        private JavaClassFile classFile;

        public int getAccessFlags() {
            return this.accessFlags;
        }

        public int[] getArgumentLocalVariableTableIndex() {
            Type[] argumentTypes = this.getMethodArgumentTypes();
            int[] lvtIndex = new int[argumentTypes.length];
            int nextIndex = Modifier.isStatic(this.accessFlags) ? 0 : 1;
            for (int i = 0; i < argumentTypes.length; ++i) {
                lvtIndex[i] = nextIndex++;
                if (argumentTypes[i] != Type.LONG_TYPE && argumentTypes[i] != Type.DOUBLE_TYPE) continue;
                nextIndex += 2;
            }
            return lvtIndex;
        }

        public boolean isDefaultMethod() {
            return this.method && (this.accessFlags & 0x409) == 1 && this.classFile.isInterface();
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.accessFlags);
        }

        public boolean isField() {
            return !this.method;
        }

        public boolean isMethod() {
            return this.method;
        }

        public boolean isConstructor() {
            return this.method && "<init>".equals(this.name);
        }

        public boolean isStaticConstructor() {
            return this.method && this.isStatic() && "<clinit>".equals(this.name);
        }

        public Type getFieldType() {
            if (this.isField()) {
                return Type.getType(this.getDescriptorName());
            }
            return null;
        }

        public Type getMethodReturnType() {
            if (this.isMethod()) {
                return Type.getReturnType(this.getDescriptorName());
            }
            return null;
        }

        public String getSignature() {
            for (Attribute attribute : this.attributes) {
                if (!attribute.isSignature()) continue;
                ConstantPool.ConstantUtf8Info utf8Info = (ConstantPool.ConstantUtf8Info)attribute.get("signature");
                return utf8Info.value();
            }
            return null;
        }

        public Type getSignatureType() {
            for (Attribute attribute : this.attributes) {
                if (!attribute.isSignature()) continue;
                String signatureType = (String)attribute.get("signatureType");
                return signatureType != null ? Type.getType(signatureType) : null;
            }
            return null;
        }

        public Class getSignatureClass() {
            Type signatureType = this.getSignatureType();
            return signatureType == null ? null : signatureType.resolveClass();
        }

        public Type getSignatureGenericType() {
            for (Attribute attribute : this.attributes) {
                if (!attribute.isSignature()) continue;
                String signatureGeneric = (String)attribute.get("signatureGeneric");
                return signatureGeneric != null ? Type.getType(signatureGeneric) : null;
            }
            return null;
        }

        public Class getSignatureGenericClass() {
            Type genericType = this.getSignatureGenericType();
            return genericType == null ? null : genericType.resolveClass();
        }

        public Class getMethodReturnClass() {
            if (this.isMethod()) {
                return this.getMethodReturnType().resolveClass();
            }
            return null;
        }

        public Class getFieldClass() {
            if (this.isField()) {
                return this.getFieldType().resolveClass();
            }
            return null;
        }

        public Type[] getMethodArgumentTypes() {
            if (this.argumentTypes == null && this.isMethod()) {
                this.argumentTypes = Type.getArgumentTypes(this.getDescriptorName());
            }
            return this.argumentTypes;
        }

        public Class<?>[] getMethodArgumentClasses() {
            if (this.javaArgumentTypes == null) {
                Type[] argumentTypes = this.getMethodArgumentTypes();
                Class[] javaArgumentTypes = new Class[argumentTypes.length];
                for (int i = 0; i < argumentTypes.length; ++i) {
                    javaArgumentTypes[i] = argumentTypes[i].resolveClass();
                }
                this.javaArgumentTypes = javaArgumentTypes;
            }
            return this.javaArgumentTypes;
        }

        public java.lang.reflect.Member toJavaMember() {
            Class target = this.classFile.getThisClass();
            if (this.isMethod()) {
                Class<?>[] argumentTypes = this.getMethodArgumentClasses();
                try {
                    if (this.isConstructor()) {
                        return target.getDeclaredConstructor(argumentTypes);
                    }
                    if (this.isStaticConstructor()) {
                        return new StaticConstructor(this);
                    }
                    if (this.isStatic()) {
                        return target.getMethod(this.name, argumentTypes);
                    }
                    return target.getDeclaredMethod(this.name, argumentTypes);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("toJavaMember error ", e);
                }
            }
            try {
                return target.getDeclaredField(this.name);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("toJavaMember error ", e);
            }
        }

        public String[] getParameterNames() {
            if (this.parameterNames == null) {
                String[] parameterNames;
                int[] lvtIndices = this.getArgumentLocalVariableTableIndex();
                if (lvtIndices.length == 0) {
                    parameterNames = EMPTY_STRING;
                } else {
                    Attribute.LocalVariable[] localVariableTable = this.getLocalVariableTable();
                    if (localVariableTable == null || localVariableTable.length == 0) {
                        parameterNames = EMPTY_STRING;
                    } else {
                        parameterNames = new String[lvtIndices.length];
                        for (int i = 0; i < localVariableTable.length; ++i) {
                            for (int j = 0; j < lvtIndices.length; ++j) {
                                if (i != lvtIndices[j]) continue;
                                parameterNames[j] = localVariableTable[i].name();
                            }
                        }
                    }
                }
                this.parameterNames = parameterNames;
            }
            return this.parameterNames;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptorName() {
            return this.descriptorName;
        }

        public Attribute.LocalVariable[] getLocalVariableTable() {
            if (this.localVariables == null) {
                this.localVariables = this.findLocalVariable();
            }
            return this.localVariables;
        }

        public Attribute.LocalVariable[] getLocalVariableTypeTable() {
            if (this.localVariablesType == null) {
                this.localVariablesType = this.findLocalVariableTypeTable();
            }
            return this.localVariablesType;
        }

        public Attribute.MethodParameter[] getMethodParameters() {
            if (this.methodParameters == null) {
                this.methodParameters = this.findMethodParameters();
            }
            return this.methodParameters;
        }

        public Opcodes getOpcodes() {
            if (this.attributes != null) {
                for (Attribute attributeInfo : this.attributes) {
                    if (!attributeInfo.isAttrCode()) continue;
                    return attributeInfo.getOpcodes();
                }
            }
            return null;
        }

        public Attribute.CodeException[] getExceptionTable() {
            if (this.attributes != null) {
                for (Attribute attributeInfo : this.attributes) {
                    if (!attributeInfo.isAttrCode()) continue;
                    return (Attribute.CodeException[])attributeInfo.get("exceptionTable");
                }
            }
            return null;
        }

        public Integer getMaxStack() {
            if (this.attributes != null) {
                for (Attribute attributeInfo : this.attributes) {
                    if (!attributeInfo.isAttrCode()) continue;
                    return (Integer)attributeInfo.get("maxStack");
                }
            }
            return null;
        }

        public Integer getMaxLocals() {
            if (this.attributes != null) {
                for (Attribute attributeInfo : this.attributes) {
                    if (!attributeInfo.isAttrCode()) continue;
                    return (Integer)attributeInfo.get("maxLocals");
                }
            }
            return null;
        }

        public Attribute.LineNumber[] getLineNumberTable() {
            if (this.attributes != null) {
                for (Attribute attributeInfo : this.attributes) {
                    Attribute[] codeAttributes;
                    if (!attributeInfo.isAttrCode()) continue;
                    for (Attribute codeAttributeInfo : codeAttributes = attributeInfo.attributes()) {
                        if (!codeAttributeInfo.isLineNumberTable()) continue;
                        return (Attribute.LineNumber[])codeAttributeInfo.get("lineNumberTable");
                    }
                }
            }
            return null;
        }

        public Attribute.StackMapFrame[] getStackMapTable() {
            if (this.attributes != null) {
                for (Attribute attributeInfo : this.attributes) {
                    Attribute[] codeAttributes;
                    if (!attributeInfo.isAttrCode()) continue;
                    for (Attribute codeAttributeInfo : codeAttributes = attributeInfo.attributes()) {
                        if (!codeAttributeInfo.isStackMapTable()) continue;
                        return (Attribute.StackMapFrame[])codeAttributeInfo.get("entries");
                    }
                }
            }
            return null;
        }

        public Attribute.Annotation[] getRuntimeVisibleAnnotations() {
            if (this.attributes != null) {
                for (Attribute attributeInfo : this.attributes) {
                    if (!attributeInfo.isRuntimeVisibleAnnotations()) continue;
                    return (Attribute.Annotation[])attributeInfo.get("annotations");
                }
            }
            return null;
        }

        private Attribute.LocalVariable[] findLocalVariable() {
            if (this.attributes == null) {
                return EMPTY_LOCAL_VARIABLE_TABLE;
            }
            for (Attribute attributeInfo : this.attributes) {
                Attribute[] codeAttributes;
                if (!attributeInfo.isAttrCode()) continue;
                for (Attribute codeAttributeInfo : codeAttributes = attributeInfo.attributes()) {
                    if (!codeAttributeInfo.isAttrLocalVariableTable()) continue;
                    return codeAttributeInfo.localVariableTable();
                }
                return EMPTY_LOCAL_VARIABLE_TABLE;
            }
            return EMPTY_LOCAL_VARIABLE_TABLE;
        }

        private Attribute.LocalVariable[] findLocalVariableTypeTable() {
            if (this.attributes == null) {
                return EMPTY_LOCAL_VARIABLE_TABLE;
            }
            for (Attribute attributeInfo : this.attributes) {
                Attribute[] codeAttributes;
                if (!attributeInfo.isAttrCode()) continue;
                for (Attribute codeAttributeInfo : codeAttributes = attributeInfo.attributes()) {
                    if (!codeAttributeInfo.isAttrLocalVariableTypeTable()) continue;
                    return codeAttributeInfo.localVariableTable();
                }
                return EMPTY_LOCAL_VARIABLE_TABLE;
            }
            return EMPTY_LOCAL_VARIABLE_TABLE;
        }

        private Attribute.MethodParameter[] findMethodParameters() {
            if (this.attributes == null) {
                return EMPTY_METHOD_PARAMETER;
            }
            for (Attribute attributeInfo : this.attributes) {
                if (!attributeInfo.isMethodParameters()) continue;
                return attributeInfo.methodParameters();
            }
            return EMPTY_METHOD_PARAMETER;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(",", "{", "}");
            joiner.add("\"accessFlags\":\"" + Modifier.toString(this.accessFlags) + "\"");
            joiner.add("\"name\":\"" + this.getName() + "\"");
            joiner.add("\"getDescriptorName\":\"" + this.getDescriptorName() + "\"");
            joiner.add("\"attributes\":" + JavaClassFile.toJsonArray(this.attributes));
            return joiner.toString();
        }

        static /* synthetic */ Attribute[] access$702(Member x0, Attribute[] x1) {
            x0.attributes = x1;
            return x1;
        }

        public static final class Type {
            public static final int VOID = 0;
            public static final int BOOLEAN = 1;
            public static final int CHAR = 2;
            public static final int BYTE = 3;
            public static final int SHORT = 4;
            public static final int INT = 5;
            public static final int FLOAT = 6;
            public static final int LONG = 7;
            public static final int DOUBLE = 8;
            public static final int ARRAY = 9;
            public static final int OBJECT = 10;
            public static final int METHOD = 11;
            private static final int INTERNAL = 12;
            private static final String PRIMITIVE_DESCRIPTORS = "VZCBSIFJD";
            public static final Type VOID_TYPE = new Type(0, "VZCBSIFJD", 0, 1);
            public static final Type BOOLEAN_TYPE = new Type(1, "VZCBSIFJD", 1, 2);
            public static final Type CHAR_TYPE = new Type(2, "VZCBSIFJD", 2, 3);
            public static final Type BYTE_TYPE = new Type(3, "VZCBSIFJD", 3, 4);
            public static final Type SHORT_TYPE = new Type(4, "VZCBSIFJD", 4, 5);
            public static final Type INT_TYPE = new Type(5, "VZCBSIFJD", 5, 6);
            public static final Type FLOAT_TYPE = new Type(6, "VZCBSIFJD", 6, 7);
            public static final Type LONG_TYPE = new Type(7, "VZCBSIFJD", 7, 8);
            public static final Type DOUBLE_TYPE = new Type(8, "VZCBSIFJD", 8, 9);
            private static final String ARRAY_SUFFIX = "[]";
            private static final String INTERNAL_ARRAY_PREFIX = "[";
            private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
            private static final char PACKAGE_SEPARATOR = '.';
            private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP = new IdentityHashMap(8);
            private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP = new HashMap(32);
            private static final Map<String, Class<?>> COMMON_CLASS_CACHE = new HashMap(64);
            private final int sort;
            private final String valueBuffer;
            private final int valueBegin;
            private final int valueEnd;

            private static Class<?> resolvePrimitiveClassName(String name) {
                Class<?> result = null;
                if (name != null && name.length() <= 8) {
                    result = PRIMITIVE_TYPE_NAME_MAP.get(name);
                }
                return result;
            }

            public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
                Class<?> clazz = Type.resolvePrimitiveClassName(name);
                if (clazz == null) {
                    clazz = COMMON_CLASS_CACHE.get(name);
                }
                if (clazz != null) {
                    return clazz;
                }
                if (name.endsWith(ARRAY_SUFFIX)) {
                    String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
                    Class<?> elementClass = Type.forName(elementClassName, classLoader);
                    return Array.newInstance(elementClass, 0).getClass();
                }
                if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
                    String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
                    Class<?> elementClass = Type.forName(elementName, classLoader);
                    return Array.newInstance(elementClass, 0).getClass();
                }
                if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
                    String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
                    Class<?> elementClass = Type.forName(elementName, classLoader);
                    return Array.newInstance(elementClass, 0).getClass();
                }
                ClassLoader clToUse = classLoader;
                if (clToUse == null) {
                    clToUse = Type.getDefaultClassLoader();
                }
                try {
                    return Class.forName(name, false, clToUse);
                }
                catch (ClassNotFoundException ex) {
                    int lastDotIndex = name.lastIndexOf(46);
                    if (lastDotIndex != -1) {
                        String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                        try {
                            return Class.forName(innerClassName, false, clToUse);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    throw ex;
                }
            }

            public static ClassLoader getDefaultClassLoader() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (cl == null && (cl = Type.class.getClassLoader()) == null) {
                    try {
                        cl = ClassLoader.getSystemClassLoader();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return cl;
            }

            private static void registerCommonClasses(Class<?> ... commonClasses) {
                for (Class<?> clazz : commonClasses) {
                    COMMON_CLASS_CACHE.put(clazz.getName(), clazz);
                }
            }

            private Type(int sort, String valueBuffer, int valueBegin, int valueEnd) {
                this.sort = sort;
                this.valueBuffer = valueBuffer;
                this.valueBegin = valueBegin;
                this.valueEnd = valueEnd;
            }

            public static Type getType(String typeDescriptor) {
                return Type.getTypeInternal(typeDescriptor, 0, typeDescriptor.length());
            }

            public static Type getType(Class<?> clazz) {
                if (clazz.isPrimitive()) {
                    if (clazz == Integer.TYPE) {
                        return INT_TYPE;
                    }
                    if (clazz == Void.TYPE) {
                        return VOID_TYPE;
                    }
                    if (clazz == Boolean.TYPE) {
                        return BOOLEAN_TYPE;
                    }
                    if (clazz == Byte.TYPE) {
                        return BYTE_TYPE;
                    }
                    if (clazz == Character.TYPE) {
                        return CHAR_TYPE;
                    }
                    if (clazz == Short.TYPE) {
                        return SHORT_TYPE;
                    }
                    if (clazz == Double.TYPE) {
                        return DOUBLE_TYPE;
                    }
                    if (clazz == Float.TYPE) {
                        return FLOAT_TYPE;
                    }
                    if (clazz == Long.TYPE) {
                        return LONG_TYPE;
                    }
                    throw new AssertionError();
                }
                return Type.getType(Type.getDescriptor(clazz));
            }

            public static Type getType(Constructor<?> constructor) {
                return Type.getType(Type.getConstructorDescriptor(constructor));
            }

            public static Type getType(Method method) {
                return Type.getType(Type.getMethodDescriptor(method));
            }

            public Type getElementType() {
                int numDimensions = this.getDimensions();
                return Type.getTypeInternal(this.valueBuffer, this.valueBegin + numDimensions, this.valueEnd);
            }

            public static Type getObjectType(String internalName) {
                return new Type(internalName.charAt(0) == '[' ? 9 : 12, internalName, 0, internalName.length());
            }

            public static Type getMethodType(String methodDescriptor) {
                return new Type(11, methodDescriptor, 0, methodDescriptor.length());
            }

            public static Type getMethodType(Type returnType, Type ... argumentTypes) {
                return Type.getType(Type.getMethodDescriptor(returnType, argumentTypes));
            }

            public Type[] getArgumentTypes() {
                return Type.getArgumentTypes(this.getDescriptor());
            }

            public static Type[] getArgumentTypes(String methodDescriptor) {
                int numArgumentTypes = 0;
                int currentOffset = 1;
                while (methodDescriptor != null && methodDescriptor.charAt(currentOffset) != ')') {
                    while (methodDescriptor.charAt(currentOffset) == '[') {
                        ++currentOffset;
                    }
                    if (methodDescriptor.charAt(currentOffset++) == 'L') {
                        currentOffset = methodDescriptor.indexOf(59, currentOffset) + 1;
                    }
                    ++numArgumentTypes;
                }
                Type[] argumentTypes = new Type[numArgumentTypes];
                currentOffset = 1;
                int currentArgumentTypeIndex = 0;
                while (methodDescriptor != null && methodDescriptor.charAt(currentOffset) != ')') {
                    int currentArgumentTypeOffset = currentOffset;
                    while (methodDescriptor.charAt(currentOffset) == '[') {
                        ++currentOffset;
                    }
                    if (methodDescriptor.charAt(currentOffset++) == 'L') {
                        currentOffset = methodDescriptor.indexOf(59, currentOffset) + 1;
                    }
                    argumentTypes[currentArgumentTypeIndex++] = Type.getTypeInternal(methodDescriptor, currentArgumentTypeOffset, currentOffset);
                }
                return argumentTypes;
            }

            public static Type[] getArgumentTypes(Method method) {
                Class<?>[] classes = method.getParameterTypes();
                Type[] types = new Type[classes.length];
                for (int i = classes.length - 1; i >= 0; --i) {
                    types[i] = Type.getType(classes[i]);
                }
                return types;
            }

            public Type getReturnType() {
                return Type.getReturnType(this.getDescriptor());
            }

            public static Type getReturnType(String methodDescriptor) {
                int currentOffset = 1;
                while (methodDescriptor.charAt(currentOffset) != ')') {
                    while (methodDescriptor.charAt(currentOffset) == '[') {
                        ++currentOffset;
                    }
                    if (methodDescriptor.charAt(currentOffset++) != 'L') continue;
                    currentOffset = methodDescriptor.indexOf(59, currentOffset) + 1;
                }
                return Type.getTypeInternal(methodDescriptor, currentOffset + 1, methodDescriptor.length());
            }

            public static Type getReturnType(Method method) {
                return Type.getType(method.getReturnType());
            }

            private static Type getTypeInternal(String descriptorBuffer, int descriptorBegin, int descriptorEnd) {
                switch (descriptorBuffer.charAt(descriptorBegin)) {
                    case 'V': {
                        return VOID_TYPE;
                    }
                    case 'Z': {
                        return BOOLEAN_TYPE;
                    }
                    case 'C': {
                        return CHAR_TYPE;
                    }
                    case 'B': {
                        return BYTE_TYPE;
                    }
                    case 'S': {
                        return SHORT_TYPE;
                    }
                    case 'I': {
                        return INT_TYPE;
                    }
                    case 'F': {
                        return FLOAT_TYPE;
                    }
                    case 'J': {
                        return LONG_TYPE;
                    }
                    case 'D': {
                        return DOUBLE_TYPE;
                    }
                    case '[': {
                        return new Type(9, descriptorBuffer, descriptorBegin, descriptorEnd);
                    }
                    case 'L': {
                        return new Type(10, descriptorBuffer, descriptorBegin + 1, descriptorEnd - 1);
                    }
                    case '(': {
                        return new Type(11, descriptorBuffer, descriptorBegin, descriptorEnd);
                    }
                }
                throw new IllegalArgumentException();
            }

            public Class resolveClass() {
                String className = this.getClassName();
                try {
                    return Type.forName(className, null);
                }
                catch (IllegalAccessError err) {
                    throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
                }
                catch (LinkageError err) {
                    throw new IllegalArgumentException("Unresolvable class definition for class [" + className + "]", err);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalArgumentException("Could not find class [" + className + "]", ex);
                }
            }

            public String getClassName() {
                switch (this.sort) {
                    case 0: {
                        return "void";
                    }
                    case 1: {
                        return "boolean";
                    }
                    case 2: {
                        return "char";
                    }
                    case 3: {
                        return "byte";
                    }
                    case 4: {
                        return "short";
                    }
                    case 5: {
                        return "int";
                    }
                    case 6: {
                        return "float";
                    }
                    case 7: {
                        return "long";
                    }
                    case 8: {
                        return "double";
                    }
                    case 9: {
                        StringBuilder stringBuilder = new StringBuilder(this.getElementType().getClassName());
                        for (int i = this.getDimensions(); i > 0; --i) {
                            stringBuilder.append(ARRAY_SUFFIX);
                        }
                        return stringBuilder.toString();
                    }
                    case 10: 
                    case 12: {
                        return this.valueBuffer.substring(this.valueBegin, this.valueEnd).replace('/', '.');
                    }
                }
                throw new AssertionError();
            }

            public String getInternalName() {
                return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
            }

            public static String getInternalName(Class<?> clazz) {
                return clazz.getName().replace('.', '/');
            }

            public String getDescriptor() {
                if (this.sort == 10) {
                    return this.valueBuffer.substring(this.valueBegin - 1, this.valueEnd + 1);
                }
                if (this.sort == 12) {
                    return new StringBuilder().append('L').append(this.valueBuffer, this.valueBegin, this.valueEnd).append(';').toString();
                }
                return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
            }

            public static String getDescriptor(Class<?> clazz) {
                StringBuilder stringBuilder = new StringBuilder();
                Type.appendDescriptor(clazz, stringBuilder);
                return stringBuilder.toString();
            }

            public static String getConstructorDescriptor(Constructor<?> constructor) {
                Class<?>[] parameters;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                for (Class<?> parameter : parameters = constructor.getParameterTypes()) {
                    Type.appendDescriptor(parameter, stringBuilder);
                }
                return stringBuilder.append(")V").toString();
            }

            public static String getMethodDescriptor(Type returnType, Type ... argumentTypes) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                for (Type argumentType : argumentTypes) {
                    argumentType.appendDescriptor(stringBuilder);
                }
                stringBuilder.append(')');
                returnType.appendDescriptor(stringBuilder);
                return stringBuilder.toString();
            }

            public static String getMethodDescriptor(Method method) {
                return Type.getMethodDescriptor(method.getParameterTypes(), method.getReturnType());
            }

            public static String getMethodDescriptor(Class<?>[] parameterTypes, Class<?> returnType) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                for (Class<?> parameter : parameterTypes) {
                    Type.appendDescriptor(parameter, stringBuilder);
                }
                stringBuilder.append(')');
                Type.appendDescriptor(returnType, stringBuilder);
                return stringBuilder.toString();
            }

            private void appendDescriptor(StringBuilder stringBuilder) {
                if (this.sort == 10) {
                    stringBuilder.append(this.valueBuffer, this.valueBegin - 1, this.valueEnd + 1);
                } else if (this.sort == 12) {
                    stringBuilder.append('L').append(this.valueBuffer, this.valueBegin, this.valueEnd).append(';');
                } else {
                    stringBuilder.append(this.valueBuffer, this.valueBegin, this.valueEnd);
                }
            }

            private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
                Class<?> currentClass = clazz;
                while (currentClass.isArray()) {
                    stringBuilder.append('[');
                    currentClass = currentClass.getComponentType();
                }
                if (currentClass.isPrimitive()) {
                    int descriptor;
                    if (currentClass == Integer.TYPE) {
                        descriptor = 73;
                    } else if (currentClass == Void.TYPE) {
                        descriptor = 86;
                    } else if (currentClass == Boolean.TYPE) {
                        descriptor = 90;
                    } else if (currentClass == Byte.TYPE) {
                        descriptor = 66;
                    } else if (currentClass == Character.TYPE) {
                        descriptor = 67;
                    } else if (currentClass == Short.TYPE) {
                        descriptor = 83;
                    } else if (currentClass == Double.TYPE) {
                        descriptor = 68;
                    } else if (currentClass == Float.TYPE) {
                        descriptor = 70;
                    } else if (currentClass == Long.TYPE) {
                        descriptor = 74;
                    } else {
                        throw new AssertionError();
                    }
                    stringBuilder.append((char)descriptor);
                } else {
                    stringBuilder.append('L');
                    String name = currentClass.getName();
                    int nameLength = name.length();
                    for (int i = 0; i < nameLength; ++i) {
                        char car = name.charAt(i);
                        stringBuilder.append(car == '.' ? (char)'/' : (char)car);
                    }
                    stringBuilder.append(';');
                }
            }

            public int getSort() {
                return this.sort == 12 ? 10 : this.sort;
            }

            public int getDimensions() {
                int numDimensions = 1;
                while (this.valueBuffer.charAt(this.valueBegin + numDimensions) == '[') {
                    ++numDimensions;
                }
                return numDimensions;
            }

            public int getSize() {
                switch (this.sort) {
                    case 0: {
                        return 0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 12: {
                        return 1;
                    }
                    case 7: 
                    case 8: {
                        return 2;
                    }
                }
                throw new AssertionError();
            }

            public int getArgumentsAndReturnSizes() {
                return Type.getArgumentsAndReturnSizes(this.getDescriptor());
            }

            public static int getArgumentsAndReturnSizes(String methodDescriptor) {
                int argumentsSize = 1;
                int currentOffset = 1;
                char currentChar = methodDescriptor.charAt(currentOffset);
                while (currentChar != ')') {
                    if (currentChar == 'J' || currentChar == 'D') {
                        ++currentOffset;
                        argumentsSize += 2;
                    } else {
                        while (methodDescriptor.charAt(currentOffset) == '[') {
                            ++currentOffset;
                        }
                        if (methodDescriptor.charAt(currentOffset++) == 'L') {
                            currentOffset = methodDescriptor.indexOf(59, currentOffset) + 1;
                        }
                        ++argumentsSize;
                    }
                    currentChar = methodDescriptor.charAt(currentOffset);
                }
                currentChar = methodDescriptor.charAt(currentOffset + 1);
                if (currentChar == 'V') {
                    return argumentsSize << 2;
                }
                int returnSize = currentChar == 'J' || currentChar == 'D' ? 2 : 1;
                return argumentsSize << 2 | returnSize;
            }

            public int getOpcode(int opcode) {
                if (opcode == 46 || opcode == 79) {
                    switch (this.sort) {
                        case 1: 
                        case 3: {
                            return opcode + 5;
                        }
                        case 2: {
                            return opcode + 6;
                        }
                        case 4: {
                            return opcode + 7;
                        }
                        case 5: {
                            return opcode;
                        }
                        case 6: {
                            return opcode + 2;
                        }
                        case 7: {
                            return opcode + 1;
                        }
                        case 8: {
                            return opcode + 3;
                        }
                        case 9: 
                        case 10: 
                        case 12: {
                            return opcode + 4;
                        }
                        case 0: 
                        case 11: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    throw new AssertionError();
                }
                switch (this.sort) {
                    case 0: {
                        if (opcode != 172) {
                            throw new UnsupportedOperationException();
                        }
                        return 177;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return opcode;
                    }
                    case 6: {
                        return opcode + 2;
                    }
                    case 7: {
                        return opcode + 1;
                    }
                    case 8: {
                        return opcode + 3;
                    }
                    case 9: 
                    case 10: 
                    case 12: {
                        if (opcode != 21 && opcode != 54 && opcode != 172) {
                            throw new UnsupportedOperationException();
                        }
                        return opcode + 4;
                    }
                    case 11: {
                        throw new UnsupportedOperationException();
                    }
                }
                throw new AssertionError();
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof Type)) {
                    return false;
                }
                Type other = (Type)object;
                if ((this.sort == 12 ? 10 : this.sort) != (other.sort == 12 ? 10 : other.sort)) {
                    return false;
                }
                int end = this.valueEnd;
                int begin = this.valueBegin;
                int otherEnd = other.valueEnd;
                int otherBegin = other.valueBegin;
                if (end - begin != otherEnd - otherBegin) {
                    return false;
                }
                int i = begin;
                int j = otherBegin;
                while (i < end) {
                    if (this.valueBuffer.charAt(i) != other.valueBuffer.charAt(j)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
                return true;
            }

            public int hashCode() {
                int hashCode = 13 * (this.sort == 12 ? 10 : this.sort);
                if (this.sort >= 9) {
                    int end = this.valueEnd;
                    for (int i = this.valueBegin; i < end; ++i) {
                        hashCode = 17 * (hashCode + this.valueBuffer.charAt(i));
                    }
                }
                return hashCode;
            }

            public String toString() {
                return this.getDescriptor();
            }

            static {
                PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
                PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
                PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
                PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
                PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
                PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
                PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
                PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
                for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVE_WRAPPER_TYPE_MAP.entrySet()) {
                    Type.registerCommonClasses(entry.getKey());
                }
                HashSet primitiveTypes = new HashSet(32);
                primitiveTypes.addAll(PRIMITIVE_WRAPPER_TYPE_MAP.values());
                Collections.addAll(primitiveTypes, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
                primitiveTypes.add(Void.TYPE);
                for (Class clazz : primitiveTypes) {
                    PRIMITIVE_TYPE_NAME_MAP.put(clazz.getName(), clazz);
                }
                Type.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
                Type.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
                Type.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
                Type.registerCommonClasses(Enum.class, Iterable.class, Iterator.class, Enumeration.class, Collection.class, List.class, Set.class, Map.class, Map.Entry.class, Optional.class);
                Class[] classArray = new Class[]{Serializable.class, Externalizable.class, Closeable.class, AutoCloseable.class, Cloneable.class, Comparable.class};
                Type.registerCommonClasses(classArray);
            }
        }
    }

    public static class StaticConstructor
    implements java.lang.reflect.Member {
        private static final int ACCESS_MODIFIERS = 7;
        private final Member member;

        public StaticConstructor(Member member) {
            this.member = member;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.member.classFile.getThisClass();
        }

        @Override
        public String getName() {
            return this.member.name;
        }

        @Override
        public int getModifiers() {
            return this.member.accessFlags;
        }

        @Override
        public boolean isSynthetic() {
            return (this.member.accessFlags & 0x1000) != 0;
        }

        public String toString() {
            try {
                StringBuilder sb = new StringBuilder();
                boolean isDefault = this.member.isDefaultMethod();
                int mod = this.getModifiers();
                if (mod != 0 && !isDefault) {
                    sb.append(Modifier.toString(mod)).append(' ');
                } else {
                    int access_mod = mod & 7;
                    if (access_mod != 0) {
                        sb.append(Modifier.toString(access_mod)).append(' ');
                    }
                    if (isDefault) {
                        sb.append("default ");
                    }
                    if ((mod &= 0xFFFFFFF8) != 0) {
                        sb.append(Modifier.toString(mod)).append(' ');
                    }
                }
                sb.append(this.getDeclaringClass().getTypeName());
                sb.append('(');
                Member.Type[] types = this.member.getMethodArgumentTypes();
                for (int j = 0; j < types.length; ++j) {
                    sb.append(types[j].getClassName());
                    if (j >= types.length - 1) continue;
                    sb.append(",");
                }
                sb.append(')');
                return sb.toString();
            }
            catch (Exception e) {
                return "<" + e + ">";
            }
        }
    }

    public static class ConstantPool {
        private ConstantInfo[] constants;

        public ConstantPool(int constantPoolCount, ClassReader reader) {
            this.constants = new ConstantInfo[constantPoolCount];
            for (int i = 1; i < constantPoolCount; ++i) {
                ConstantInfo constantInfo;
                this.constants[i] = constantInfo = this.readConstantInfo(i, reader);
                if (!(constantInfo instanceof ConstantDoubleInfo) && !(constantInfo instanceof ConstantLongInfo)) continue;
                ++i;
            }
        }

        private ConstantInfo readConstantInfo(int index, ClassReader reader) {
            ConstantInfo constantInfo;
            short tag = reader.readUint8();
            switch (tag) {
                case 3: {
                    constantInfo = new ConstantIntegerInfo(index, reader);
                    break;
                }
                case 4: {
                    constantInfo = new ConstantFloatInfo(index, reader);
                    break;
                }
                case 5: {
                    constantInfo = new ConstantLongInfo(index, reader);
                    break;
                }
                case 6: {
                    constantInfo = new ConstantDoubleInfo(index, reader);
                    break;
                }
                case 1: {
                    constantInfo = new ConstantUtf8Info(index, reader);
                    break;
                }
                case 8: {
                    constantInfo = new ConstantStringInfo(index, reader);
                    break;
                }
                case 7: {
                    constantInfo = new ConstantClassInfo(index, reader);
                    break;
                }
                case 9: {
                    constantInfo = new ConstantFieldRefInfo(index, new ConstantMemberRefInfo(reader));
                    break;
                }
                case 10: {
                    constantInfo = new ConstantMethodRefInfo(index, new ConstantMemberRefInfo(reader));
                    break;
                }
                case 11: {
                    constantInfo = new ConstantInterfaceMethodRefInfo(index, new ConstantMemberRefInfo(reader));
                    break;
                }
                case 12: {
                    constantInfo = new ConstantNameAndTypeInfo(index, reader);
                    break;
                }
                case 15: {
                    constantInfo = new ConstantMethodHandleInfo(index, reader);
                    break;
                }
                case 18: {
                    constantInfo = new ConstantInvokeDynamicInfo(index, reader);
                    break;
                }
                case 16: {
                    constantInfo = new ConstantMethodTypeInfo(index, reader);
                    break;
                }
                default: {
                    System.out.println("Unkown constant pool tag: " + tag);
                    constantInfo = new ConstantUnkownInfo(index, tag);
                }
            }
            return constantInfo;
        }

        public ConstantMethodHandleInfo getConstantMethodHandleInfo(int index) {
            return (ConstantMethodHandleInfo)this.getConstantInfo(index);
        }

        public ConstantInfo getConstantInfo(int index) {
            return this.constants[index];
        }

        public ConstantNameAndTypeInfo getNameAndType(int index) {
            return (ConstantNameAndTypeInfo)this.getConstantInfo(index);
        }

        public String getClassName(int index) {
            return this.getUtf8(((ConstantClassInfo)this.getConstantInfo(index)).nameIndex);
        }

        public String getUtf8(int stringIndex) {
            if (stringIndex == 0) {
                return null;
            }
            return ((ConstantUtf8Info)this.getConstantInfo(stringIndex)).value();
        }

        public String getClassNameForToString(int index) {
            if (index == 0) {
                return null;
            }
            return this.getUtf8ForToString(((ConstantClassInfo)this.getConstantInfo(index)).nameIndex);
        }

        public String getUtf8ForToString(int stringIndex) {
            if (stringIndex == 0) {
                return null;
            }
            return ((ConstantUtf8Info)this.getConstantInfo(stringIndex)).valueToString();
        }

        public int getInteger(int index) {
            return ((ConstantIntegerInfo)this.getConstantInfo(index)).value();
        }

        public double getDouble(int index) {
            return ((ConstantDoubleInfo)this.getConstantInfo(index)).value();
        }

        public int getFloat(int index) {
            return ((ConstantFloatInfo)this.getConstantInfo(index)).value();
        }

        public long getLong(int index) {
            return ((ConstantLongInfo)this.getConstantInfo(index)).value();
        }

        public class ConstantUnkownInfo
        implements ConstantInfo {
            private int tag;
            private int index;

            public ConstantUnkownInfo(int index, int tag) {
                this.index = index;
                this.tag = tag;
            }

            @Override
            public String name() {
                return "Unkown";
            }

            @Override
            public int length() {
                return 0;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"tag\":" + this.tag).toString();
            }
        }

        public class ConstantInvokeDynamicInfo
        implements ConstantInfo {
            private int bootstrapMethodAttrIndex;
            private int nameAndTypeIndex;
            private int index;

            public ConstantInvokeDynamicInfo(int index, ClassReader reader) {
                this.index = index;
                this.bootstrapMethodAttrIndex = reader.readUint16();
                this.nameAndTypeIndex = reader.readUint16();
            }

            public ConstantNameAndTypeInfo nameAndType() {
                return ConstantPool.this.getNameAndType(this.nameAndTypeIndex);
            }

            @Override
            public String name() {
                return "InvokeDynamic";
            }

            @Override
            public int length() {
                return 8;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"bootstrapMethodAttrIndex\":" + this.bootstrapMethodAttrIndex).add("\"nameAndTypeIndex\":" + this.nameAndTypeIndex).add("\"nameAndType\":" + this.nameAndType()).toString();
            }
        }

        public class ConstantMethodHandleInfo
        implements ConstantInfo {
            private int referenceKind;
            private int referenceIndex;
            private int index;

            public ConstantMethodHandleInfo(int index, ClassReader reader) {
                this.index = index;
                this.referenceKind = reader.readUint8();
                this.referenceIndex = reader.readUint16();
            }

            @Override
            public String name() {
                return "MethodHandle";
            }

            @Override
            public int length() {
                return 6;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"referenceKind\":\"" + Opcodes.METHOD_HANDLES_NAMES[this.referenceKind] + "\"").add("\"referenceIndex\":" + this.referenceIndex).add("\"reference\":" + ConstantPool.this.getConstantInfo(this.referenceIndex)).toString();
            }
        }

        public class ConstantMethodTypeInfo
        implements ConstantInfo {
            private int descriptorIndex;
            private int index;

            public ConstantMethodTypeInfo(int index, ClassReader reader) {
                this.index = index;
                this.descriptorIndex = reader.readUint16();
            }

            @Override
            public String name() {
                return "MethodType";
            }

            @Override
            public int length() {
                return 2;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"descriptorIndex\":" + this.descriptorIndex).add("\"descriptor\":\"" + ConstantPool.this.getUtf8ForToString(this.descriptorIndex) + "\"").toString();
            }
        }

        public class ConstantNameAndTypeInfo
        implements ConstantInfo {
            private int nameIndex;
            private int descriptorIndex;
            private int index;

            public ConstantNameAndTypeInfo(int index, ClassReader reader) {
                this.nameIndex = reader.readUint16();
                this.index = index;
                this.descriptorIndex = reader.readUint16();
            }

            @Override
            public String name() {
                return "NameAndType";
            }

            @Override
            public int length() {
                return 4;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"name\":\"" + ConstantPool.this.getUtf8ForToString(this.nameIndex) + "\"").add("\"descriptor\":\"" + ConstantPool.this.getUtf8ForToString(this.descriptorIndex) + "\"").add("\"nameIndex\":" + this.nameIndex).add("\"descriptorIndex\":" + this.descriptorIndex).toString();
            }
        }

        public class ConstantInterfaceMethodRefInfo
        implements ConstantInfo {
            private ConstantMemberRefInfo memberRefInfo;
            private int index;

            public ConstantInterfaceMethodRefInfo(int index, ConstantMemberRefInfo memberRefInfo) {
                this.index = index;
                this.memberRefInfo = memberRefInfo;
            }

            @Override
            public String name() {
                return "InterfaceMethodRef";
            }

            @Override
            public int length() {
                return 0;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"memberRef\":" + this.memberRefInfo).toString();
            }
        }

        public class ConstantMethodRefInfo
        implements ConstantInfo {
            private ConstantMemberRefInfo memberRefInfo;
            private int index;

            public ConstantMethodRefInfo(int index, ConstantMemberRefInfo memberRefInfo) {
                this.index = index;
                this.memberRefInfo = memberRefInfo;
            }

            @Override
            public String name() {
                return "MethodRef";
            }

            @Override
            public int length() {
                return 0;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"memberRef\":" + this.memberRefInfo).toString();
            }
        }

        public class ConstantMemberRefInfo
        implements ConstantInfo {
            private int classIndex;
            private int nameAndTypeIndex;

            public ConstantMemberRefInfo(ClassReader reader) {
                this.classIndex = reader.readUint16();
                this.nameAndTypeIndex = reader.readUint16();
            }

            public String className() {
                return ConstantPool.this.getClassName(this.classIndex);
            }

            public ConstantNameAndTypeInfo nameAndType() {
                return ConstantPool.this.getNameAndType(this.nameAndTypeIndex);
            }

            @Override
            public String name() {
                return "MemberRef";
            }

            @Override
            public int length() {
                return 4;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"classIndex\":" + this.classIndex).add("\"nameAndTypeIndex\":" + this.nameAndTypeIndex).add("\"class\":\"" + this.className() + "\"").add("\"nameAndType\":" + this.nameAndType()).toString();
            }
        }

        public class ConstantFieldRefInfo
        implements ConstantInfo {
            private ConstantMemberRefInfo memberRefInfo;
            private int index;

            public ConstantFieldRefInfo(int index, ConstantMemberRefInfo memberRefInfo) {
                this.index = index;
                this.memberRefInfo = memberRefInfo;
            }

            public ConstantMemberRefInfo value() {
                return this.memberRefInfo;
            }

            @Override
            public String name() {
                return "FieldRef";
            }

            @Override
            public int length() {
                return 0;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"memberRef\":" + this.memberRefInfo).toString();
            }
        }

        public class ConstantClassInfo
        implements ConstantInfo {
            private int nameIndex;
            private int index;

            public ConstantClassInfo(int index, ClassReader reader) {
                this.index = index;
                this.nameIndex = reader.readUint16();
            }

            public String value() {
                return ConstantPool.this.getUtf8(this.nameIndex);
            }

            @Override
            public String name() {
                return "Class";
            }

            @Override
            public int length() {
                return 2;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"nameIndex\":" + this.nameIndex).add("\"name\":\"" + ConstantPool.this.getUtf8ForToString(this.nameIndex) + "\"").toString();
            }
        }

        public class ConstantUtf8Info
        implements ConstantInfo {
            private String value;
            private String valueToString;
            private int length;
            private int index;

            public ConstantUtf8Info(int index, ClassReader reader) {
                this.index = index;
                this.length = reader.readUint16();
                byte[] bytes = reader.readInt8s(this.length);
                this.value = new String(bytes, Charset.forName("UTF-8"));
            }

            public String value() {
                return this.value;
            }

            private String valueToString() {
                if (this.valueToString == null) {
                    this.valueToString = this.value.replace("\"", "\\\"").replace(":", "\\:").replace("{", "\\{").replace("}", "\\}").replace("[", "\\[").replace("]", "\\]");
                }
                return this.valueToString;
            }

            @Override
            public String name() {
                return "UTF8";
            }

            @Override
            public int length() {
                return this.length;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"value\":\"" + this.valueToString() + "\"").toString();
            }
        }

        public class ConstantLongInfo
        implements ConstantInfo {
            private byte[] value;
            private int index;

            public ConstantLongInfo(int index, ClassReader reader) {
                this.index = index;
                this.value = reader.readInt8s(8);
            }

            public long value() {
                long data = ((long)this.value[0] & 0xFFL) << 56 | ((long)this.value[1] & 0xFFL) << 48 | ((long)this.value[2] & 0xFFL) << 40 | ((long)this.value[3] & 0xFFL) << 32 | ((long)this.value[4] & 0xFFL) << 24 | ((long)this.value[5] & 0xFFL) << 16 | ((long)this.value[6] & 0xFFL) << 8 | (long)this.value[7] & 0xFFL;
                return data;
            }

            @Override
            public String name() {
                return "Long";
            }

            @Override
            public int length() {
                return 8;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"value\":" + JavaClassFile.toJsonArray(this.value)).toString();
            }
        }

        public class ConstantFloatInfo
        implements ConstantInfo {
            private int value;
            private int index;

            public ConstantFloatInfo(int index, ClassReader reader) {
                this.index = index;
                this.value = reader.readInt32();
            }

            public int value() {
                return this.value;
            }

            @Override
            public String name() {
                return "Float";
            }

            @Override
            public int length() {
                return 4;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"value\":" + this.value).toString();
            }
        }

        public class ConstantIntegerInfo
        implements ConstantInfo {
            private int value;
            private int index;

            public ConstantIntegerInfo(int index, ClassReader reader) {
                this.index = index;
                this.value = reader.readInt32();
            }

            @Override
            public String name() {
                return "Integer";
            }

            public int value() {
                return this.value;
            }

            @Override
            public int length() {
                return 4;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"value\":" + this.value).toString();
            }
        }

        public class ConstantDoubleInfo
        implements ConstantInfo {
            private byte[] value;
            private int index;

            public ConstantDoubleInfo(int index, ClassReader reader) {
                this.index = index;
                this.value = reader.readInt8s(8);
            }

            public double value() {
                long data = ((long)this.value[0] & 0xFFL) << 56 | ((long)this.value[1] & 0xFFL) << 48 | ((long)this.value[2] & 0xFFL) << 40 | ((long)this.value[3] & 0xFFL) << 32 | ((long)this.value[4] & 0xFFL) << 24 | ((long)this.value[5] & 0xFFL) << 16 | ((long)this.value[6] & 0xFFL) << 8 | (long)this.value[7] & 0xFFL;
                return Double.longBitsToDouble(data);
            }

            @Override
            public String name() {
                return "Double";
            }

            @Override
            public int length() {
                return 8;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"length\":" + this.length()).add("\"value\":" + JavaClassFile.toJsonArray(this.value)).toString();
            }
        }

        public class ConstantStringInfo
        implements ConstantInfo {
            private int stringIndex;
            private int index;

            public ConstantStringInfo(int index, ClassReader reader) {
                this.index = index;
                this.stringIndex = reader.readUint16();
            }

            public String value() {
                return ConstantPool.this.getUtf8(this.stringIndex);
            }

            @Override
            public String name() {
                return "String";
            }

            @Override
            public int length() {
                return 2;
            }

            public String toString() {
                return new StringJoiner(",", "{", "}").add("\"index\":" + this.index).add("\"constant\":\"" + this.name() + "\"").add("\"stringIndex\":" + this.stringIndex).add("\"value\":\"" + ConstantPool.this.getUtf8ForToString(this.stringIndex) + "\"").toString();
            }
        }

        public static interface ConstantInfo {
            public static final int CONSTANT_UTF8 = 1;
            public static final int CONSTANT_INTEGER = 3;
            public static final int CONSTANT_FLOAT = 4;
            public static final int CONSTANT_LONG = 5;
            public static final int CONSTANT_DOUBLE = 6;
            public static final int CONSTANT_CLASS = 7;
            public static final int CONSTANT_STRING = 8;
            public static final int CONSTANT_FIELD_REF = 9;
            public static final int CONSTANT_METHOD_REF = 10;
            public static final int CONSTANT_INTERFACE_METHOD_REF = 11;
            public static final int CONSTANT_NAME_AND_TYPE = 12;
            public static final int CONSTANT_METHOD_HANDLE = 15;
            public static final int CONSTANT_METHOD_TYPE = 16;
            public static final int CONSTANT_INVOKE_DYNAMIC = 18;

            public String name();

            public int length();
        }
    }

    public static enum JavaVersion {
        V1_1(196653L),
        V1_2(46L),
        V1_3(47L),
        V1_4(48L),
        V1_5(49L),
        V1_6(50L),
        V1_7(51L),
        V1_8(52L),
        V9(53L),
        V10(54L),
        V11(55L),
        V12(56L);

        private long major;

        private JavaVersion(long major) {
            this.major = major;
        }

        public long getMajor() {
            return this.major;
        }

        public static JavaVersion valueOf(long major) {
            for (JavaVersion version : JavaVersion.values()) {
                if (version.major != major) continue;
                return version;
            }
            throw new IllegalArgumentException("bad major");
        }
    }
}

