/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.core.util.MessageMetrics;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class MessageMetricsChannelHandler
extends AbstractChannelHandler<Object, Object> {
    private static final AttributeKey<MessageMetrics> ATTR_KEY_METRICS = AttributeKey.valueOf((String)(MessageMetrics.class + "#MessageMetrics"));
    private AtomicLong readMessages = new AtomicLong();
    private AtomicLong writeMessages = new AtomicLong();

    public MessageMetricsChannelHandler() {
        super(false);
        Runtime.getRuntime().addShutdownHook(new Thread("Metrics-Hook" + ((Object)((Object)this)).hashCode()){

            @Override
            public void run() {
                MessageMetricsChannelHandler.this.logger.info("Metrics messages[read={}/count, write={}/count]", (Object)MessageMetricsChannelHandler.this.readMessages, (Object)MessageMetricsChannelHandler.this.writeMessages);
            }
        });
    }

    @Override
    public void onMessageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        MessageMetrics metrics = MessageMetricsChannelHandler.getOrSetMetrics(ctx.channel());
        metrics.incrementRead(1L);
        ctx.fireChannelRead(msg);
    }

    @Override
    protected void onMessageWriter(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        MessageMetrics metrics = MessageMetricsChannelHandler.getOrSetMetrics(ctx.channel());
        metrics.incrementWrote(1L);
        if (promise.isVoid()) {
            ctx.write(msg, promise);
        } else {
            ctx.write(msg, promise).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        MessageMetrics metrics = MessageMetricsChannelHandler.getOrSetMetrics(ctx.channel());
        this.readMessages.getAndAdd(metrics.messagesRead());
        this.writeMessages.getAndAdd(metrics.messagesWrote());
        ctx.close(promise);
    }

    public static MessageMetrics getOrSetMetrics(Channel channel) {
        Attribute attribute = channel.attr(ATTR_KEY_METRICS);
        MessageMetrics metrics = (MessageMetrics)attribute.get();
        if (metrics == null) {
            metrics = new MessageMetrics();
            attribute.set((Object)metrics);
        }
        return metrics;
    }
}

