/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.SystemPropertyUtil;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;

public class NettyUtil {
    private static final float THRESHOLD;
    private static final long MAX_DIRECT_MEMORY;
    private static final AtomicLong DIRECT_MEMORY_COUNTER;

    public static long freeDirectMemory() {
        if (DIRECT_MEMORY_COUNTER == null) {
            return -1L;
        }
        return MAX_DIRECT_MEMORY - DIRECT_MEMORY_COUNTER.get();
    }

    static {
        AtomicLong directMemoryCounter;
        THRESHOLD = SystemPropertyUtil.getFloat("netty-core.directBufferThreshold", 0.7f);
        try {
            Field field = PlatformDependent.class.getDeclaredField("DIRECT_MEMORY_COUNTER");
            field.setAccessible(true);
            directMemoryCounter = (AtomicLong)field.get(null);
        }
        catch (Throwable e) {
            directMemoryCounter = null;
        }
        DIRECT_MEMORY_COUNTER = directMemoryCounter;
        MAX_DIRECT_MEMORY = (long)((float)PlatformDependent.maxDirectMemory() * THRESHOLD);
    }
}

