/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.SystemPropertyUtil;
import com.github.netty.core.util.ThreadPoolX;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class Recycler<T> {
    private static final int DEFAULT_INSTANCE_COUNT = SystemPropertyUtil.getInt("netty-core.recyclerCount", 2);
    private static final boolean ENABLE = SystemPropertyUtil.getBoolean("netty-core.recyclerEnable", true);
    private final int instanceCount;
    private final FastThreadLocal<Queue<T>> queue = new FastThreadLocal<Queue<T>>(){

        protected Queue<T> initialValue() throws Exception {
            return PlatformDependent.newFixedMpscQueue((int)Recycler.this.instanceCount);
        }
    };
    private Supplier<T> supplier;
    private static final List<Recycler> RECYCLER_LIST = new ArrayList<Recycler>();
    public static final LongAdder HIT_COUNT = new LongAdder();
    public static final LongAdder MISS_COUNT = new LongAdder();
    private Thread formThread;

    public Recycler(Supplier<T> supplier) {
        this(DEFAULT_INSTANCE_COUNT, supplier);
    }

    public Recycler(int instanceCount, Supplier<T> supplier) {
        this.instanceCount = instanceCount;
        this.supplier = supplier;
        RECYCLER_LIST.add(this);
        this.formThread = Thread.currentThread();
    }

    public static List<Recycler> getRecyclerList() {
        return RECYCLER_LIST;
    }

    public T getInstance() {
        if (ENABLE) {
            Object value = ((Queue)this.queue.get()).poll();
            if (value == null) {
                value = this.supplier.get();
                MISS_COUNT.increment();
            } else {
                HIT_COUNT.increment();
            }
            return (T)value;
        }
        return this.supplier.get();
    }

    public void recycleInstance(T value) {
        ((Queue)this.queue.get()).offer(value);
    }

    public String toString() {
        return "Recycler{size=" + ((Queue)this.queue.get()).size() + ", formThread=" + this.formThread + '}';
    }

    public static void main(String[] args) throws InterruptedException {
        int count = 10000;
        Recycler<Date> recycler = new Recycler<Date>(() -> {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return new Date();
        });
        ThreadPoolX threadPool = new ThreadPoolX("Test", 16);
        long begin = System.currentTimeMillis();
        CountDownLatch latch = new CountDownLatch(count);
        for (int i = 0; i < count; ++i) {
            threadPool.execute(() -> {
                Date instance = (Date)recycler.getInstance();
                recycler.recycleInstance(instance);
                latch.countDown();
            });
        }
        latch.await();
        long time = System.currentTimeMillis() - begin;
        System.out.printf("time = %d/ms, hit = %s/c, mis = %s/c\n", time, HIT_COUNT, MISS_COUNT);
    }
}

