/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.IOUtil;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class ResourceManager {
    private final RandomAccessFile lock;
    private LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private String rootPath;
    private ClassLoader classLoader;
    private String workspace;

    public ResourceManager(String rootPath) {
        this(rootPath, "");
    }

    public ResourceManager(String rootPath, String workspace) {
        this(rootPath, workspace, ResourceManager.class.getClassLoader());
    }

    public ResourceManager(String rootPath, String workspace, ClassLoader classLoader) {
        RandomAccessFile lock;
        if (rootPath == null || rootPath.isEmpty()) {
            throw new IllegalStateException("path empty");
        }
        this.rootPath = rootPath.startsWith("file:") || rootPath.startsWith("FILE:") ? rootPath.replace("file:", "").replace("FILE:", "") : rootPath;
        if (workspace == null || "/".equals(workspace)) {
            workspace = "";
        }
        if (workspace.length() > 0 && workspace.charAt(0) != '/') {
            workspace = "/".concat(workspace);
        }
        this.workspace = workspace;
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        try {
            File file = this.writeFile(new byte[]{1}, "/", ".lock", true);
            lock = new RandomAccessFile(file, "rwd");
        }
        catch (IOException e) {
            lock = null;
            this.logger.warn("ResourceManager lock file create fail {}", (Object)e.toString());
        }
        this.lock = lock;
        this.logger.info("ResourceManager rootPath : '{}', workspace : '{}'", (Object)rootPath, (Object)workspace);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.lock != null) {
            this.lock.close();
        }
    }

    public int countDir(String path) {
        String basePath;
        Objects.requireNonNull(path);
        if (path.isEmpty() || path.charAt(path.length() - 1) != '/') {
            path = path.concat("/");
        }
        if ((basePath = this.getRealPath(path)) == null) {
            return 0;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return 0;
        }
        String[] theFiles = theBaseDir.list();
        if (theFiles == null) {
            return 0;
        }
        int count = 0;
        String rootPath = basePath.concat(File.separator);
        for (String filename : theFiles) {
            File testFile = new File(rootPath.concat(filename));
            if (!testFile.isDirectory()) continue;
            ++count;
        }
        return count;
    }

    public int countFile(String path) {
        String basePath;
        Objects.requireNonNull(path);
        if (path.isEmpty() || path.charAt(path.length() - 1) != '/') {
            path = path.concat("/");
        }
        if ((basePath = this.getRealPath(path)) == null) {
            return 0;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return 0;
        }
        String[] theFiles = theBaseDir.list();
        if (theFiles == null) {
            return 0;
        }
        int count = 0;
        String rootPath = basePath.concat(File.separator);
        for (String filename : theFiles) {
            File testFile = new File(rootPath.concat(filename));
            if (!testFile.isFile()) continue;
            ++count;
        }
        return count;
    }

    public Set<String> getResourcePaths(String path) {
        String basePath;
        Objects.requireNonNull(path);
        if (path.isEmpty() || path.charAt(path.length() - 1) != '/') {
            path = path.concat("/");
        }
        if ((basePath = this.getRealPath(path)) == null) {
            return null;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return null;
        }
        String[] theFiles = theBaseDir.list();
        if (theFiles == null) {
            return null;
        }
        HashSet<String> thePaths = null;
        String rootPath = basePath.concat(File.separator);
        for (String filename : theFiles) {
            File testFile = new File(rootPath.concat(filename));
            if (testFile.isFile()) {
                if (thePaths == null) {
                    thePaths = new HashSet<String>();
                }
                thePaths.add(filename);
                continue;
            }
            if (!testFile.isDirectory()) continue;
            if (thePaths == null) {
                thePaths = new HashSet();
            }
            thePaths.add(filename.concat("/"));
        }
        return thePaths;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.rootPath == null || this.rootPath.length() == 0) {
            return null;
        }
        if (path.isEmpty() || path.charAt(0) != '/') {
            throw new MalformedURLException("Path '" + path + "' does not start with '/'");
        }
        String realPath = this.getRealPath(path);
        if (realPath == null) {
            return null;
        }
        File file = new File(realPath);
        if (file.exists()) {
            return new URL("file:".concat(realPath));
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            if (path.isEmpty() || path.charAt(0) != '/') {
                this.logger.warn("Path '{}' does not start with '/'", (Object)path);
                return null;
            }
            URL url = this.getResource(path);
            if (url == null) {
                return null;
            }
            return url.openStream();
        }
        catch (IOException e) {
            this.logger.warn("Throwing exception when getResourceAsStream of {}, case {} ", (Object)path, (Object)e.getMessage());
            return null;
        }
    }

    public String getRealPath(String path) {
        if (path == null || path.isEmpty()) {
            path = File.separator;
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = File.separator.concat(path);
        }
        String realPath = this.workspace.isEmpty() ? this.rootPath.concat(path) : this.rootPath.concat(this.workspace).concat(path);
        return realPath;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public File writeFile(InputStream inputStream, String targetPath, String targetFileName) throws IOException {
        return IOUtil.writeFile(inputStream, this.getRealPath(targetPath), targetFileName, false);
    }

    public File writeFile(Iterator<ByteBuffer> dataIterator, String targetPath, String targetFileName) throws IOException {
        return IOUtil.writeFile(dataIterator, this.getRealPath(targetPath), targetFileName, false);
    }

    public File writeFile(byte[] data, String targetPath, String targetFileName) throws IOException {
        return IOUtil.writeFile(data, this.getRealPath(targetPath), targetFileName, false);
    }

    public File writeFile(byte[] data, String targetPath, String targetFileName, boolean append) throws IOException {
        return IOUtil.writeFile(data, this.getRealPath(targetPath), targetFileName, append);
    }

    public FileOutputStream newFileOutputStream(String targetPath, String targetFileName, boolean append) throws IOException {
        return IOUtil.newFileOutputStream(this.getRealPath(targetPath), targetFileName, append);
    }

    public FileInputStream newFileInputStream(String sourcePath, String sourceFileName) throws FileNotFoundException {
        return IOUtil.newFileInputStream(this.getRealPath(sourcePath), sourceFileName);
    }

    public void copyFile(String sourcePath, String sourceFileName, String targetPath, String targetFileName) throws FileNotFoundException, IOException {
        IOUtil.copyFile(this.getRealPath(sourcePath), sourceFileName, this.getRealPath(targetPath), targetFileName, false);
    }

    public boolean mkdirs(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path '" + path + "' must start with '/'");
        }
        return new File(this.getRealPath(path)).mkdirs();
    }

    public boolean delete(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (path.isEmpty() || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path '" + path + "' must start with '/'");
        }
        return IOUtil.deleteDir(new File(this.getRealPath(path)));
    }

    public void deleteChild(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (path.isEmpty() || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path '" + path + "' must start with '/'");
        }
        IOUtil.deleteDirChild(new File(this.getRealPath(path)));
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String toString() {
        return "ResourceManager{rootPath='" + this.rootPath + '\'' + ", workspace='" + this.workspace + '\'' + '}';
    }
}

