/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol;

import com.github.netty.annotation.NRpcMethod;
import com.github.netty.annotation.NRpcService;
import com.github.netty.core.AbstractNettyServer;
import com.github.netty.core.AbstractProtocol;
import com.github.netty.core.util.AnnotationMethodToMethodNameFunction;
import com.github.netty.core.util.ApplicationX;
import com.github.netty.core.util.ClassFileMethodToParameterNamesFunction;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcServerAop;
import com.github.netty.protocol.nrpc.RpcServerChannelHandler;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import com.github.netty.protocol.nrpc.RpcVersion;
import com.github.netty.protocol.nrpc.codec.DataCodecUtil;
import com.github.netty.protocol.nrpc.codec.RpcDecoder;
import com.github.netty.protocol.nrpc.codec.RpcEncoder;
import com.github.netty.protocol.nrpc.service.RpcCommandServiceImpl;
import com.github.netty.protocol.nrpc.service.RpcDBServiceImpl;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;

public class NRpcProtocol
extends AbstractProtocol {
    private final List<RpcServerAop> rpcServerAopList = new ArrayList<RpcServerAop>();
    private final AnnotationMethodToMethodNameFunction annotationMethodToMethodNameFunction = new AnnotationMethodToMethodNameFunction(NRpcMethod.class);
    private LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private ApplicationX application;
    private Supplier<Executor> executorSupplier;
    private int messageMaxLength = 0xA00000;
    private boolean methodOverwriteCheck = true;
    private Map<Object, Instance> instanceMap = new LinkedHashMap<Object, Instance>();
    private String serverDefaultVersion;

    public NRpcProtocol(ApplicationX application) {
        this.application = application;
    }

    public AnnotationMethodToMethodNameFunction getAnnotationMethodToMethodNameFunction() {
        return this.annotationMethodToMethodNameFunction;
    }

    public boolean isMethodOverwriteCheck() {
        return this.methodOverwriteCheck;
    }

    public void setMethodOverwriteCheck(boolean methodOverwriteCheck) {
        this.methodOverwriteCheck = methodOverwriteCheck;
    }

    public String getServerDefaultVersion() {
        return this.serverDefaultVersion;
    }

    public void setServerDefaultVersion(String serverDefaultVersion) {
        this.serverDefaultVersion = serverDefaultVersion;
    }

    public void addInstance(Object instance) {
        this.addInstance(instance, RpcServerChannelHandler.getRequestMappingName(instance.getClass()), new ClassFileMethodToParameterNamesFunction(), this.annotationMethodToMethodNameFunction);
    }

    public void addInstance(Object instance, String requestMappingName, Function<Method, String[]> methodToParameterNamesFunction) {
        this.addInstance(instance, requestMappingName, methodToParameterNamesFunction, this.annotationMethodToMethodNameFunction);
    }

    public void addInstance(Object instance, String requestMappingName, Function<Method, String[]> methodToParameterNamesFunction, Function<Method, String> methodToNameFunction) {
        if (instance instanceof RpcClient.Proxy) {
            return;
        }
        String version = RpcServerInstance.getVersion(instance.getClass(), this.serverDefaultVersion);
        Integer timeout = RpcServerInstance.getTimeout(instance.getClass());
        this.instanceMap.put(instance, new Instance(instance, requestMappingName, version, timeout, methodToParameterNamesFunction, methodToNameFunction, this.methodOverwriteCheck));
        this.logger.info("addInstance({}, {}, {})", RpcServerInstance.getServerInstanceKey(requestMappingName, version), instance.getClass().getSimpleName(), methodToParameterNamesFunction.getClass().getSimpleName());
    }

    public boolean existInstance(Object instance) {
        return this.instanceMap.containsKey(instance);
    }

    @Override
    public String getProtocolName() {
        return RpcVersion.CURRENT_VERSION.getText();
    }

    @Override
    public boolean canSupport(ByteBuf msg) {
        return RpcVersion.CURRENT_VERSION.isSupport(msg);
    }

    @Override
    public void addPipeline(Channel channel) throws Exception {
        super.addPipeline(channel);
        RpcServerChannelHandler rpcServerHandler = new RpcServerChannelHandler();
        rpcServerHandler.setExecutorSupplier(this.executorSupplier);
        rpcServerHandler.getAopList().addAll(this.rpcServerAopList);
        for (Instance instance : this.instanceMap.values()) {
            rpcServerHandler.addRpcServerInstance(instance.requestMappingName, instance.version, instance.checkGetRpcServerInstance());
        }
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new RpcDecoder(this.messageMaxLength)});
        pipeline.addLast(new ChannelHandler[]{new RpcEncoder()});
        pipeline.addLast(new ChannelHandler[]{rpcServerHandler});
    }

    public Supplier<Executor> getExecutorSupplier() {
        return this.executorSupplier;
    }

    public void setExecutorSupplier(Supplier<Executor> executorSupplier) {
        this.executorSupplier = executorSupplier;
    }

    @Override
    public int getOrder() {
        return 200;
    }

    @Override
    public <T extends AbstractNettyServer> void onServerStart(T server) throws Exception {
        List list = this.application.getBeanForAnnotation(NRpcService.class);
        this.rpcServerAopList.clear();
        this.rpcServerAopList.addAll(this.application.getBeanForType(RpcServerAop.class));
        for (Object e : list) {
            if (this.existInstance(e)) continue;
            this.addInstance(e);
        }
        this.addInstancePlugins();
        for (RpcServerAop rpcServerAop : this.rpcServerAopList) {
            rpcServerAop.onInitAfter(this);
        }
        if (this.methodOverwriteCheck) {
            ArrayList<Exception> exceptionList = new ArrayList<Exception>();
            for (Instance instance : this.instanceMap.values()) {
                try {
                    instance.checkGetRpcServerInstance();
                }
                catch (Exception e) {
                    exceptionList.add(e);
                }
            }
            if (!exceptionList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\n\n");
                int i = 1;
                for (Exception exception : exceptionList) {
                    stringJoiner.add("[" + i + "] " + exception.getLocalizedMessage());
                    ++i;
                }
                throw new UnsupportedOperationException("serverMethodOverwriteCheckList: \n" + stringJoiner);
            }
        }
        this.logger.info("used codec = {}", (Object)DataCodecUtil.getDataCodec());
    }

    @Override
    public <T extends AbstractNettyServer> void onServerStop(T server) throws Exception {
    }

    protected void addInstancePlugins() {
        this.addInstance(new RpcCommandServiceImpl());
        this.addInstance(new RpcDBServiceImpl());
    }

    protected ApplicationX getApplication() {
        return this.application;
    }

    public int getMessageMaxLength() {
        return this.messageMaxLength;
    }

    public void setMessageMaxLength(int messageMaxLength) {
        this.messageMaxLength = messageMaxLength;
    }

    static class Instance {
        private String requestMappingName;
        private String version;
        private Integer timeout;
        private RpcServerInstance rpcServerInstance;
        private Exception rpcServerInstanceException;

        Instance(Object instance, String requestMappingName, String version, Integer timeout, Function<Method, String[]> methodToParameterNamesFunction, Function<Method, String> methodToNameFunction, boolean methodOverwriteCheck) {
            this.requestMappingName = requestMappingName;
            this.version = version;
            this.timeout = timeout;
            try {
                this.rpcServerInstance = new RpcServerInstance(instance, null, version, timeout, methodToParameterNamesFunction, methodToNameFunction, methodOverwriteCheck);
            }
            catch (Exception e) {
                this.rpcServerInstanceException = e;
            }
        }

        public RpcServerInstance checkGetRpcServerInstance() throws Exception {
            if (this.rpcServerInstanceException != null) {
                throw this.rpcServerInstanceException;
            }
            return this.rpcServerInstance;
        }
    }
}

